package edu.gwu.simplenetsim;

import edu.gwu.simplenetsim.*;

import java.util.*;


/**
 * A network layer must implement this interface, which derives from
 * <code>StackLayer</code>.
 *
 * @author Rahul Simha
 * @see StackLayer
 */

public interface NetworkLayer extends StackLayer {


    /**
     * The simulator calls this method at time=0 to initialize.
     *
     * @param nodeNum an <code>int</code> value, the node ID.
     * @param transportLayer a <code>TransportLayer</code> value, a ref to the layer above.
     * @param datalinkLayer a <code>DatalinkLayer</code> value, the layer below.
     * @param neighbors an <code>ArrayList<Integer></code> value, the list of nodeIDs of neighboring nodes. Note that two-way links are assumed.
     */

    public void init (int nodeNum, TransportLayer transportLayer, DatalinkLayer datalinkLayer, ArrayList<Integer> neighbors);


    /**
     * This is called by the layer above to send a packet. It should
     * call the layer below.
     *
     * @param packet a <code>NetworkPacket</code> value
     */

    public void sendPacket (NetworkPacket packet);


    /**
     * This is called by the layer below. It should send a packet up to
     * the transport layer.
     *
     * @param packet a <code>NetworkPacket</code> value
     */

    public void receivePacket (NetworkPacket packet);


    /**
     * This is called by the simulator at regular intervals to 
     * indicate the status of a link. It should be used to 
     * possibly trigger a round of routing computations.
     * The status is about the link between this node and the
     * specified neighbor.
     *
     * @param neighbor an <code>int</code> value
     * @param status a <code>LinkStatus</code> value
     */

    public void updateLinkStatus (int neighbor, LinkStatus status);

}
