package edu.gwu.simplenetsim;

import edu.gwu.simplenetsim.*;

import java.util.*;
import java.io.*;


/**
 * Use the class <code>Debug</code> to help create debugging output
 * in the file "debug.dat". You can call <code>Debug.println()</code>
 * from anywhere in the code. If debugging is turned on (in the GUI),
 * then your stuff gets into the file "debug.dat".
 *
 * @author Rahul Simha
 */

public class Debug {

    /**
     * This variable determines whether or not debug output is
     * written to the file. It is set by the GUI.
     */
    public static boolean debug = false;

    static PrintWriter debugWriter;
    static boolean isSet;
    static String defaultFileName = "debug.data";
    
    static {
	isSet = false;
    }


    public static void setOutputFile (boolean useFile, String dirName, String fileName)
    {
	// System.out.println ("Debug.setOutputFile: u=" + useFile + " d=" + dirName + " f=" + fileName);
	
	
	if (isSet)
	    return ;
	
	if ( (!useFile) || (fileName == null) ) {
	    debugWriter = new PrintWriter (System.out);
	}
	else if (dirName != null) {
	    try {
		debugWriter = new PrintWriter (new FileWriter (dirName + "/" + fileName));
	    }
	    catch (IOException e) {
		System.out.println ("ERR: Debug.setOutputFile1: could not open debug file=" + fileName);
		System.exit (1);
	    }
	}
	else {
	    try {
		debugWriter = new PrintWriter (new FileWriter (fileName));
	    }
	    catch (IOException e) {
		System.out.println ("ERR: Debug.setOutputFile2: could not open debug file=" + fileName);
		System.exit (1);
	    }
	}
    
	isSet = true;
    }
  
    public static boolean isSet ()
    {
	return isSet;
    }
  

    /**
     * Equivalent to <code>System.out.print()</code>
     *
     * @param str a <code>String</code> value
     */
    public static void print (String str)
    {
	if (!debug) {
	    return;
	}
	if (!isSet())
	    setOutputFile (true, null, defaultFileName);
	debugWriter.print (str);
    }
  

    /**
     * Equivalent to <code>System.out.println()</code>
     *
     * @param str a <code>String</code> value
     */

    public static void println (String str)
    {
	if (!debug) {
	    return;
	}
	if (!isSet())
	    setOutputFile (true, null, defaultFileName);
	debugWriter.println (str);
	debugWriter.flush();
    }

    public static void print (Object obj)
    {
	if (!debug) {
	    return;
	}
	print (obj.toString());
    }
  
    public static void println (Object obj)
    {
	if (!debug) {
	    return;
	}
	println (obj.toString());
    }
  
  
    public static void error (String str)
    {
	if (!debug) {
	    return;
	}
	System.out.println ("ERROR: " + str);
	println (str);
    }
    

    public static void close ()
    {
	if (!isSet())
	    return;
	debugWriter.close();
    }
  
    public static PrintWriter getPrintWriter ()
    {
	if (!isSet())
	    return null;
	return debugWriter;
    }
}
