package edu.gwu.simplenetsim;

import edu.gwu.simplenetsim.*;


/**
 * An implementation of the datalink layer must implement this
 * interface, which itself extends <code>StackLayer</code>.
 *
 * @author Rahul Simha
 * @see StackLayer
 */

public interface DatalinkLayer extends StackLayer {


    /**
     * Initialization passes in the layers above and below.
     *
     * @param nodeNum an <code>int</code> value
     * @param networkLayer a <code>NetworkLayer</code> value
     * @param physicalLayer a <code>PhysicalLayer</code> value
     */
    
public void init (int nodeNum, NetworkLayer networkLayer, PhysicalLayer physicalLayer);


    /**
     * This is called by the layer above.
     *
     * @param packet a <code>DatalinkPacket</code> value
     */

    public void sendPacket (DatalinkPacket packet);


    /**
     * This is called by the layer below, in this case, the simulator.
     *
     * @param packet a <code>DatalinkPacket</code> value
     */

    public void receivePacket (DatalinkPacket packet);

}
