package edu.gwu.simplenetsim;

import edu.gwu.simplenetsim.*;


/**
 * Used to store data about connections that are read from the
 * parameter file and used by the simulator to randomly generate
 * packets. This class is used by the simulator and should 
 * not matter to the layers. 
 *
 * @author Rahul Simha
 */

public class Connection {

    // Connection status.
    static int UNOPENED;
    static int WAITING = 1;
    static int ACTIVE = 2;
    static int CLOSED = 3;

    int connNum;              // This is from the data file.
    int src, dest;            // End points of the connection.
    int startTime, endTime;   // When it starts and ends.
    double packetRate;        // Pr[a packet is generated in a time slot].
    int status = 0;           // Current status.
    int connID;               // The connection ID assigned by the transport layer.
    int packetCount = 0;      // Number packets so far.


    public String toString () 
    {
	return "Conn(ID=" + connID + ",connNum=" + connNum + ",src=" + src + ",dest=" + dest + ",start=" + startTime + ",end=" + endTime + ",rate=" + packetRate + ",status=" + statusStr(status) + ",packetCount=" + packetCount + ")";
    }

    String statusStr (int s)
    {
	if (s == UNOPENED) {
	    return "UNOPENED";
	}
	else if (s == WAITING) {
	    return "WAITING";
	}
	else if (s == ACTIVE) {
	    return "ACTIVE";
	}
	else if (s == CLOSED) {
	    return "CLOSED";
	}
	else {
	    return "ERROR";
	}
    }
}

