package edu.gwu.simplenetsim;

import edu.gwu.simplenetsim.*;


/**
 * This interface must be implemented by a web browser.
 *
 * @author Rahul Simha
 */

public interface WebBrowser {

    /**
     * Initialization includes the node's ID, destination port number (usually 80), and a random source port number (such as 10000).
     * and the transport layer.
     *
     * @param nodeNum an <code>int</code> value
     * @param transport a <code>TransportLayer</code> value
     * @param sourcePortNum an <code>int</code> value
     * @param destPortNum an <code>int</code> value
     */

    public void init (int nodeNum, TransportLayer transport, int sourcePortNum, int destPortNum);


    /**
     * Method <code>transmitSTTPRequest</code> is called by the 
     * simulator to ask the browser whether it needs to transmit
     * an STTP request to layers below. The reason the simulator needs
     * to keep calling this is to allow a browser to call 
     * <code>isReady()</code> in the transport layer, which checks
     * whether a connection has been set up.
     *
     */

    public void transmitSTTPRequest ();

    /**
     * Method <code>receiveSTTPResponse</code> is called by the 
     * simulator to give the browser a packet received from the
     * destination webserver.
     *
     */

    public void receiveSTTPResponse (TransportPacket responsePacket);

    /**
     * The simulator calls this method, asking the browser to display
     * itself in a frame by itself.
     *
     */
    public void display ();


    /**
     * Is the browser displayed? We use this to check, in case the
     * user has closed the window.
     *
     * @return a <code>boolean</code> value
     */

    public boolean isDisplayed ();

}
