package edu.gwu.simplenetsim;

import edu.gwu.simplenetsim.*;


/**
 * This is the packet that is handled by the transport layer and,
 * for simplicity, the application layer as well. Fields can be
 * set by the constructor or directly.
 *
 * @author Rahul Simha
 * @see NetsimPacket
 */

public class TransportPacket extends NetsimPacket {

    /**
     *  The connection identifier.
     */
    public int connID;

    /**
     * Source node ID.
     */
    public int src;

    /**
     * Destination node ID.
     */
    public int dest;

    /**
     * The payload is a string.
     */
    public String data;

    /**
     * Sequence numbers are used by protocols.
     */
    public int seqnum = 0;

    /**
     * Receiving port number. This is currently being used only
     * by the webserver.
     */
    public int portNum = 0;


    /**
     * Constructor: Creates a new <code>TransportPacket</code> instance.
     *
     * @param connID an <code>int</code> value
     * @param src an <code>int</code> value
     * @param dest an <code>int</code> value
     * @param portNum an <code>int</code> value
     * @param data a <code>String</code> value
     */

    public TransportPacket (int connID, int src, int dest, int portNum, String data)
    {
	this.connID = connID;
	this.src = src;
	this.dest = dest;
	this.data = data;
	this.portNum = portNum;
    }


    /**
     * Optional empty constructor.
     *
     */
    public TransportPacket ()
    {
    }


    /**
     * For debugging.
     *
     * @return a <code>String</code> value
     */
    public String toString () {
	return "TransportPacket(connID=" + connID + ",src=" + src + ",dest=" + dest + ",port=" + portNum + ",seq=" + seqnum + ",content=\"" + data + "\")";
    }

}
