
package edu.gwu.simplenetsim;

import edu.gwu.simplenetsim.*;

/**
 * Every layer derives from this, which has one method to implement.
 *
 * @author Rahul Simha
 */

public interface StackLayer {

    /**
     * This method is called by the simulator to indicate that
     * a timer has gone off. Time is counted in integer units.
     *
     * @param timerID an <code>int</code> value
     * @param time an <code>int</code> value
     */
    
    public void timerBeep (int timerID, int time);

}
