package edu.gwu.simplenetsim;

import edu.gwu.simplenetsim.*;
import java.util.*;


/**
 * Used by the simulator.
 *
 * @author Rahul Simha
 */

public class Node {

    int nodeNum = -1;  // Node ID.
    double x,y;        // x,y values in the range [1,10] for screen display.
    int drawX, drawY;  // The actual Java coords once drawn.

    // This node's neighbors. The int's are the ID's.
    ArrayList<Integer> neighbors = new ArrayList<Integer>();

    // One layer instance per node.
    TransportLayer transportLayer;
    NetworkLayer networkLayer;
    DatalinkLayer datalinkLayer;
    WebBrowser webbrowser;
    WebServer webserver;

    // A queue of packets that have arrived and need processing.
    LinkedList<DatalinkPacket> arrivals;

    public String toString () 
    {
	return "Node " + nodeNum + "(#arr=" + arrivals.size() + ")";
    }
}
