package edu.gwu.simplenetsim;

import edu.gwu.simplenetsim.*;


/**
 * This class contains all the packet info for a network-level packet,
 * including the whole transport-packet. There are a number of public
 * fields, all of which are typical in network layers.
 *
 * @author Rahul Simha
 * @see NetsimPacket
 */

public class NetworkPacket extends NetsimPacket {

    /**
     * Where it came from.
     */
    public int src;

    /**
     * Where it needs to go.
     */
    public int dest;

    /**
     * The payload.
     */
    public TransportPacket data;

    /**
     * Is this a control packet, generated solely by and used by
     * network layers?
     */
    public boolean isControl = false;

    /**
     * The control payload.
     */
    public String controlInfo;

    /**
     * Sequence numbers.
     */
    public int seqnum = 0;

    /**
     * Long-lived packets are often assumed to be useless and are
     * discarded. 
     */
    public int timeToLive = Integer.MAX_VALUE;


    /**
     * The constructor for regular packets.
     *
     * @param src an <code>int</code> value
     * @param dest an <code>int</code> value
     * @param data a <code>TransportPacket</code> value
     */
    public NetworkPacket (int src, int dest, TransportPacket data)
    {
	this.src = src;
	this.dest = dest;
	this.data = data;
	isControl = false;
    }


    /**
     * The constructor for control packets.
     *
     * @param src an <code>int</code> value
     * @param dest an <code>int</code> value
     * @param controlInfo a <code>String</code> value
     */
    public NetworkPacket (int src, int dest, String controlInfo)
    {
	this.src = src;
	this.dest = dest;
	this.controlInfo = controlInfo;
	isControl = true;
    }


    /**
     * For debugging.
     *
     * @return a <code>String</code> value
     */

    public String toString () {
	return "NetworkPacket(src=" + src + ",dest=" + dest + ",seq=" + ",isControl=" + isControl + ",content=" + data + ")";
    }

}
