
import edu.gwu.simplenetsim.*;

public class DefaultDatalinkLayer implements DatalinkLayer {

    int nodeNum;
    NetworkLayer networkLayer;
    PhysicalLayer physicalLayer;

    public void timerBeep (int timerID, int time)
    {
	// This implements the StackLayer interface and is intended
	// for letting the datalink layer set timers and know when
	// they've gone off.
    }


    public void init (int nodeNum, NetworkLayer networkLayer, PhysicalLayer physicalLayer)
    {
	this.nodeNum = nodeNum;
	this.networkLayer = networkLayer;
	this.physicalLayer = physicalLayer;
	Debug.println (">> >> >> DefaultDatalinkLayer: node=" + nodeNum + " initialized");
    }

    public void sendPacket (DatalinkPacket packet)
    {
	// Dumb datalink layer just dumps the packet downstairs.
	Debug.println (">> >> >> Datalink: sending packet=" + packet);
	physicalLayer.transmit (nodeNum, packet.toNeighbor, packet);
    }

    public void receivePacket (DatalinkPacket packet)
    {
	// Dumb datalink layer just passes it upstairs.
	Debug.println (">> >> >> Datalink: received packet=" + packet);
	networkLayer.receivePacket (packet.data);
    }

}
