package edu.gwu.simplenetsim;

import edu.gwu.simplenetsim.*;


/**
 * This interface needs to be implemented by webservers.
 *
 * @author Rahul Simha
 */

public interface WebServer {


    /**
     * Initialization info.
     *
     * @param nodeNum an <code>int</code> value
     * @param transport a <code>TransportLayer</code> value
     * @param sourcePortNum an <code>int</code> value
     * @param destPortNum an <code>int</code> value
     */

    public void init (int nodeNum, TransportLayer transport, int sourcePortNum, int destPortNum);

    /**
     * The simulator calls this method with a packet that has the
     * one and only STTP protocol packet - to request a file.
     *
     * @param packet a <code>TransportPacket</code> value
     */

    public void receiveSTTPRequest (TransportPacket packet);


    /**
     * The simulator calls this regularly to ask the webserver
     * to send any un-sent data to the transport layer below.
     * One may ask: why doesn't the webserver send the whole file
     * as one string? It's more realistic to send multiple strings,
     * say, one string per line in the text file. Thus, the webserver
     * should send one line at a time, which is why we need to keep
     * calling the webserver to say "Got a line to send? Send it now.".
     *
     */

    public void sendData ();

}
