package edu.gwu.simplenetsim;

import edu.gwu.simplenetsim.*;
import java.util.*;
import java.awt.*;


/**
 * Used by the simulator.
 *
 * @author Rahul Simha
 */

public class Edge {

    // The ends of this directed edge.
    int fromNode = -1,  toNode = -1;

    // A queue of packets scheduled to traverse this edge.
    LinkedList<DatalinkPacket> queue;

    // For data about the link used in routing.
    double linkStatusTotal;

    // Animation related stuff.
    double animX, animY;
    boolean animDone;
    double animAngle;
    Color currentColor;
    
    public String toString () 
    {
	return "Edge(" + fromNode + "," + toNode + ",qSize=" + queue.size() + ")";
    }
}

