package edu.gwu.simplenetsim;

import edu.gwu.simplenetsim.*;


/**
 * The class that contains stuff for a datalink-layer packet. The
 * class has a number of public fields typical in datalink packets.
 *
 * @author Rahul Simha
 * @see NetsimPacket
 */

public class DatalinkPacket extends NetsimPacket {
    
    /**
     * Who is this from?
     */
    public int fromNeighbor;

    /**
     * Where is it going? This can only be a neighbor.
     */
    public int toNeighbor;

    /**
     * The payload.
     */
    public NetworkPacket data;

    /**
     * Is this a control packet, generated by and used solely by 
     * datalink layers?
     */
    public boolean isControl = false;

    /**
     * The control payload.
     */
    public String controlInfo;

    /**
     * The well-known sequence-number field.
     */
    public int seqnum = 0;


    /**
     * Constructor used for regular packets.
     *
     * @param fromNeighbor an <code>int</code> value
     * @param toNeighbor an <code>int</code> value
     * @param data a <code>NetworkPacket</code> value
     */
    public DatalinkPacket (int fromNeighbor, int toNeighbor, NetworkPacket data){
	this.fromNeighbor = fromNeighbor;
	this.toNeighbor = toNeighbor;
	this.data = data;
	isControl = false;
    }


    /**
     * Constructor used by control packets.
     *
     * @param fromNeighbor an <code>int</code> value
     * @param toNeighbor an <code>int</code> value
     * @param controlInfo a <code>String</code> value
     */

    public DatalinkPacket (int fromNeighbor, int toNeighbor, String controlInfo)
    {
	this.fromNeighbor = fromNeighbor;
	this.toNeighbor = toNeighbor;
	this.controlInfo = controlInfo;
	isControl = true;
    }


    /**
     * For debugging.
     *
     * @return a <code>String</code> value
     */

    public String toString () {
	return "DatalinkPacket(from=" + fromNeighbor + ",to=" + toNeighbor + ",seq=" + ",controlInfo=" + controlInfo + ",content=" + data + ")";
    }

}
