package edu.gwu.simplenetsim;

import edu.gwu.simplenetsim.*;


/**
 * The transport layer should call this method when it receives
 * a packet on a particular connection. For convenience, we are
 * going to keep all the packet's info in the packet itself and
 * send that to the Application layer, although it is not 
 * technically equivalent to what TCP does.
 *
 * @author Rahul Simha
 */

public interface ApplicationLayer {

    // Technically, the app layer should not have to understand
    // transport packets. But we are fudging the application
    // layer here to make it simple.

    public void receive (TransportPacket packet);

}
