
import edu.gwu.simplenetsim.*;
import java.util.*;

public class DefaultTransportLayer implements TransportLayer {

    static int connIDCount = 0;
    
    int nodeNum;
    NetworkLayer networkLayer;
    ApplicationLayer appLayer;
    Hashtable<Integer, ConnectionInfo> liveConnections;

    public void timerBeep (int timerID, int time)
    {
	// This implements the StackLayer interface and is intended
	// for letting the this layer set timers and know when
	// they've gone off.
    }

    public void init (int nodeNum, ApplicationLayer appLayer, NetworkLayer networkLayer)
    {
	this.nodeNum = nodeNum;
	this.networkLayer = networkLayer;
	this.appLayer = appLayer;
	Debug.println (">> DefaultTransportLayer: node=" + nodeNum + " initialized");
	liveConnections = new Hashtable<Integer, ConnectionInfo> ();
    }

    public int openConnection (int src, int dest, int portNum)
    {
	// Set up a connection.

	connIDCount ++;
	int connID = connIDCount;
	Debug.println (">> DefaultTransportLayer: node=" + nodeNum + ": opened conn ID=" + connIDCount + " src=" + src + " dest=" + dest);
	ConnectionInfo cInfo = new ConnectionInfo (connID, src, dest, portNum);
	liveConnections.put (connID, cInfo);

	return connID;
    }


    public boolean isReady (int connID) 
    {
	// We haven't done any connection set up.
	return true;
    }


    public void sendPacket (TransportPacket packet)
    {
	// We should maintain a list of sent packets in case some
	// get lost. We should also do sequence numbers to get the
	// order right at the destination. But our default is going
	// to be dumb. 

	// Get the info for this.
	ConnectionInfo cInfo = liveConnections.get (packet.connID);
	// We should be doing some error checking here, undoubedtly.

	if (packet.portNum <= 0) {
	    packet.portNum = cInfo.portNum;
	}

	NetworkPacket npacket = new NetworkPacket (cInfo.src, cInfo.dest, packet);

	Debug.println (">> DefaultTransportLayer: node=" + nodeNum + ": about to send packet: connID=" + packet.connID + " src=" + cInfo.src + " dest=" + cInfo.dest + " transportPacket=" + packet);

	networkLayer.sendPacket (npacket);
    }


    public void receivePacket (TransportPacket packet)
    {
	// Send the data part up to the application layer.

	Debug.println (">> DefaultTransportLayer: node=" + nodeNum + ": received packet: connID=" + packet.connID + " src=" + packet.src + " dest=" + packet.dest + " packet=" + packet);
	
	// With our dumb protocol, we have to be forgiving and set
	// up a connection for any connID.
	ConnectionInfo cInfo = liveConnections.get (packet.connID);
	if (cInfo == null) {
	    // Make a new one. We'll have to figure out how to close this.
	    cInfo = new ConnectionInfo (packet.connID, packet.src, packet.dest, packet.portNum);
	    liveConnections.put (packet.connID, cInfo);
	}

	appLayer.receive (packet);
    }


    public void closeConnection (int connID)
    {
	ConnectionInfo cInfo = liveConnections.get (connID);
	liveConnections.remove (cInfo);

	Debug.println (">> DefaultTransportLayer: node=" + nodeNum + ": closed conn ID=");
    }

}

class ConnectionInfo {
    int connID;
    int src, dest;
    int portNum;
    public ConnectionInfo (int connID, int src, int dest, int portNum)
    {
	this.connID = connID;  
	this.src = src;  
	this.dest = dest; 
	this.portNum = portNum;
    }
}
