
import edu.gwu.simplenetsim.*;
import java.util.*;
import java.io.*;


/**
 * A simple web server implemention for SimpleNetSim.
 *
 * @author Rahul Simha
 * @see WebServer
 */

public class DefaultWebServer implements WebServer {

    // Our ID and transport layer.
    int nodeNum;
    TransportLayer transportLayer;
    int sourcePortNum;                 // The web server's port number (80).
    int destPortNum;                   // The web browser's port number (10000).

    // We are going to read a text file line-by-line and store
    // the separate lines. Each line will be sent as a separate packet.
    ArrayList<String> data = new ArrayList<String>();
    TransportPacket requestPacket;

    public void init (int nodeNum, TransportLayer transportLayer, int sourcePortNum, int destPortNum)
    {
	this.nodeNum = nodeNum;
	this.transportLayer = transportLayer;
	this.sourcePortNum = sourcePortNum;
	this.destPortNum = destPortNum;
    }

    public void receiveSTTPRequest (TransportPacket requestPacket)
    {
	this.requestPacket = requestPacket;
	Debug.println ("DefaultWebServer.receiveSTTPRequest(): nodeNum=" + nodeNum + " request-packet=" + requestPacket);
	data = new ArrayList<String>();
	// Assumes: request is a filename.
	try {
	    LineNumberReader lnr = new LineNumberReader (new FileReader (requestPacket.data));
	    String line = lnr.readLine ();
	    while (line != null) {
		data.add (line);
		line = lnr.readLine ();
	    }
	}
	catch (IOException e) {
	    System.out.println (e);
	    data.add ("ERROR 404: No such file");
	}
    }

    public void sendData ()
    {
	if (data.size() == 0) {
	    return;
	}
	TransportPacket packet = new TransportPacket ();
	packet.src = nodeNum;
	packet.dest = requestPacket.src;
	packet.connID = requestPacket.connID;
	packet.portNum = destPortNum;
	packet.data = data.remove (0);
	Debug.println ("DefaultWebServer.sendData(): sending transportpacket=" + packet);
	transportLayer.sendPacket (packet);
    }

}
