
import edu.gwu.simplenetsim.*;

import java.util.*;

public class DefaultNetworkLayer implements NetworkLayer {

    int nodeNum;
    TransportLayer transportLayer;
    DatalinkLayer datalinkLayer;
    ArrayList<Integer> neighbors;


    public void timerBeep (int timerID, int time)
    {
	// This implements the StackLayer interface and is intended
	// for letting the this layer set timers and know when
	// they've gone off.
    }


    public void init (int nodeNum, TransportLayer transportLayer, DatalinkLayer datalinkLayer, ArrayList<Integer> neighbors)
    {
	this.nodeNum = nodeNum;
	this.transportLayer = transportLayer;
	this.datalinkLayer = datalinkLayer;
	this.neighbors = neighbors;
	Debug.println (">> >> DefaultNetworkLayer node=" + nodeNum + ": initialized");
    }

    public void sendPacket (NetworkPacket packet)
    {
	route (packet);
    }

    public void receivePacket (NetworkPacket packet)
    {
	route (packet);
    }

    public void updateLinkStatus (int neighbor, LinkStatus status)
    {
	// We do nothing now. Of course, a real network layer
	// will react to this and set off a round of route
	// computations.
        //System.out.println ("DefNetLayer.updateLinkStatus: node=" + nodeNum + " neighbor=" + neighbor + " statusValue=" + status.linkValue);
        
    }


    void route (NetworkPacket packet)
    {
	Debug.println (">> >> NetworkLayer node=" + nodeNum + ": received packet packet=" + packet);

	// First check if the packet is meant for us.
	if (packet.dest == this.nodeNum) {
	    // Yes, send it upstairs.
	    Debug.println (" >> >> > reached dest: sending up to transport");
	    transportLayer.receivePacket (packet.data);
	    return;
	}
	
	// Otherwise we need to forward it to one of our neighbors.
	// We will use the horribly naive (and wrong) algorithm of 
	// "find the closest neighbor using nodeID".
	int closest = neighbors.get (0);
	for (int k: neighbors) {
	    if (Math.abs(k-packet.dest) < closest) {
		closest = k;
	    }
	}
	// Now send to closest.
	DatalinkPacket dpacket = new DatalinkPacket (this.nodeNum, closest, packet);
	Debug.println (" >> >> > sending it on to node " + closest);
	datalinkLayer.sendPacket (dpacket);
    }

}
