/*
 * Decompiled with CFR 0.152.
 */
package edu.gwu.lintool;

import edu.gwu.lintool.JMatrix;

public class LUDecomposition {
    private double[][] LU;
    private int m;
    private int n;
    private int pivsign;
    private int[] piv;

    public LUDecomposition(JMatrix jMatrix) {
        this.LU = jMatrix.getArrayCopy();
        this.m = jMatrix.getRowDimension();
        this.n = jMatrix.getColumnDimension();
        this.piv = new int[this.m];
        for (int i = 0; i < this.m; ++i) {
            this.piv[i] = i;
        }
        this.pivsign = 1;
        double[] dArray = new double[this.m];
        for (int i = 0; i < this.n; ++i) {
            double d;
            int n;
            int n2;
            for (n2 = 0; n2 < this.m; ++n2) {
                dArray[n2] = this.LU[n2][i];
            }
            n2 = 0;
            while (n2 < this.m) {
                double[] dArray2 = this.LU[n2];
                n = Math.min(n2, i);
                d = 0.0;
                for (int j = 0; j < n; ++j) {
                    d += dArray2[j] * dArray[j];
                }
                int n3 = n2++;
                double d2 = dArray[n3] - d;
                dArray[n3] = d2;
                dArray2[i] = d2;
            }
            n2 = i;
            for (n = i + 1; n < this.m; ++n) {
                if (!(Math.abs(dArray[n]) > Math.abs(dArray[n2]))) continue;
                n2 = n;
            }
            if (n2 != i) {
                for (n = 0; n < this.n; ++n) {
                    d = this.LU[n2][n];
                    this.LU[n2][n] = this.LU[i][n];
                    this.LU[i][n] = d;
                }
                n = this.piv[n2];
                this.piv[n2] = this.piv[i];
                this.piv[i] = n;
                this.pivsign = -this.pivsign;
            }
            if (!(i < this.m & this.LU[i][i] != 0.0)) continue;
            for (n = i + 1; n < this.m; ++n) {
                double[] dArray3 = this.LU[n];
                int n4 = i;
                dArray3[n4] = dArray3[n4] / this.LU[i][i];
            }
        }
    }

    public LUDecomposition(JMatrix jMatrix, int n) {
        int n2;
        this.LU = jMatrix.getArrayCopy();
        this.m = jMatrix.getRowDimension();
        this.n = jMatrix.getColumnDimension();
        this.piv = new int[this.m];
        for (n2 = 0; n2 < this.m; ++n2) {
            this.piv[n2] = n2;
        }
        this.pivsign = 1;
        for (n2 = 0; n2 < this.n; ++n2) {
            int n3;
            int n4 = n2;
            for (n3 = n2 + 1; n3 < this.m; ++n3) {
                if (!(Math.abs(this.LU[n3][n2]) > Math.abs(this.LU[n4][n2]))) continue;
                n4 = n3;
            }
            if (n4 != n2) {
                for (n3 = 0; n3 < this.n; ++n3) {
                    double d = this.LU[n4][n3];
                    this.LU[n4][n3] = this.LU[n2][n3];
                    this.LU[n2][n3] = d;
                }
                n3 = this.piv[n4];
                this.piv[n4] = this.piv[n2];
                this.piv[n2] = n3;
                this.pivsign = -this.pivsign;
            }
            if (this.LU[n2][n2] == 0.0) continue;
            for (n3 = n2 + 1; n3 < this.m; ++n3) {
                double[] dArray = this.LU[n3];
                int n5 = n2;
                dArray[n5] = dArray[n5] / this.LU[n2][n2];
                for (int i = n2 + 1; i < this.n; ++i) {
                    double[] dArray2 = this.LU[n3];
                    int n6 = i;
                    dArray2[n6] = dArray2[n6] - this.LU[n3][n2] * this.LU[n2][i];
                }
            }
        }
    }

    public boolean isNonsingular() {
        for (int i = 0; i < this.n; ++i) {
            if (this.LU[i][i] != 0.0) continue;
            return false;
        }
        return true;
    }

    public JMatrix getL() {
        JMatrix jMatrix = new JMatrix(this.m, this.n);
        double[][] dArray = jMatrix.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                dArray[i][j] = i > j ? this.LU[i][j] : (i == j ? 1.0 : 0.0);
            }
        }
        return jMatrix;
    }

    public JMatrix getU() {
        JMatrix jMatrix = new JMatrix(this.n, this.n);
        double[][] dArray = jMatrix.getArray();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                dArray[i][j] = i <= j ? this.LU[i][j] : 0.0;
            }
        }
        return jMatrix;
    }

    public int[] getPivot() {
        int[] nArray = new int[this.m];
        for (int i = 0; i < this.m; ++i) {
            nArray[i] = this.piv[i];
        }
        return nArray;
    }

    public double[] getDoublePivot() {
        double[] dArray = new double[this.m];
        for (int i = 0; i < this.m; ++i) {
            dArray[i] = this.piv[i];
        }
        return dArray;
    }

    public double det() {
        if (this.m != this.n) {
            System.out.println("LinTool.LU.det() Matrix must be square.");
            System.exit(0);
        }
        double d = this.pivsign;
        for (int i = 0; i < this.n; ++i) {
            d *= this.LU[i][i];
        }
        return d;
    }

    public JMatrix solve(JMatrix jMatrix) {
        int n;
        int n2;
        int n3;
        if (jMatrix.getRowDimension() != this.m) {
            System.out.println("LinTool.LU.solve(): Matrix row dimensions must agree.");
            System.exit(0);
        }
        if (!this.isNonsingular()) {
            System.out.println("LinTool.LU.solve(): Matrix is singular");
            System.exit(0);
        }
        int n4 = jMatrix.getColumnDimension();
        JMatrix jMatrix2 = jMatrix.getMatrix(this.piv, 0, n4 - 1);
        double[][] dArray = jMatrix2.getArray();
        for (n3 = 0; n3 < this.n; ++n3) {
            for (n2 = n3 + 1; n2 < this.n; ++n2) {
                for (n = 0; n < n4; ++n) {
                    double[] dArray2 = dArray[n2];
                    int n5 = n;
                    dArray2[n5] = dArray2[n5] - dArray[n3][n] * this.LU[n2][n3];
                }
            }
        }
        for (n3 = this.n - 1; n3 >= 0; --n3) {
            n2 = 0;
            while (n2 < n4) {
                double[] dArray3 = dArray[n3];
                int n6 = n2++;
                dArray3[n6] = dArray3[n6] / this.LU[n3][n3];
            }
            for (n2 = 0; n2 < n3; ++n2) {
                for (n = 0; n < n4; ++n) {
                    double[] dArray4 = dArray[n2];
                    int n7 = n;
                    dArray4[n7] = dArray4[n7] - dArray[n3][n] * this.LU[n2][n3];
                }
            }
        }
        return jMatrix2;
    }
}

