/*
 * Decompiled with CFR 0.152.
 */
package edu.gwu.lintool;

import edu.gwu.lintool.JMatrix;
import edu.gwu.lintool.Maths;

public class QRDecomposition {
    private double[][] QR;
    private int m;
    private int n;
    private double[] Rdiag;

    public QRDecomposition(JMatrix jMatrix) {
        this.QR = jMatrix.getArrayCopy();
        this.m = jMatrix.getRowDimension();
        this.n = jMatrix.getColumnDimension();
        this.Rdiag = new double[this.n];
        for (int i = 0; i < this.n; ++i) {
            int n;
            double d = 0.0;
            for (n = i; n < this.m; ++n) {
                d = Maths.hypot(d, this.QR[n][i]);
            }
            if (d != 0.0) {
                if (this.QR[i][i] < 0.0) {
                    d = -d;
                }
                for (n = i; n < this.m; ++n) {
                    double[] dArray = this.QR[n];
                    int n2 = i;
                    dArray[n2] = dArray[n2] / d;
                }
                double[] dArray = this.QR[i];
                int n3 = i;
                dArray[n3] = dArray[n3] + 1.0;
                for (n = i + 1; n < this.n; ++n) {
                    int n4;
                    double d2 = 0.0;
                    for (n4 = i; n4 < this.m; ++n4) {
                        d2 += this.QR[n4][i] * this.QR[n4][n];
                    }
                    d2 = -d2 / this.QR[i][i];
                    for (n4 = i; n4 < this.m; ++n4) {
                        double[] dArray2 = this.QR[n4];
                        int n5 = n;
                        dArray2[n5] = dArray2[n5] + d2 * this.QR[n4][i];
                    }
                }
            }
            this.Rdiag[i] = -d;
        }
    }

    public boolean isFullRank() {
        for (int i = 0; i < this.n; ++i) {
            if (this.Rdiag[i] != 0.0) continue;
            return false;
        }
        return true;
    }

    public JMatrix getH() {
        JMatrix jMatrix = new JMatrix(this.m, this.n);
        double[][] dArray = jMatrix.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                dArray[i][j] = i >= j ? this.QR[i][j] : 0.0;
            }
        }
        return jMatrix;
    }

    public JMatrix getR() {
        JMatrix jMatrix = new JMatrix(this.n, this.n);
        double[][] dArray = jMatrix.getArray();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                dArray[i][j] = i < j ? this.QR[i][j] : (i == j ? this.Rdiag[i] : 0.0);
            }
        }
        return jMatrix;
    }

    public JMatrix getQ() {
        JMatrix jMatrix = new JMatrix(this.m, this.n);
        double[][] dArray = jMatrix.getArray();
        for (int i = this.n - 1; i >= 0; --i) {
            int n;
            for (n = 0; n < this.m; ++n) {
                dArray[n][i] = 0.0;
            }
            dArray[i][i] = 1.0;
            for (n = i; n < this.n; ++n) {
                int n2;
                if (this.QR[i][i] == 0.0) continue;
                double d = 0.0;
                for (n2 = i; n2 < this.m; ++n2) {
                    d += this.QR[n2][i] * dArray[n2][n];
                }
                d = -d / this.QR[i][i];
                for (n2 = i; n2 < this.m; ++n2) {
                    double[] dArray2 = dArray[n2];
                    int n3 = n;
                    dArray2[n3] = dArray2[n3] + d * this.QR[n2][i];
                }
            }
        }
        return jMatrix;
    }

    public JMatrix solve(JMatrix jMatrix) {
        int n;
        int n2;
        if (jMatrix.getRowDimension() != this.m) {
            System.out.println("LinTool.QR.solve(): Matrix row dimensions must agree.");
            System.exit(0);
        }
        if (!this.isFullRank()) {
            System.out.println("LinTool.QR.solve(): Matrix is row deficient.");
            System.exit(0);
        }
        int n3 = jMatrix.getColumnDimension();
        double[][] dArray = jMatrix.getArrayCopy();
        for (n2 = 0; n2 < this.n; ++n2) {
            for (n = 0; n < n3; ++n) {
                int n4;
                double d = 0.0;
                for (n4 = n2; n4 < this.m; ++n4) {
                    d += this.QR[n4][n2] * dArray[n4][n];
                }
                d = -d / this.QR[n2][n2];
                for (n4 = n2; n4 < this.m; ++n4) {
                    double[] dArray2 = dArray[n4];
                    int n5 = n;
                    dArray2[n5] = dArray2[n5] + d * this.QR[n4][n2];
                }
            }
        }
        for (n2 = this.n - 1; n2 >= 0; --n2) {
            n = 0;
            while (n < n3) {
                double[] dArray3 = dArray[n2];
                int n6 = n++;
                dArray3[n6] = dArray3[n6] / this.Rdiag[n2];
            }
            for (n = 0; n < n2; ++n) {
                for (int i = 0; i < n3; ++i) {
                    double[] dArray4 = dArray[n];
                    int n7 = i;
                    dArray4[n7] = dArray4[n7] - dArray[n2][i] * this.QR[n][n2];
                }
            }
        }
        return new JMatrix(dArray, this.n, n3).getMatrix(0, this.n - 1, 0, n3 - 1);
    }
}

