/*
 * Decompiled with CFR 0.152.
 */
package edu.gwu.lintool;

import edu.gwu.lintool.ComplexNumber;

public class ComplexImpl
extends ComplexNumber {
    public ComplexImpl() {
    }

    public ComplexImpl(double d, double d2) {
        this.re = d;
        this.im = d2;
        this.angle = Math.atan2(d2, d);
        if (this.angle < 0.0) {
            this.angle += Math.PI;
        }
    }

    public static ComplexNumber makeInstance(double d, double d2) {
        return new ComplexImpl(d, d2);
    }

    @Override
    public double magnitude() {
        return Math.sqrt(this.re * this.re + this.im * this.im);
    }

    @Override
    public double angle() {
        this.angle = Math.atan2(this.im, this.re);
        if (this.angle < 0.0) {
            this.angle = Math.PI * 2 + this.angle;
        }
        return this.angle;
    }

    @Override
    public ComplexNumber add(ComplexNumber complexNumber) {
        ComplexImpl complexImpl = (ComplexImpl)complexNumber;
        return new ComplexImpl(this.re + complexImpl.re, this.im + complexImpl.im);
    }

    @Override
    public ComplexNumber sub(ComplexNumber complexNumber) {
        ComplexImpl complexImpl = (ComplexImpl)complexNumber;
        return new ComplexImpl(this.re - complexImpl.re, this.im - complexImpl.im);
    }

    @Override
    public ComplexNumber mult(ComplexNumber complexNumber) {
        ComplexImpl complexImpl = (ComplexImpl)complexNumber;
        return new ComplexImpl(this.re * complexImpl.re - this.im * complexImpl.im, this.re * complexImpl.im + this.im * complexImpl.re);
    }

    @Override
    public ComplexNumber mult(double d) {
        return new ComplexImpl(this.re * d, this.im * d);
    }

    @Override
    public ComplexNumber pow(int n) {
        ComplexImpl complexImpl = new ComplexImpl(this.re, this.im);
        for (int i = 2; i <= n; ++i) {
            complexImpl = (ComplexImpl)complexImpl.mult(this);
        }
        return complexImpl;
    }

    @Override
    public ComplexNumber conjugate() {
        return new ComplexImpl(this.re, -this.im);
    }
}

