/*
 * Decompiled with CFR 0.152.
 */
package edu.gwu.lintool;

import edu.gwu.lintool.ComplexImpl;
import edu.gwu.lintool.ComplexNumber;
import edu.gwu.lintool.Debug;
import edu.gwu.lintool.JMatrix;
import edu.gwu.lintool.LinResult;
import edu.gwu.lintool.LinTest;
import edu.gwu.lintool.LinTool;
import edu.gwu.lintool.LinToolLibrary;
import edu.gwu.lintool.LinUtil;
import edu.gwu.lintool.SingularValueDecomposition;
import java.util.ArrayList;

public class LinToolImpl
extends LinTool {
    static double EPSILON4 = Math.pow(2.0, -20.0);
    boolean printref = false;

    @Override
    public double add(double d, double d2) {
        return d + d2;
    }

    @Override
    public double[] add(double[] dArray, double[] dArray2) {
        if (dArray == null || dArray2 == null || dArray.length != dArray2.length || dArray.length == 0) {
            System.out.println("LinTool: vector addition not possible: mismatch in lengths or null");
            return null;
        }
        double[] dArray3 = new double[dArray.length];
        for (int i = 0; i < dArray3.length; ++i) {
            dArray3[i] = dArray[i] + dArray2[i];
        }
        return dArray3;
    }

    @Override
    public double dotProduct(double[] dArray, double[] dArray2) {
        if (dArray == null || dArray2 == null || dArray.length != dArray2.length) {
            System.out.println("LinTool: vector dot product not possible");
            return -1.0;
        }
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i] * dArray2[i];
        }
        return d;
    }

    @Override
    public double[] scalarProduct(double d, double[] dArray) {
        if (dArray == null) {
            return null;
        }
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = d * dArray[i];
        }
        return dArray2;
    }

    @Override
    public double norm(double[] dArray) {
        if (dArray == null || dArray.length == 0) {
            return -1.0;
        }
        return Math.sqrt(this.dotProduct(dArray, dArray));
    }

    @Override
    public boolean approxEquals(double[] dArray, double[] dArray2, double d) {
        if (dArray == null || dArray2 == null || dArray.length != dArray2.length) {
            return false;
        }
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d2 += (dArray[i] - dArray2[i]) * (dArray[i] - dArray2[i]);
        }
        return d2 < d;
    }

    @Override
    public double cosine(double[] dArray, double[] dArray2) {
        if (dArray2.length != dArray.length) {
            System.out.println("ERROR: cosine: unequal lengths: u.len=" + dArray.length + " v.len=" + dArray2.length);
            System.exit(0);
        }
        double d = this.dotProduct(dArray, dArray2) / (this.norm(dArray) * this.norm(dArray2));
        return d;
    }

    @Override
    public double[][] add(double[][] dArray, double[][] dArray2) {
        if (!this.addCompatible(dArray, dArray2)) {
            return null;
        }
        double[][] dArray3 = new double[dArray.length][dArray[0].length];
        for (int i = 0; i < dArray3.length; ++i) {
            for (int j = 0; j < dArray3[0].length; ++j) {
                dArray3[i][j] = dArray[i][j] + dArray2[i][j];
            }
        }
        return dArray3;
    }

    @Override
    public double[][] scalarProduct(double d, double[][] dArray) {
        if (dArray == null) {
            return null;
        }
        double[][] dArray2 = new double[dArray.length][dArray[0].length];
        for (int i = 0; i < dArray2.length; ++i) {
            for (int j = 0; j < dArray2[0].length; ++j) {
                dArray2[i][j] = d * dArray[i][j];
            }
        }
        return dArray2;
    }

    @Override
    public double[][] mult(double[][] dArray, double[][] dArray2) {
        if (!this.multiplyCompatible(dArray, dArray2)) {
            return null;
        }
        double[][] dArray3 = new double[dArray.length][dArray2[0].length];
        for (int i = 0; i < dArray3.length; ++i) {
            for (int j = 0; j < dArray3[0].length; ++j) {
                double d = 0.0;
                for (int k = 0; k < dArray[i].length; ++k) {
                    d += dArray[i][k] * dArray2[k][j];
                }
                dArray3[i][j] = d;
            }
        }
        return dArray3;
    }

    @Override
    public double[] matrixVectorMult(double[][] dArray, double[] dArray2) {
        if (dArray == null || dArray2 == null) {
            return null;
        }
        if (dArray[0].length != dArray2.length) {
            System.out.println("ERROR: LinToolImpl.matrixVectorMult(): A, v are not multiply-compatible: A is " + dArray.length + "x" + dArray[0].length + " v is " + dArray2.length + "x1");
            return null;
        }
        double[] dArray3 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            double d = 0.0;
            for (int j = 0; j < dArray[i].length; ++j) {
                d += dArray[i][j] * dArray2[j];
            }
            dArray3[i] = d;
        }
        return dArray3;
    }

    @Override
    public double[] vectorMatrixMult(double[] dArray, double[][] dArray2) {
        if (dArray2 == null || dArray == null || dArray2.length != dArray.length) {
            return null;
        }
        double[] dArray3 = new double[dArray2[0].length];
        for (int i = 0; i < dArray3.length; ++i) {
            double d = 0.0;
            for (int j = 0; j < dArray2.length; ++j) {
                d += dArray2[j][i] * dArray[j];
            }
            dArray3[i] = d;
        }
        return dArray3;
    }

    @Override
    public double[][] vectorLeftMult(double[] dArray, double[] dArray2) {
        if (dArray == null || dArray2 == null) {
            return null;
        }
        double[][] dArray3 = new double[dArray.length][dArray2.length];
        for (int i = 0; i < dArray3.length; ++i) {
            for (int j = 0; j < dArray3[0].length; ++j) {
                dArray3[i][j] = dArray[i] * dArray2[j];
            }
        }
        return dArray3;
    }

    @Override
    public double[][] transpose(double[][] dArray) {
        if (dArray == null) {
            return null;
        }
        double[][] dArray2 = new double[dArray[0].length][dArray.length];
        for (int i = 0; i < dArray2.length; ++i) {
            for (int j = 0; j < dArray2[0].length; ++j) {
                dArray2[i][j] = dArray[j][i];
            }
        }
        return dArray2;
    }

    boolean addCompatible(double[][] dArray, double[][] dArray2) {
        if (dArray == null || dArray2 == null) {
            System.out.println("ERROR: LinToolImpl: A, B are not add-compatible: A or B is null: A=" + dArray + " B=" + dArray2);
            return false;
        }
        if (dArray.length != dArray2.length || dArray[0].length != dArray2[0].length) {
            System.out.println("ERROR: LinToolImpl: A, B are not add-compatible: A is " + dArray.length + "x" + dArray[0].length + " B is " + dArray2.length + "x" + dArray2[0].length);
            return false;
        }
        return true;
    }

    boolean multiplyCompatible(double[][] dArray, double[][] dArray2) {
        if (dArray == null || dArray2 == null) {
            System.out.println("ERROR: LinToolImpl.mult(): A, B are not multiply-compatible: A or B is null: A=" + dArray + " B=" + dArray2);
            return false;
        }
        if (dArray[0].length != dArray2.length) {
            System.out.println("ERROR: LinToolImpl.mult(): A, B are not multiply-compatible: A is " + dArray.length + "x" + dArray[0].length + " B is " + dArray2.length + "x" + dArray2[0].length);
            return false;
        }
        return true;
    }

    @Override
    public double frobeniusNorm(double[][] dArray) {
        if (dArray == null) {
            return -1.0;
        }
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[0].length; ++j) {
                d += dArray[i][j] * dArray[i][j];
            }
        }
        return Math.sqrt(d);
    }

    @Override
    public boolean approxEquals(double[][] dArray, double[][] dArray2, double d) {
        if (dArray == null || dArray2 == null || dArray.length != dArray2.length || dArray[0].length != dArray2[0].length) {
            return false;
        }
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[0].length; ++j) {
                d2 += (dArray[i][j] - dArray2[i][j]) * (dArray[i][j] - dArray2[i][j]);
            }
        }
        return d2 < d;
    }

    public void setPrintREF(boolean bl) {
        this.printref = bl;
    }

    @Override
    public LinResult computeREF(double[][] dArray, double[] dArray2) {
        int n;
        int n2;
        int n3;
        int n4;
        if (dArray == null || dArray2 == null || dArray.length != dArray2.length) {
            return null;
        }
        double[][] dArray3 = new double[dArray.length][1 + dArray[0].length];
        for (n4 = 0; n4 < dArray3.length; ++n4) {
            for (n3 = 0; n3 < dArray3[0].length - 1; ++n3) {
                dArray3[n4][n3] = dArray[n4][n3];
            }
            dArray3[n4][dArray3[0].length - 1] = dArray2[n4];
        }
        n4 = dArray3.length;
        n3 = dArray3[0].length;
        int n5 = 0;
        int n6 = 0;
        LinResult linResult = new LinResult();
        linResult.A = dArray;
        linResult.b = dArray2;
        linResult.ref = dArray3;
        linResult.isPivotColumn = new boolean[dArray[0].length];
        linResult.pivotRow = new int[dArray[0].length];
        for (int i = 0; i < linResult.pivotRow.length; ++i) {
            linResult.pivotRow[i] = -1;
        }
        double[][] dArray4 = new double[dArray.length][1 + dArray[0].length];
        for (n2 = 0; n2 < dArray.length; ++n2) {
            if (n2 >= dArray[0].length) continue;
            dArray4[n2][n2] = 1.0;
        }
        while (n5 < n4 && n6 < n3) {
            int n7;
            n2 = this.findLeftMostNonzeroColumn(dArray3, n5, n6);
            if (n2 < 0) {
                if (!this.printref) break;
                Debug.println(">> no further columns found: break");
                break;
            }
            linResult.isPivotColumn[n2] = true;
            linResult.pivotRow[n2] = n5;
            n = this.selectPivot(dArray3, n5, n2);
            this.swapRows(dArray3, n5, n);
            this.swapRows(dArray4, n5, n);
            double d = dArray3[n5][n2];
            for (n7 = n2; n7 < n3; ++n7) {
                dArray3[n5][n7] = dArray3[n5][n7] / d;
            }
            for (n7 = 0; n7 < dArray4[0].length; ++n7) {
                dArray4[n5][n7] = dArray4[n5][n7] / d;
            }
            if (this.printref) {
                Debug.println(">> leftmostCol=" + n2 + " pivotRow=" + n + " currentRow=" + n5 + " pivot=" + d);
                if (n5 != n) {
                    Debug.println(">> Swapped row " + n + " into row " + n5);
                }
                Debug.println(">> R" + n5 + "  <-  R" + n5 + " / " + d + "        rref:");
                Debug.println(LinUtil.toString(dArray3));
                Debug.println("Inverse:");
                Debug.println(LinUtil.toString(dArray4));
            }
            for (n7 = n5 + 1; n7 < n4; ++n7) {
                double d2 = dArray3[n7][n2];
                this.rowReplace(dArray3, d2, n7, n5, n2);
                this.rowReplace(dArray4, d2, n7, n5, n2);
                if (!this.printref) continue;
                Debug.println(">> rowReplace: col=" + n2 + " pivotRow=" + n5 + " row=" + n7 + " alpha=" + d2 + " rref:");
                Debug.println(">> R" + n7 + "  <-  R" + n7 + " - (" + d2 + ") * R" + n5 + "        rref:");
                Debug.println(LinUtil.toString(dArray3));
                Debug.println("Inverse:");
                Debug.println(LinUtil.toString(dArray4));
            }
            ++n5;
            ++n6;
        }
        n2 = 0;
        for (n = 0; n < linResult.isPivotColumn.length; ++n) {
            if (!linResult.isPivotColumn[n]) continue;
            ++n2;
        }
        linResult.rank = n2;
        if (this.printref) {
            Debug.println("END OF REF: rank=numPivots=" + linResult.rank);
        }
        if (dArray.length == dArray[0].length && dArray.length == linResult.rank) {
            linResult.Ainv = new double[dArray.length][dArray[0].length];
            for (n = 0; n < dArray.length; ++n) {
                for (int i = 0; i < dArray[0].length; ++i) {
                    linResult.Ainv[n][i] = dArray4[n][i];
                }
            }
        } else {
            linResult.Ainv = null;
        }
        return linResult;
    }

    int findLeftMostNonzeroColumn(double[][] dArray, int n, int n2) {
        int n3 = dArray.length;
        int n4 = dArray[0].length;
        for (int i = n2; i < n4 - 1; ++i) {
            for (int j = n; j < n3; ++j) {
                if (!(Math.abs(dArray[j][i]) > LinTest.EPSILON2)) continue;
                return i;
            }
        }
        return -1;
    }

    int selectPivot(double[][] dArray, int n, int n2) {
        int n3 = dArray.length;
        for (int i = n; i < n3; ++i) {
            if (dArray[i][n2] == 0.0) continue;
            return i;
        }
        System.out.println("selectPivot ERROR: no non-zeroes");
        return -1;
    }

    void swapRows(double[][] dArray, int n, int n2) {
        if (n == n2) {
            return;
        }
        int n3 = dArray[0].length;
        for (int i = 0; i < n3; ++i) {
            double d = dArray[n][i];
            dArray[n][i] = dArray[n2][i];
            dArray[n2][i] = d;
        }
    }

    void rowReplace(double[][] dArray, double d, int n, int n2, int n3) {
        int n4 = dArray[0].length;
        for (int i = 0; i < n4; ++i) {
            dArray[n][i] = dArray[n][i] - d * dArray[n2][i];
        }
    }

    @Override
    public LinResult computeRREF(double[][] dArray, double[] dArray2) {
        int n;
        int n2;
        LinResult linResult = this.computeREF(dArray, dArray2);
        if (linResult == null) {
            return null;
        }
        linResult.rref = new double[linResult.ref.length][linResult.ref[0].length];
        for (n2 = 0; n2 < linResult.ref.length; ++n2) {
            for (n = 0; n < linResult.ref[0].length; ++n) {
                linResult.rref[n2][n] = linResult.ref[n2][n];
            }
        }
        for (n2 = 0; n2 < linResult.rref[0].length - 1; ++n2) {
            if (!linResult.isPivotColumn[n2]) continue;
            n = linResult.pivotRow[n2];
            for (int i = 0; i < n; ++i) {
                double d = linResult.rref[i][n2];
                this.rowReplace(linResult.rref, d, i, n, n2);
                if (linResult.Ainv != null) {
                    this.rowReplace(linResult.Ainv, d, i, n, n2);
                }
                if (!this.printref) continue;
                Debug.println(">> RREF rowReplace: col=" + n2 + " pivotRow=" + n + " row=" + i + " alpha=" + d + " rref:");
                Debug.println(">> R" + i + "  <-  R" + i + " - (" + d + ") * R" + n + "        rref:");
                Debug.println(LinUtil.toString(linResult.rref));
                Debug.println("Inverse:");
                Debug.println(LinUtil.toString(linResult.Ainv));
            }
        }
        return linResult;
    }

    @Override
    public LinResult solveFromREF(double[][] dArray, double[] dArray2) {
        return this.solveFromEither(dArray, dArray2, true, false);
    }

    @Override
    public LinResult solveFromRREF(double[][] dArray, double[] dArray2) {
        return this.solveFromEither(dArray, dArray2, false, false);
    }

    public LinResult solveFromEither(double[][] dArray, double[] dArray2, boolean bl, boolean bl2) {
        int n;
        int n2;
        LinResult linResult = null;
        linResult = bl ? this.computeREF(dArray, dArray2) : this.computeRREF(dArray, dArray2);
        int n3 = dArray.length;
        int n4 = dArray[0].length;
        int n5 = linResult.rank;
        boolean bl3 = false;
        for (n2 = n3 - 1; n2 >= n5; --n2) {
            if (linResult.ref[n2][n4] == 0.0) continue;
            n = 1;
            for (int i = 0; i < n4; ++i) {
                if (!(Math.abs(linResult.ref[n2][i]) > EPSILON4)) continue;
                n = 0;
            }
            if (n == 0) continue;
            bl3 = true;
            linResult.solutionExists = false;
            linResult.x = null;
            return linResult;
        }
        System.out.println("numPivots=" + n5 + " numCols=" + n4);
        if (n5 < n4) {
            if (bl || !bl2) {
                linResult.solutionExists = true;
                linResult.isUniqueSolution = false;
                linResult.x = null;
                return linResult;
            }
            if (this.existsNonZeroVar(linResult)) {
                linResult.solutionExists = true;
                linResult.isUniqueSolution = false;
                linResult.x = new double[n4];
                n2 = 0;
                for (n = 0; n < n4; ++n) {
                    if (!linResult.isPivotColumn[n]) continue;
                    linResult.x[n] = linResult.rref[n2][n4];
                    ++n2;
                }
                return linResult;
            }
        }
        linResult.solutionExists = true;
        linResult.isUniqueSolution = true;
        linResult.x = new double[n4];
        if (!bl) {
            n2 = 0;
            for (n = 0; n < n4; ++n) {
                if (!linResult.isPivotColumn[n]) continue;
                linResult.x[n] = linResult.rref[n2][n4];
                ++n2;
            }
            return linResult;
        }
        linResult.x[n5 - 1] = linResult.ref[n5 - 1][n4];
        for (n2 = n5 - 2; n2 >= 0; --n2) {
            double d = linResult.ref[n2][n4];
            for (int i = n2 + 1; i < n4; ++i) {
                d -= linResult.ref[n2][i] * linResult.x[i];
            }
            linResult.x[n2] = d;
        }
        return linResult;
    }

    boolean existsNonZeroVar(LinResult linResult) {
        int n;
        boolean[] blArray = new boolean[linResult.A.length];
        for (n = 0; n < linResult.A[0].length; ++n) {
            if (!linResult.isPivotColumn[n]) continue;
            blArray[linResult.pivotRow[n]] = true;
        }
        for (n = 0; n < linResult.A[0].length; ++n) {
            if (linResult.isPivotColumn[n]) continue;
            for (int i = 0; i < linResult.A.length; ++i) {
                if (!blArray[i] || !(Math.abs(linResult.rref[i][n]) > EPSILON4)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public LinResult inverse(double[][] dArray) {
        double[] dArray2 = new double[dArray.length];
        LinResult linResult = this.computeRREF(dArray, dArray2);
        return linResult;
    }

    @Override
    public boolean areColumnsLI(double[][] dArray) {
        if (dArray == null) {
            return false;
        }
        int n = dArray.length;
        int n2 = dArray[0].length;
        if (n < n2) {
            return false;
        }
        double[] dArray2 = new double[n];
        LinResult linResult = this.computeREF(dArray, dArray2);
        return linResult.rank == n2;
    }

    @Override
    public LinResult gramSchmidt(double[][] dArray) {
        if (!this.areColumnsLI(dArray)) {
            return null;
        }
        int n = dArray.length;
        int n2 = dArray[0].length;
        LinResult linResult = new LinResult();
        linResult.A = dArray;
        ArrayList<double[]> arrayList = this.matrixToColumns(dArray);
        ArrayList<double[]> arrayList2 = new ArrayList<double[]>();
        ArrayList<double[]> arrayList3 = new ArrayList<double[]>();
        double[] dArray2 = arrayList.get(0);
        arrayList2.add(dArray2);
        arrayList3.add(this.normalize(dArray2));
        linResult.C = new double[n2][n2];
        linResult.R = new double[n2][n2];
        linResult.C[0][0] = 1.0;
        linResult.R[0][0] = linResult.C[0][0] * this.norm(dArray2);
        for (int i = 1; i < n2; ++i) {
            double[] dArray3;
            double[] dArray4 = arrayList.get(i);
            double[] dArray5 = new double[n];
            for (int j = 0; j < i; ++j) {
                dArray3 = arrayList2.get(j);
                double d = this.dotProduct(dArray4, dArray3) / this.dotProduct(dArray3, dArray3);
                double[] dArray6 = this.scalarProduct(d, dArray3);
                dArray5 = this.add(dArray5, dArray6);
                linResult.C[j][i] = d;
                linResult.R[j][i] = d * this.norm(dArray3);
            }
            dArray5 = this.scalarProduct(-1.0, dArray5);
            double[] dArray7 = this.add(dArray4, dArray5);
            dArray3 = this.scalarProduct(1.0 / this.norm(dArray7), dArray7);
            linResult.C[i][i] = 1.0;
            linResult.R[i][i] = linResult.C[i][i] * this.norm(dArray7);
            arrayList2.add(dArray7);
            arrayList3.add(dArray3);
        }
        linResult.V = this.columnsToMatrix(arrayList2);
        linResult.Q = this.columnsToMatrix(arrayList3);
        return linResult;
    }

    double[] normalize(double[] dArray) {
        double d = this.norm(dArray);
        if (d == 0.0) {
            return null;
        }
        double[] dArray2 = this.scalarProduct(1.0 / d, dArray);
        return dArray2;
    }

    ArrayList<double[]> matrixToColumns(double[][] dArray) {
        ArrayList<double[]> arrayList = new ArrayList<double[]>();
        int n = dArray.length;
        int n2 = dArray[0].length;
        for (int i = 0; i < n2; ++i) {
            double[] dArray2 = this.getColumnAsVector(dArray, i);
            arrayList.add(dArray2);
        }
        return arrayList;
    }

    double[][] columnsToMatrix(ArrayList<double[]> arrayList) {
        int n = arrayList.size();
        double[] dArray = arrayList.get(0);
        int n2 = dArray.length;
        double[][] dArray2 = new double[n2][n];
        for (int i = 0; i < n; ++i) {
            dArray = arrayList.get(i);
            for (int j = 0; j < n2; ++j) {
                dArray2[j][i] = dArray[j];
            }
        }
        return dArray2;
    }

    @Override
    public double[] getColumnAsVector(double[][] dArray, int n) {
        if (dArray == null) {
            return null;
        }
        int n2 = dArray.length;
        int n3 = dArray[0].length;
        if (n >= n3) {
            return null;
        }
        double[] dArray2 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray2[i] = dArray[i][n];
        }
        return dArray2;
    }

    @Override
    public double[] getRowAsVector(double[][] dArray, int n) {
        if (dArray == null) {
            return null;
        }
        int n2 = dArray.length;
        int n3 = dArray[0].length;
        if (n >= n2) {
            return null;
        }
        double[] dArray2 = new double[n3];
        for (int i = 0; i < n3; ++i) {
            dArray2[i] = dArray[n][i];
        }
        return dArray2;
    }

    void setVector(double[][] dArray, int n, double[] dArray2) {
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            dArray[i][n] = dArray2[i];
        }
    }

    @Override
    public LinResult computeQR(double[][] dArray) {
        return this.gramSchmidt(dArray);
    }

    public double[] copy(double[] dArray) {
        if (dArray == null) {
            return null;
        }
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = dArray[i];
        }
        return dArray2;
    }

    @Override
    public LinResult computeEigenvalues(double[][] dArray) {
        if (dArray == null || dArray.length != dArray[0].length) {
            System.out.println("ERROR: computeEigenvalues(): matrix must be square");
            return null;
        }
        return this.computeEigen(dArray, false);
    }

    @Override
    public LinResult computeEigenvaluesAndVectorsSymmetric(double[][] dArray) {
        if (dArray == null || dArray.length != dArray[0].length) {
            System.out.println("ERROR: computeEigenvalues(): matrix must be square");
            return null;
        }
        if (!this.isSymmetric(dArray)) {
            return null;
        }
        return this.computeEigen(dArray, true);
    }

    boolean isSymmetric(double[][] dArray) {
        if (dArray == null || dArray.length != dArray[0].length) {
            return false;
        }
        for (int i = 0; i < dArray.length - 1; ++i) {
            for (int j = i + 1; j < dArray[0].length; ++j) {
                if (dArray[i][j] == dArray[j][i]) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public LinResult computeEigenvaluesAndVectors(double[][] dArray) {
        if (dArray == null || dArray.length != dArray[0].length) {
            System.out.println("ERROR: computeEigenvalues(): matrix must be square");
            return null;
        }
        System.out.println("General Eigenvalue/Vector not implemented");
        return null;
    }

    public LinResult computeEigen(double[][] dArray, boolean bl) {
        return this.pureQR(dArray, bl);
    }

    public LinResult pureQR(double[][] dArray, boolean bl) {
        int n;
        LinResult linResult = this.computeQR(dArray);
        if (linResult == null) {
            return null;
        }
        double[][] dArray2 = dArray;
        double[][] dArray3 = this.makeIdentityMatrix(dArray.length);
        int n2 = 1000;
        for (n = 0; n < n2; ++n) {
            double[][] dArray4 = this.copy(linResult.Q);
            double[][] dArray5 = this.copy(linResult.R);
            dArray2 = this.mult(dArray5, dArray4);
            linResult = this.computeQR(dArray2);
            dArray3 = this.mult(dArray3, dArray4);
        }
        linResult.lambda = new double[dArray2.length];
        for (n = 0; n < dArray2.length; ++n) {
            linResult.lambda[n] = dArray2[n][n];
        }
        linResult.S = dArray3;
        return linResult;
    }

    public LinResult directSolveQR(double[][] dArray, boolean bl) {
        int n;
        LinResult linResult = this.computeQR(dArray);
        if (linResult == null) {
            return null;
        }
        double[][] dArray2 = dArray;
        int n2 = 50;
        for (n = 0; n < n2; ++n) {
            double[][] dArray3 = this.copy(linResult.Q);
            double[][] dArray4 = this.copy(linResult.R);
            dArray2 = this.mult(dArray4, dArray3);
            linResult = this.computeQR(dArray2);
        }
        linResult.lambda = new double[dArray2.length];
        for (n = 0; n < dArray2.length; ++n) {
            linResult.lambda[n] = dArray2[n][n];
        }
        LinUtil.print("lambda", linResult.lambda);
        ArrayList<double[]> arrayList = new ArrayList<double[]>();
        int n3 = dArray.length;
        for (int i = 0; i < n3; ++i) {
            double[][] dArray5 = this.makeIdentityMatrix(n3);
            double[][] dArray6 = this.scalarProduct(-linResult.lambda[i], dArray5);
            double[][] dArray7 = this.add(dArray, dArray6);
            double[] dArray8 = new double[n3];
            LinResult linResult2 = this.solveFromEither(dArray7, dArray8, false, true);
            System.out.println("j=" + i + " Solving for lambda=" + linResult.lambda[i] + " solnexists=" + linResult2.solutionExists + " unique=" + linResult2.isUniqueSolution);
            LinUtil.print("eigenvector:unnormalized", linResult2.x);
            linResult2.x = this.normalize(linResult2.x);
            arrayList.add(linResult2.x);
            LinUtil.print("eigenvector:", linResult2.x);
        }
        linResult.S = this.columnsToMatrix(arrayList);
        LinUtil.print("S", linResult.S);
        return linResult;
    }

    public LinResult inverseIterationQR(double[][] dArray, boolean bl) {
        int n;
        LinResult linResult = this.computeQR(dArray);
        if (linResult == null) {
            return null;
        }
        double[][] dArray2 = dArray;
        double[][] dArray3 = this.makeIdentityMatrix(dArray.length);
        int n2 = 50;
        for (n = 0; n < n2; ++n) {
            double[][] dArray4 = this.copy(linResult.Q);
            double[][] dArray5 = this.copy(linResult.R);
            dArray2 = this.mult(dArray5, dArray4);
            linResult = this.computeQR(dArray2);
            dArray3 = this.mult(dArray3, dArray4);
        }
        linResult.lambda = new double[dArray2.length];
        for (n = 0; n < dArray2.length; ++n) {
            linResult.lambda[n] = dArray2[n][n];
        }
        ArrayList<double[]> arrayList = new ArrayList<double[]>();
        int n3 = dArray.length;
        for (int i = 0; i < n3; ++i) {
            double[][] dArray6 = this.makeIdentityMatrix(n3);
            double[][] dArray7 = this.scalarProduct(-linResult.lambda[i], dArray6);
            double[][] dArray8 = this.add(dArray, dArray7);
            LinResult linResult2 = this.inverse(dArray8);
            if (linResult2.Ainv == null) {
                System.out.println("ERROR: Inverse-Iteration-Method: no inverse exists");
                LinUtil.print("isPiv", linResult2.isPivotColumn);
                LinUtil.print("Matrix", linResult2.A);
                LinUtil.print("RREF", linResult2.rref);
                return null;
            }
            double[] dArray9 = this.getColumnAsVector(dArray3, i);
            for (int j = 0; j < n2; ++j) {
                double[] dArray10 = this.matrixVectorMult(linResult2.Ainv, dArray9);
                dArray9 = this.rescale(dArray10);
            }
            arrayList.add(dArray9);
        }
        linResult.S = this.columnsToMatrix(arrayList);
        return linResult;
    }

    public LinResult inverseIterationQR2(double[][] dArray, boolean bl) {
        int n;
        LinResult linResult = this.computeQR(dArray);
        if (linResult == null) {
            return null;
        }
        double[][] dArray2 = dArray;
        double[][] dArray3 = this.makeIdentityMatrix(dArray.length);
        int n2 = 50;
        for (n = 0; n < n2; ++n) {
            double[][] dArray4 = this.copy(linResult.Q);
            double[][] dArray5 = this.copy(linResult.R);
            dArray2 = this.mult(dArray5, dArray4);
            linResult = this.computeQR(dArray2);
            dArray3 = this.mult(dArray3, dArray4);
        }
        linResult.lambda = new double[dArray2.length];
        for (n = 0; n < dArray2.length; ++n) {
            linResult.lambda[n] = dArray2[n][n];
        }
        ArrayList<double[]> arrayList = new ArrayList<double[]>();
        int n3 = dArray.length;
        for (int i = 0; i < n3; ++i) {
            double[][] dArray6 = this.makeIdentityMatrix(n3);
            double[][] dArray7 = this.scalarProduct(-linResult.lambda[i], dArray6);
            double[][] dArray8 = this.add(dArray, dArray7);
            double[] dArray9 = this.getColumnAsVector(dArray3, i);
            for (int j = 0; j < n2; ++j) {
                System.out.println("iter=" + j);
                JMatrix jMatrix = new JMatrix(dArray8);
                JMatrix jMatrix2 = this.vectorToJMatrix(dArray9);
                JMatrix jMatrix3 = jMatrix.solve(jMatrix2);
                double[] dArray10 = this.JMatrixToVector(jMatrix3);
                dArray9 = this.rescale(dArray10);
            }
            arrayList.add(dArray9);
        }
        linResult.S = this.columnsToMatrix(arrayList);
        return linResult;
    }

    double[] rescale(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(Math.abs(dArray[i]) > d)) continue;
            d = dArray[i];
        }
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = dArray[i] / d;
        }
        return dArray2;
    }

    JMatrix vectorToJMatrix(double[] dArray) {
        double[][] dArray2 = new double[dArray.length][1];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i][0] = dArray[i];
        }
        return new JMatrix(dArray2);
    }

    double[] JMatrixToVector(JMatrix jMatrix) {
        double[][] dArray = jMatrix.getArray();
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = dArray[i][0];
        }
        return dArray2;
    }

    public double[][] copy(double[][] dArray) {
        if (dArray == null) {
            return null;
        }
        double[][] dArray2 = new double[dArray.length][dArray[0].length];
        for (int i = 0; i < dArray2.length; ++i) {
            for (int j = 0; j < dArray2[0].length; ++j) {
                dArray2[i][j] = dArray[i][j];
            }
        }
        return dArray2;
    }

    double[][] makeIdentityMatrix(int n) {
        double[][] dArray = new double[n][n];
        for (int i = 0; i < n; ++i) {
            dArray[i][i] = 1.0;
        }
        return dArray;
    }

    @Override
    public LinResult computeSpectralDecompositionSymmetric(double[][] dArray) {
        if (dArray == null || dArray.length != dArray[0].length) {
            System.out.println("ERROR: computeEigenvalues(): matrix must be square");
            return null;
        }
        if (!this.isSymmetric(dArray)) {
            return null;
        }
        LinResult linResult = LinToolLibrary.computeEigenvaluesAndVectors(dArray);
        linResult.Sinv = this.transpose(linResult.S);
        return linResult;
    }

    @Override
    public LinResult computeSVD(double[][] dArray) {
        return this.computeSVD2(dArray);
    }

    public LinResult computeSVD1(double[][] dArray) {
        if (dArray == null) {
            return null;
        }
        double[][] dArray2 = this.mult(this.transpose(dArray), dArray);
        LinResult linResult = this.computeSpectralDecompositionSymmetric(dArray2);
        linResult.V = this.copy(linResult.S);
        this.sort(linResult.V, linResult.lambda);
        linResult.sigma = new double[dArray2.length];
        linResult.rank = 0;
        for (int i = 0; i < linResult.sigma.length; ++i) {
            linResult.sigma[i] = Math.sqrt(linResult.lambda[i]);
            if (linResult.sigma[i] > 0.0) {
                ++linResult.rank;
                continue;
            }
            linResult.sigma[i] = 0.0;
        }
        double[][] dArray3 = this.mult(dArray, this.transpose(dArray));
        LinResult linResult2 = this.computeSpectralDecompositionSymmetric(dArray3);
        linResult2.U = this.copy(linResult2.S);
        this.sort(linResult2.U, linResult2.lambda);
        linResult.U = linResult2.U;
        linResult.sigma = this.trim(linResult.sigma, linResult.rank);
        linResult.V = this.trim(linResult.V, linResult.rank);
        linResult.U = this.trim(linResult.U, linResult.rank);
        linResult.Sigma = new double[linResult.rank][linResult.rank];
        for (int i = 0; i < linResult.rank; ++i) {
            linResult.Sigma[i][i] = linResult.sigma[i];
        }
        return linResult;
    }

    void sort(double[][] dArray, double[] dArray2) {
        for (int i = 0; i < dArray2.length - 1; ++i) {
            double d = dArray2[i];
            int n = i;
            for (int j = i + 1; j < dArray2.length; ++j) {
                if (!(dArray2[j] > d)) continue;
                d = dArray2[j];
                n = j;
            }
            if (i == n) continue;
            this.swap(dArray2, i, n);
            this.swapColumns(dArray, i, n);
        }
    }

    void swap(double[] dArray, int n, int n2) {
        double d = dArray[n];
        dArray[n] = dArray[n2];
        dArray[n2] = d;
    }

    void swapColumns(double[][] dArray, int n, int n2) {
        for (int i = 0; i < dArray.length; ++i) {
            double d = dArray[i][n];
            dArray[i][n] = dArray[i][n2];
            dArray[i][n2] = d;
        }
    }

    double[][] trim(double[][] dArray, int n) {
        if (n >= dArray[0].length) {
            return dArray;
        }
        double[][] dArray2 = new double[dArray.length][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < dArray.length; ++j) {
                dArray2[j][i] = dArray[j][i];
            }
        }
        return dArray2;
    }

    double[] trim(double[] dArray, int n) {
        if (n >= dArray.length) {
            return dArray;
        }
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = dArray[i];
        }
        return dArray2;
    }

    public LinResult computeSVD2(double[][] dArray) {
        int n;
        if (dArray == null) {
            return null;
        }
        double[][] dArray2 = this.mult(this.transpose(dArray), dArray);
        LinResult linResult = this.computeSpectralDecompositionSymmetric(dArray2);
        linResult.V = this.copy(linResult.S);
        this.sort(linResult.V, linResult.lambda);
        linResult.sigma = new double[dArray2.length];
        linResult.rank = 0;
        for (int i = 0; i < linResult.sigma.length; ++i) {
            linResult.sigma[i] = Math.sqrt(linResult.lambda[i]);
            if (linResult.sigma[i] > 0.0) {
                ++linResult.rank;
                System.out.println("i=" + i + " sigma=" + linResult.sigma[i] + " rank=" + linResult.rank);
                continue;
            }
            linResult.sigma[i] = 0.0;
        }
        double[][] dArray3 = this.mult(dArray, this.transpose(dArray));
        LinResult linResult2 = this.computeSpectralDecompositionSymmetric(dArray3);
        linResult2.U = this.copy(linResult2.S);
        this.sort(linResult2.U, linResult2.lambda);
        for (n = 0; n < linResult.rank; ++n) {
            double[] dArray4 = this.getColumnAsVector(linResult.V, n);
            double[] dArray5 = this.matrixVectorMult(dArray, dArray4);
            dArray5 = this.scalarProduct(1.0 / linResult.sigma[n], dArray5);
            dArray5 = this.normalize(dArray5);
            for (int i = 0; i < dArray5.length; ++i) {
                linResult2.U[i][n] = dArray5[i];
            }
        }
        linResult.U = linResult2.U;
        linResult.sigma = this.trim(linResult.sigma, linResult.rank);
        linResult.V = this.trim(linResult.V, linResult.rank);
        linResult.U = this.trim(linResult.U, linResult.rank);
        linResult.Sigma = new double[linResult.rank][linResult.rank];
        for (n = 0; n < linResult.rank; ++n) {
            linResult.Sigma[n][n] = linResult.sigma[n];
        }
        return linResult;
    }

    public LinResult computeSVD3(double[][] dArray) {
        if (dArray == null) {
            return null;
        }
        if (dArray.length >= dArray[0].length) {
            JMatrix jMatrix = new JMatrix(dArray);
            SingularValueDecomposition singularValueDecomposition = new SingularValueDecomposition(jMatrix);
            LinResult linResult = new LinResult();
            linResult.A = dArray;
            linResult.V = singularValueDecomposition.getV().getArray();
            linResult.U = singularValueDecomposition.getU().getArray();
            linResult.sigma = singularValueDecomposition.getSingularValues();
            linResult.rank = linResult.sigma.length;
            linResult.Sigma = new double[linResult.rank][linResult.rank];
            for (int i = 0; i < linResult.rank; ++i) {
                linResult.Sigma[i][i] = linResult.sigma[i];
            }
            return linResult;
        }
        double[][] dArray2 = this.transpose(dArray);
        JMatrix jMatrix = new JMatrix(dArray2);
        SingularValueDecomposition singularValueDecomposition = new SingularValueDecomposition(jMatrix);
        LinResult linResult = new LinResult();
        linResult.A = dArray;
        linResult.V = singularValueDecomposition.getU().getArray();
        linResult.U = singularValueDecomposition.getV().getArray();
        linResult.sigma = singularValueDecomposition.getSingularValues();
        linResult.rank = linResult.sigma.length;
        linResult.Sigma = new double[linResult.rank][linResult.rank];
        for (int i = 0; i < linResult.rank; ++i) {
            linResult.Sigma[i][i] = linResult.sigma[i];
        }
        return linResult;
    }

    @Override
    public LinResult pseudoInverse(double[][] dArray) {
        if (dArray == null) {
            return null;
        }
        LinResult linResult = LinToolLibrary.computeSVD(dArray);
        int n = dArray.length;
        int n2 = dArray[0].length;
        int n3 = linResult.rank;
        double[][] dArray2 = new double[n3][n3];
        for (int i = 0; i < n3; ++i) {
            dArray2[i][i] = 1.0 / linResult.sigma[i];
        }
        double[][] dArray3 = linResult.U;
        double[][] dArray4 = this.transpose(dArray3);
        double[][] dArray5 = linResult.V;
        dArray2 = this.expand(dArray2, dArray5[0].length - n3, dArray3[0].length - n3);
        double[][] dArray6 = this.mult(dArray5, dArray2);
        double[][] dArray7 = new double[n2][n];
        dArray7 = this.mult(dArray6, dArray4);
        LinResult linResult2 = new LinResult();
        linResult2.A_plus = dArray7;
        linResult2.A = dArray;
        linResult2.rank = linResult.rank;
        linResult2.U = dArray3;
        linResult2.V = dArray5;
        linResult2.sigma = linResult.sigma;
        return linResult2;
    }

    double[][] expand(double[][] dArray, int n, int n2) {
        double[][] dArray2 = new double[dArray.length + n][dArray[0].length + n2];
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[0].length; ++j) {
                dArray2[i][j] = dArray[i][j];
            }
        }
        return dArray2;
    }

    @Override
    public LinResult solveLeastSquares(double[][] dArray, double[] dArray2) {
        if (dArray == null || dArray2 == null) {
            System.out.println("LeastSq: null: A=" + dArray + " b=" + dArray2);
            return null;
        }
        if (dArray.length < dArray[0].length) {
            System.out.println("LeastSq: length: A.length=" + dArray.length + " A[0].length=" + dArray[0].length);
            return null;
        }
        LinResult linResult = this.pseudoInverse(dArray);
        double[] dArray3 = this.matrixVectorMult(linResult.A_plus, dArray2);
        linResult.x = dArray3;
        LinUtil.print("x", linResult.x);
        if (linResult.rank < dArray[0].length) {
            return linResult;
        }
        double[][] dArray4 = this.transpose(dArray);
        double[][] dArray5 = this.mult(dArray4, dArray);
        LinResult linResult2 = LinToolLibrary.inverse(dArray5);
        double[][] dArray6 = linResult2.Ainv;
        double[][] dArray7 = this.mult(dArray6, dArray4);
        double[] dArray8 = this.matrixVectorMult(dArray7, dArray2);
        linResult.x = dArray3;
        return linResult;
    }

    @Override
    public ComplexNumber[] add(ComplexNumber[] complexNumberArray, ComplexNumber[] complexNumberArray2) {
        if (complexNumberArray == null || complexNumberArray2 == null || complexNumberArray.length != complexNumberArray2.length || complexNumberArray.length == 0) {
            System.out.println("LinTool: complex vector addition not possible: mismatch in lengths or null");
            return null;
        }
        ComplexNumber[] complexNumberArray3 = new ComplexNumber[complexNumberArray.length];
        for (int i = 0; i < complexNumberArray3.length; ++i) {
            complexNumberArray3[i] = complexNumberArray[i].add(complexNumberArray2[i]);
        }
        return complexNumberArray3;
    }

    @Override
    public double norm(ComplexNumber[] complexNumberArray) {
        if (complexNumberArray == null || complexNumberArray.length == 0) {
            return -1.0;
        }
        return Math.sqrt(this.dotProduct(complexNumberArray, complexNumberArray).magnitude());
    }

    @Override
    public ComplexNumber dotProduct(ComplexNumber[] complexNumberArray, ComplexNumber[] complexNumberArray2) {
        if (complexNumberArray == null || complexNumberArray2 == null || complexNumberArray.length != complexNumberArray2.length) {
            System.out.println("LinTool: complex vector dot product not possible");
            return null;
        }
        ComplexNumber complexNumber = ComplexNumber.makeComplexNumber(0.0, 0.0);
        for (int i = 0; i < complexNumberArray.length; ++i) {
            complexNumber = complexNumber.add(complexNumberArray[i].mult(complexNumberArray2[i].conjugate()));
        }
        return complexNumber;
    }

    @Override
    public ComplexNumber[] scalarProduct(ComplexNumber complexNumber, ComplexNumber[] complexNumberArray) {
        if (complexNumberArray == null) {
            return null;
        }
        ComplexNumber[] complexNumberArray2 = new ComplexNumber[complexNumberArray.length];
        for (int i = 0; i < complexNumberArray.length; ++i) {
            complexNumberArray2[i] = complexNumberArray[i].mult(complexNumber);
        }
        return complexNumberArray2;
    }

    @Override
    public ComplexNumber[][] add(ComplexNumber[][] complexNumberArray, ComplexNumber[][] complexNumberArray2) {
        if (!this.addCompatible(complexNumberArray, complexNumberArray2)) {
            return null;
        }
        ComplexNumber[][] complexNumberArray3 = new ComplexNumber[complexNumberArray.length][complexNumberArray[0].length];
        for (int i = 0; i < complexNumberArray3.length; ++i) {
            for (int j = 0; j < complexNumberArray3[0].length; ++j) {
                complexNumberArray3[i][j] = complexNumberArray[i][j].add(complexNumberArray2[i][j]);
            }
        }
        return complexNumberArray3;
    }

    @Override
    public ComplexNumber[][] scalarProduct(ComplexNumber complexNumber, ComplexNumber[][] complexNumberArray) {
        if (complexNumberArray == null) {
            return null;
        }
        ComplexNumber[][] complexNumberArray2 = new ComplexNumber[complexNumberArray.length][complexNumberArray[0].length];
        for (int i = 0; i < complexNumberArray2.length; ++i) {
            for (int j = 0; j < complexNumberArray2[0].length; ++j) {
                complexNumberArray2[i][j] = complexNumberArray[i][j].mult(complexNumber);
            }
        }
        return complexNumberArray2;
    }

    public boolean approxEquals(ComplexNumber complexNumber, ComplexNumber complexNumber2, double d) {
        if (complexNumber == null || complexNumber2 == null) {
            return false;
        }
        return !(Math.abs(complexNumber.re - complexNumber2.re) > d) && !(Math.abs(complexNumber.im - complexNumber2.im) > d);
    }

    public boolean approxEquals(ComplexNumber[] complexNumberArray, ComplexNumber[] complexNumberArray2, double d) {
        if (complexNumberArray == null || complexNumberArray2 == null || complexNumberArray.length != complexNumberArray2.length) {
            return false;
        }
        double d2 = 0.0;
        for (int i = 0; i < complexNumberArray.length; ++i) {
            d2 += complexNumberArray[i].sub(complexNumberArray2[i]).magnitude();
        }
        return d2 < d;
    }

    public boolean approxEquals(ComplexNumber[][] complexNumberArray, ComplexNumber[][] complexNumberArray2, double d) {
        if (complexNumberArray == null || complexNumberArray2 == null || complexNumberArray.length != complexNumberArray2.length || complexNumberArray[0].length != complexNumberArray2[0].length) {
            return false;
        }
        double d2 = 0.0;
        for (int i = 0; i < complexNumberArray.length; ++i) {
            for (int j = 0; j < complexNumberArray[0].length; ++j) {
                d2 += complexNumberArray[i][j].sub(complexNumberArray2[i][j]).magnitude();
            }
        }
        return d2 < d;
    }

    @Override
    public ComplexNumber[][] mult(ComplexNumber[][] complexNumberArray, ComplexNumber[][] complexNumberArray2) {
        if (!this.multiplyCompatible(complexNumberArray, complexNumberArray2)) {
            return null;
        }
        ComplexNumber[][] complexNumberArray3 = new ComplexNumber[complexNumberArray.length][complexNumberArray2[0].length];
        for (int i = 0; i < complexNumberArray3.length; ++i) {
            for (int j = 0; j < complexNumberArray3[0].length; ++j) {
                ComplexNumber complexNumber = ComplexNumber.makeComplexNumber(0.0, 0.0);
                for (int k = 0; k < complexNumberArray[i].length; ++k) {
                    complexNumber = complexNumber.add(complexNumberArray[i][k].mult(complexNumberArray2[k][j]));
                }
                complexNumberArray3[i][j] = complexNumber;
            }
        }
        return complexNumberArray3;
    }

    @Override
    public ComplexNumber[] matrixVectorMult(ComplexNumber[][] complexNumberArray, ComplexNumber[] complexNumberArray2) {
        if (complexNumberArray == null || complexNumberArray2 == null || complexNumberArray[0].length != complexNumberArray2.length) {
            return null;
        }
        ComplexNumber[] complexNumberArray3 = new ComplexNumber[complexNumberArray.length];
        for (int i = 0; i < complexNumberArray.length; ++i) {
            ComplexNumber complexNumber = ComplexNumber.makeComplexNumber(0.0, 0.0);
            for (int j = 0; j < complexNumberArray[i].length; ++j) {
                complexNumber = complexNumber.add(complexNumberArray[i][j].mult(complexNumberArray2[j]));
            }
            complexNumberArray3[i] = complexNumber;
        }
        return complexNumberArray3;
    }

    boolean addCompatible(ComplexNumber[][] complexNumberArray, ComplexNumber[][] complexNumberArray2) {
        if (complexNumberArray == null || complexNumberArray2 == null) {
            return false;
        }
        if (complexNumberArray.length != complexNumberArray2.length) {
            return false;
        }
        for (int i = 0; i < complexNumberArray.length; ++i) {
            if (complexNumberArray[i].length != complexNumberArray2[i].length) {
                return false;
            }
            if (complexNumberArray[i].length == complexNumberArray[0].length) continue;
            return false;
        }
        return true;
    }

    boolean multiplyCompatible(ComplexNumber[][] complexNumberArray, ComplexNumber[][] complexNumberArray2) {
        if (complexNumberArray == null || complexNumberArray2 == null) {
            System.out.println("ERROR: LinToolImpl.mult(): A, B are not multiply-compatible: A or B is null: A=" + complexNumberArray + " B=" + complexNumberArray2);
            return false;
        }
        if (complexNumberArray[0].length != complexNumberArray2.length) {
            System.out.println("ERROR: LinToolImpl.mult(): A, B are not multiply-compatible: A is " + complexNumberArray.length + "x" + complexNumberArray[0].length + " B is " + complexNumberArray2.length + "x" + complexNumberArray2[0].length);
            return false;
        }
        return true;
    }

    @Override
    public ComplexNumber[][] hermitianTranspose(ComplexNumber[][] complexNumberArray) {
        if (complexNumberArray == null) {
            return null;
        }
        ComplexNumber[][] complexNumberArray2 = new ComplexNumber[complexNumberArray[0].length][complexNumberArray.length];
        for (int i = 0; i < complexNumberArray2.length; ++i) {
            for (int j = 0; j < complexNumberArray2[0].length; ++j) {
                complexNumberArray2[i][j] = complexNumberArray[j][i].conjugate();
            }
        }
        return complexNumberArray2;
    }

    @Override
    public ComplexNumber[][] makeInverseDFTMatrix(int n) {
        ComplexNumber[][] complexNumberArray = new ComplexNumber[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                double d = Math.cos(Math.PI * 2 * (double)i * (double)j / (double)n);
                double d2 = Math.sin(Math.PI * 2 * (double)i * (double)j / (double)n);
                complexNumberArray[i][j] = new ComplexImpl(d, d2);
            }
        }
        return complexNumberArray;
    }

    @Override
    public ComplexNumber[][] makeDFTMatrix(int n) {
        ComplexNumber[][] complexNumberArray = this.makeInverseDFTMatrix(n);
        ComplexNumber[][] complexNumberArray2 = this.hermitianTranspose(complexNumberArray);
        return complexNumberArray2;
    }

    @Override
    public ComplexNumber[] computeDFT(double[] dArray) {
        if (dArray == null || dArray.length == 0) {
            return null;
        }
        int n = dArray.length;
        ComplexNumber[] complexNumberArray = new ComplexNumber[n];
        for (int i = 0; i < n; ++i) {
            complexNumberArray[i] = new ComplexImpl(dArray[i], 0.0);
        }
        ComplexNumber[] complexNumberArray2 = new ComplexNumber[n];
        ComplexNumber[][] complexNumberArray3 = this.makeDFTMatrix(n);
        for (int i = 0; i < n; ++i) {
            ComplexNumber complexNumber = new ComplexImpl(0.0, 0.0);
            for (int j = 0; j < n; ++j) {
                complexNumber = ((ComplexNumber)complexNumber).add(complexNumberArray3[i][j].mult(complexNumberArray[j]));
            }
            complexNumberArray2[i] = ((ComplexNumber)complexNumber).mult(1.0 / (double)n);
        }
        return complexNumberArray2;
    }

    @Override
    public ComplexNumber[] computeInverseDFT(ComplexNumber[] complexNumberArray) {
        if (complexNumberArray == null || complexNumberArray.length == 0) {
            return null;
        }
        int n = complexNumberArray.length;
        ComplexNumber[] complexNumberArray2 = new ComplexNumber[n];
        ComplexNumber[][] complexNumberArray3 = this.makeInverseDFTMatrix(n);
        for (int i = 0; i < n; ++i) {
            ComplexNumber complexNumber = new ComplexImpl(0.0, 0.0);
            for (int j = 0; j < n; ++j) {
                complexNumber = ((ComplexNumber)complexNumber).add(complexNumberArray3[i][j].mult(complexNumberArray[j]));
            }
            complexNumberArray2[i] = complexNumber;
        }
        return complexNumberArray2;
    }

    @Override
    public ComplexNumber[] computeFFT(double[] dArray) {
        if (dArray == null || dArray.length == 0) {
            return null;
        }
        int n = dArray.length;
        if (!LinUtil.isPowerOf2(n)) {
            return null;
        }
        return LinUtil.computeFFT(dArray);
    }

    @Override
    public ComplexNumber[] computeInverseFFT(ComplexNumber[] complexNumberArray) {
        if (complexNumberArray == null || complexNumberArray.length == 0) {
            return null;
        }
        int n = complexNumberArray.length;
        if (!LinUtil.isPowerOf2(n)) {
            return null;
        }
        return LinUtil.computeInverseFFT(complexNumberArray);
    }
}

