/*
 * Decompiled with CFR 0.152.
 */
package edu.gwu.lintool;

import edu.gwu.lintool.ComplexNumber;
import edu.gwu.lintool.LinResult;
import edu.gwu.lintool.LinToolImpl;
import edu.gwu.lintool.LinToolLibrary;
import edu.gwu.lintool.LinUtil;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;

public class LinMagic {
    public int M;
    public int N;
    public int R;
    public double[] avg;
    public double[][] Y_T;
    public double[][] U_T;
    LinToolImpl linImpl = new LinToolImpl();
    double[][] invdct;
    double[][] dct;
    LinResult svdResult;
    double[][] U;
    double[][] V;
    double[][] V_T;
    double[] sigma;
    ArrayList<Point2D.Double> linePoints;
    ArrayList<? extends Point2D.Double> points;
    int numControlPoints;
    int numCurvePoints;
    static double[][] X;
    static double[][] Z_T;
    static double[][] U_k_T;
    double xE;
    double yE;
    double zE;
    double[][] T_E;
    double[][] R_z1;
    double[][] R_z2;
    double[][] R_x1;
    double[][] R_x2;
    double[][] S1;
    double[][] S2;
    double[][] S3;
    double[][] S4;
    double[][] Trans;

    public int findClosestImage(double[] dArray) {
        for (int i = 0; i < this.N; ++i) {
            dArray[i] = dArray[i] - this.avg[i];
        }
        double[] dArray2 = this.linImpl.matrixVectorMult(this.U_T, dArray);
        double d = 0.0;
        int n = -1;
        for (int i = 0; i < this.Y_T.length; ++i) {
            double d2 = this.linImpl.cosine(this.Y_T[i], dArray2);
            if (!(d2 > d)) continue;
            d = d2;
            n = i;
        }
        return n;
    }

    public double[][] processTrainingImages(double[][] dArray) {
        this.avg = this.computeAverageVector(dArray);
        double[][] dArray2 = this.normalizeData(dArray, this.avg);
        LinResult linResult = LinToolLibrary.computeSVD(dArray2);
        this.R = linResult.sigma.length;
        System.out.println("# nonzero singular values: " + this.R);
        double[][] dArray3 = linResult.U;
        System.out.println("#rows of U=" + dArray3.length + " #cols of U=" + dArray3[0].length);
        this.U_T = this.linImpl.transpose(dArray3);
        double[][] dArray4 = this.linImpl.mult(this.U_T, dArray2);
        this.Y_T = this.linImpl.transpose(dArray4);
        return dArray3;
    }

    double[][] normalizeData(double[][] dArray, double[] dArray2) {
        double[][] dArray3 = new double[this.N][this.M];
        for (int i = 0; i < this.N; ++i) {
            for (int j = 0; j < this.M; ++j) {
                dArray3[i][j] = dArray[i][j] - dArray2[i];
            }
        }
        return dArray3;
    }

    double[] computeAverageVector(double[][] dArray) {
        double[] dArray2 = new double[this.N];
        for (int i = 0; i < this.N; ++i) {
            double d = 0.0;
            for (int j = 0; j < this.M; ++j) {
                d += dArray[i][j];
            }
            dArray2[i] = d / (double)this.M;
        }
        return dArray2;
    }

    public double[] pageRankViaEigenvalues(double[][] dArray) {
        double[][] dArray2 = this.linImpl.transpose(dArray);
        LinResult linResult = LinToolLibrary.computeEigenvaluesAndVectors(dArray2);
        double[] dArray3 = linResult.lambda;
        double[][] dArray4 = linResult.S;
        double[] dArray5 = this.linImpl.getColumnAsVector(dArray4, 0);
        dArray5 = this.normalize(dArray5);
        return dArray5;
    }

    double[] normalize(double[] dArray) {
        int n;
        double[] dArray2 = new double[dArray.length];
        double d = 0.0;
        for (n = 0; n < dArray.length; ++n) {
            d += dArray[n];
        }
        for (n = 0; n < dArray.length; ++n) {
            dArray2[n] = dArray[n] / d;
        }
        return dArray2;
    }

    public double[] pageRankViaPowerMethod(double[][] dArray) {
        int n = dArray[0].length;
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = 1.0 / (double)n;
        }
        double[][] dArray3 = this.linImpl.transpose(dArray);
        int n2 = 50;
        for (int i = 0; i < n2; ++i) {
            dArray2 = this.linImpl.matrixVectorMult(dArray3, dArray2);
        }
        return dArray2;
    }

    public double[] compress1D(double[] dArray, int n) {
        this.N = dArray.length;
        this.invdct = this.makeInverseDCTMatrix(this.N);
        this.dct = this.linImpl.transpose(this.invdct);
        double[] dArray2 = this.linImpl.matrixVectorMult(this.dct, dArray);
        for (int i = this.N - 1; i > this.N - 1 - n; --i) {
            dArray2[i] = 0.0;
        }
        return dArray2;
    }

    public double[] uncompress1D(double[] dArray) {
        double[] dArray2 = this.linImpl.matrixVectorMult(this.invdct, dArray);
        return dArray2;
    }

    double[][] makeInverseDCTMatrix(int n) {
        double[][] dArray = new double[n][n];
        for (int i = 0; i < n; ++i) {
            double d = 1.0;
            if (i == 0) {
                d = 1.0 / Math.sqrt(2.0);
            }
            for (int j = 0; j < n; ++j) {
                double d2 = ((double)(2 * j) + 1.0) * (Math.PI * (double)i) / (2.0 * (double)n);
                dArray[i][j] = Math.sqrt(2.0 / (double)n) * d * Math.cos(d2);
            }
        }
        return dArray;
    }

    public double[][] compress2D(double[][] dArray, int n) {
        double[][] dArray2 = LinMagic.directDCT(dArray);
        for (int i = this.M - 1; i > this.M - 1 - n; --i) {
            for (int j = this.N - 1; j > this.N - 1 - n; --j) {
                dArray2[i][j] = 0.0;
            }
        }
        return dArray2;
    }

    public double[][] uncompress2D(double[][] dArray) {
        double[][] dArray2 = LinMagic.directInverseDCT(dArray);
        return dArray2;
    }

    static double alpha(int n) {
        if (n == 0) {
            return 1.0 / Math.sqrt(2.0);
        }
        return 1.0;
    }

    static double[][] directDCT(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        double[][] dArray2 = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                double d = 0.0;
                for (int k = 0; k < n; ++k) {
                    for (int i2 = 0; i2 < n2; ++i2) {
                        double d2 = ((double)(2 * i) + 1.0) * (Math.PI * (double)k) / (2.0 * (double)n2);
                        double d3 = ((double)(2 * j) + 1.0) * (Math.PI * (double)i2) / (2.0 * (double)n2);
                        d += Math.sqrt(2.0 / (double)n2) * LinMagic.alpha(k) * LinMagic.alpha(i2) * Math.cos(d2) * Math.cos(d3) * dArray[k][i2];
                    }
                }
                dArray2[i][j] = d;
            }
        }
        return dArray2;
    }

    static double[][] directInverseDCT(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        double[][] dArray2 = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                double d = 0.0;
                for (int k = 0; k < n; ++k) {
                    for (int i2 = 0; i2 < n2; ++i2) {
                        double d2 = ((double)(2 * k) + 1.0) * (Math.PI * (double)i) / (2.0 * (double)n);
                        double d3 = ((double)(2 * i2) + 1.0) * (Math.PI * (double)j) / (2.0 * (double)n2);
                        d += Math.sqrt(2.0 / (double)n2) * LinMagic.alpha(i) * LinMagic.alpha(j) * Math.cos(d2) * Math.cos(d3) * dArray[k][i2];
                    }
                }
                double d4 = 2.0 / Math.sqrt(n * n2);
                dArray2[i][j] = d4 * d;
            }
        }
        return dArray2;
    }

    public int getRank(double[][] dArray) {
        this.svdResult = LinToolLibrary.computeSVD(dArray);
        return this.svdResult.rank;
    }

    public void compressSVD(double[][] dArray, int n) {
        this.U = this.svdResult.U;
        this.V = this.svdResult.V;
        this.sigma = this.svdResult.sigma;
        this.V_T = this.linImpl.transpose(this.V);
    }

    public double[][] uncompressSVD(int n) {
        double[][] dArray = new double[this.M][this.N];
        for (int i = 0; i < n; ++i) {
            double[] dArray2 = this.linImpl.getColumnAsVector(this.U, i);
            double[] dArray3 = this.linImpl.getRowAsVector(this.V_T, i);
            for (int j = 0; j < this.M; ++j) {
                for (int k = 0; k < this.N; ++k) {
                    double[] dArray4 = dArray[j];
                    int n2 = k;
                    dArray4[n2] = dArray4[n2] + this.sigma[i] * dArray2[j] * dArray3[k];
                }
            }
        }
        return dArray;
    }

    public ArrayList<Point2D.Double> computeBezierCurve(ArrayList<? extends Point2D.Double> arrayList, int n) {
        this.points = arrayList;
        this.numControlPoints = arrayList.size();
        this.numCurvePoints = n;
        this.recursiveBezier();
        return this.linePoints;
    }

    void recursiveBezier() {
        this.linePoints = new ArrayList();
        double d = 1.0 / (double)this.numCurvePoints;
        int n = this.numControlPoints;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            Point2D.Double double_ = this.points.get(i);
            dArray[i] = double_.x;
            dArray2[i] = double_.y;
        }
        for (double d2 = 0.0; d2 <= 1.0; d2 += d) {
            Point2D.Double double_ = new Point2D.Double();
            double_.x = this.recursiveBezier(dArray, 0, n - 1, d2);
            double_.y = this.recursiveBezier(dArray2, 0, n - 1, d2);
            this.linePoints.add(double_);
        }
    }

    double recursiveBezier(double[] dArray, int n, int n2, double d) {
        if (n > n2) {
            System.out.println("ERROR: recBez: L=" + n + " R=" + n2);
            return 0.0;
        }
        if (n == n2) {
            return dArray[n];
        }
        double d2 = this.recursiveBezier(dArray, n, n2 - 1, d);
        double d3 = this.recursiveBezier(dArray, n + 1, n2, d);
        double d4 = (1.0 - d) * d2 + d * d3;
        return d4;
    }

    public double[] leastSquaresEllipse(double[] dArray, double[] dArray2) {
        double[][] dArray3 = LinMagic.makeEllipse_A(dArray, dArray2);
        double[] dArray4 = LinMagic.makeEllipse_b(dArray, dArray2);
        LinResult linResult = this.linImpl.solveLeastSquares(dArray3, dArray4);
        return linResult.x;
    }

    static double[][] makeEllipse_A(double[] dArray, double[] dArray2) {
        double[][] dArray3 = new double[dArray.length][4];
        for (int i = 0; i < dArray3.length; ++i) {
            dArray3[i][0] = dArray[i] * dArray[i];
            dArray3[i][1] = dArray[i];
            dArray3[i][2] = dArray2[i];
            dArray3[i][3] = 1.0;
        }
        return dArray3;
    }

    static double[] makeEllipse_b(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[dArray.length];
        for (int i = 0; i < dArray3.length; ++i) {
            dArray3[i] = -dArray2[i] * dArray2[i];
        }
        return dArray3;
    }

    public double[][] latentSemanticCoords(double[][] dArray) {
        LinResult linResult = LinToolLibrary.computeSVDShortForm(dArray);
        int n = linResult.rank;
        double[][] dArray2 = linResult.U;
        double[][] dArray3 = linResult.Sigma;
        this.reducedSingular(dArray3, 2);
        double[][] dArray4 = linResult.V;
        dArray2 = this.reduceColumns(dArray2, dArray3.length);
        dArray4 = this.reduceColumns(dArray4, dArray3[0].length);
        double[][] dArray5 = this.linImpl.transpose(dArray4);
        double[][] dArray6 = this.linImpl.mult(dArray3, dArray5);
        return dArray6;
    }

    void reducedSingular(double[][] dArray, int n) {
        for (int i = n; i < dArray.length; ++i) {
            dArray[i][i] = 0.0;
        }
    }

    double[][] reduceColumns(double[][] dArray, int n) {
        double[][] dArray2 = new double[dArray.length][n];
        for (int i = 0; i < dArray2.length; ++i) {
            for (int j = 0; j < dArray2[0].length; ++j) {
                dArray2[i][j] = dArray[i][j];
            }
        }
        return dArray2;
    }

    public double[][] predictRatingsSVD(double[][] dArray) {
        int n;
        double[] dArray2;
        int n2;
        int n3;
        double d = 0.01;
        double d2 = 0.01;
        int n4 = dArray.length;
        int n5 = dArray[0].length;
        double[][] dArray3 = new double[n4][n5];
        LinToolImpl linToolImpl = new LinToolImpl();
        int[][] nArray = new int[n4][n5];
        for (int i = 0; i < n4; ++i) {
            for (n3 = 0; n3 < n5; ++n3) {
                if (!(dArray[i][n3] > 0.0)) continue;
                nArray[i][n3] = 1;
            }
        }
        LinResult linResult = LinToolLibrary.computeSVD(dArray);
        n3 = linResult.rank;
        double[][] dArray4 = linToolImpl.copy(linResult.Sigma);
        for (int i = n2 = 3; i < n3; ++i) {
            dArray4[i][i] = 0.0;
        }
        double[][] dArray5 = linToolImpl.mult(linResult.U, dArray4);
        double[][] dArray6 = linToolImpl.transpose(linResult.V);
        double[][] dArray7 = new double[n4][n5];
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n5; ++j) {
                double[] dArray8 = linToolImpl.getRowAsVector(dArray5, i);
                dArray2 = linToolImpl.getColumnAsVector(dArray6, j);
                dArray7[i][j] = linToolImpl.dotProduct(dArray8, dArray2);
            }
        }
        ArrayList<double[]> arrayList = new ArrayList<double[]>();
        ArrayList<double[]> arrayList2 = new ArrayList<double[]>();
        for (n = 0; n < n4; ++n) {
            dArray2 = linToolImpl.getRowAsVector(dArray5, n);
            arrayList.add(dArray2);
        }
        for (n = 0; n < n5; ++n) {
            dArray2 = linToolImpl.getColumnAsVector(dArray6, n);
            arrayList2.add(dArray2);
        }
        double d3 = 0.0;
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n5; ++j) {
                d3 += (double)nArray[i][j] * (dArray[i][j] - dArray7[i][j]) * (dArray[i][j] - dArray7[i][j]);
            }
        }
        double[][] dArray9 = new double[n4][n3];
        double[][] dArray10 = new double[n5][n3];
        boolean bl = false;
        int n6 = 0;
        while (!bl) {
            double[] dArray11;
            int n7;
            double d4;
            int n8;
            int n9;
            ++n6;
            for (n9 = 0; n9 < n4; ++n9) {
                for (n8 = 0; n8 < n3; ++n8) {
                    d4 = 0.0;
                    for (n7 = 0; n7 < n5; ++n7) {
                        dArray11 = (double[])arrayList2.get(n7);
                        d4 += (double)(2 * nArray[n9][n7]) * (dArray[n9][n7] - dArray7[n9][n7]) * dArray11[n8];
                    }
                    dArray9[n9][n8] = -d4;
                }
            }
            for (n9 = 0; n9 < n5; ++n9) {
                for (n8 = 0; n8 < n3; ++n8) {
                    d4 = 0.0;
                    for (n7 = 0; n7 < n4; ++n7) {
                        dArray11 = (double[])arrayList.get(n7);
                        d4 += (double)(2 * nArray[n7][n9]) * (dArray[n7][n9] - dArray7[n7][n9]) * dArray11[n8];
                    }
                    dArray10[n9][n8] = -d4;
                }
            }
            ArrayList<double[]> arrayList3 = new ArrayList<double[]>();
            ArrayList<double[]> arrayList4 = new ArrayList<double[]>();
            d4 = 0.0;
            for (n7 = 0; n7 < n4; ++n7) {
                for (int i = 0; i < n5; ++i) {
                    double[] dArray12 = (double[])arrayList.get(n7);
                    double[] dArray13 = linToolImpl.copy(dArray12);
                    double[] dArray14 = (double[])arrayList2.get(i);
                    double[] dArray15 = linToolImpl.copy(dArray14);
                    double d5 = 0.0;
                    for (int j = 0; j < n3; ++j) {
                        dArray13[j] = dArray12[j] - d * dArray9[n7][j];
                        dArray15[j] = dArray14[j] - d2 * dArray10[i][j];
                        d5 += dArray13[j] * dArray15[j];
                    }
                    d4 += (double)nArray[n7][i] * (dArray[n7][i] - d5) * (dArray[n7][i] - d5);
                    arrayList3.add(n7, dArray13);
                    arrayList4.add(i, dArray15);
                }
            }
            if (d4 >= d3 || n6 > 10) {
                bl = true;
                break;
            }
            for (n7 = 0; n7 < n4; ++n7) {
                double[] dArray16 = (double[])arrayList3.get(n7);
                arrayList.add(n7, dArray16);
            }
            for (n7 = 0; n7 < n5; ++n7) {
                double[] dArray17 = (double[])arrayList4.get(n7);
                arrayList2.add(n7, dArray17);
            }
        }
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n5; ++j) {
                double[] dArray18 = (double[])arrayList.get(i);
                double[] dArray19 = (double[])arrayList2.get(j);
                dArray7[i][j] = linToolImpl.dotProduct(dArray18, dArray19);
            }
        }
        return dArray7;
    }

    public double[][] predictRatingsUserCosines(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        LinToolImpl linToolImpl = new LinToolImpl();
        double[][] dArray2 = linToolImpl.copy(dArray);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (dArray[i][j] > 0.0) continue;
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                for (int k = 0; k < n; ++k) {
                    if (!(dArray[k][j] > 0.0)) continue;
                    arrayList.add(k);
                }
                if (arrayList.size() == 0) continue;
                double[] dArray3 = linToolImpl.getRowAsVector(dArray, i);
                double d = -2.0;
                int n3 = -1;
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    int n4 = (Integer)iterator.next();
                    double[] dArray4 = linToolImpl.getRowAsVector(dArray, n4);
                    double d2 = linToolImpl.cosine(dArray3, dArray4);
                    if (!(d2 > d)) continue;
                    d = d2;
                    n3 = n4;
                }
                dArray2[i][j] = dArray[n3][j];
            }
        }
        return dArray2;
    }

    public void setEyeCoords(double d, double d2, double d3) {
        this.xE = d;
        this.yE = d2;
        this.zE = d3;
        LinToolImpl linToolImpl = new LinToolImpl();
        double d4 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        double d5 = Math.atan2(d2, d);
        double d6 = Math.acos(d3 / d4);
        double[][] dArrayArray = new double[][]{{1.0, 0.0, 0.0, -d}, {0.0, 1.0, 0.0, -d2}, {0.0, 0.0, 1.0, -d3}, {0.0, 0.0, 0.0, 1.0}};
        this.T_E = dArrayArray;
        double d7 = 1.5707963267948966 - d5;
        double d8 = Math.cos(d7);
        double d9 = -Math.sin(d7);
        double d10 = Math.sin(d7);
        double d11 = Math.cos(d7);
        double[][] dArrayArray2 = new double[][]{{d8, d9, 0.0, 0.0}, {d10, d11, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
        this.R_z1 = dArrayArray2;
        d7 = Math.PI;
        d8 = Math.cos(d7);
        d9 = -Math.sin(d7);
        d10 = Math.sin(d7);
        d11 = Math.cos(d7);
        double[][] dArrayArray3 = new double[][]{{d8, d9, 0.0, 0.0}, {d10, d11, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
        this.R_z2 = dArrayArray3;
        d7 = -1.5707963267948966;
        double d12 = Math.cos(d7);
        double d13 = -Math.sin(d7);
        double d14 = Math.sin(d7);
        double d15 = Math.cos(d7);
        double[][] dArrayArray4 = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, d12, d13, 0.0}, {0.0, d14, d15, 0.0}, {0.0, 0.0, 0.0, 1.0}};
        this.R_x1 = dArrayArray4;
        d7 = 1.5707963267948966 - d6;
        d12 = Math.cos(d7);
        d13 = -Math.sin(d7);
        d14 = Math.sin(d7);
        d15 = Math.cos(d7);
        double[][] dArrayArray5 = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, d12, d13, 0.0}, {0.0, d14, d15, 0.0}, {0.0, 0.0, 0.0, 1.0}};
        this.R_x2 = dArrayArray5;
        this.S1 = linToolImpl.mult(this.R_z1, this.T_E);
        this.S2 = linToolImpl.mult(this.R_z2, this.S1);
        this.S3 = linToolImpl.mult(this.R_x1, this.S2);
        this.S4 = linToolImpl.mult(this.R_x2, this.S3);
        this.Trans = this.S4;
    }

    public ArrayList<LinUtil.Line> convertLines(ArrayList<LinUtil.Line> arrayList) {
        ArrayList<LinUtil.Line> arrayList2 = this.convertToAffine(arrayList);
        ArrayList<LinUtil.Line> arrayList3 = this.applyMatrixLines(this.Trans, arrayList2);
        return arrayList3;
    }

    public ArrayList<LinUtil.Line> convertToAffine(ArrayList<LinUtil.Line> arrayList) {
        ArrayList<LinUtil.Line> arrayList2 = new ArrayList<LinUtil.Line>();
        for (int i = 0; i < arrayList.size(); ++i) {
            LinUtil.Line line = arrayList.get(i);
            double[] dArray = new double[line.p.length + 1];
            double[] dArray2 = new double[line.q.length + 1];
            for (int j = 0; j < line.p.length; ++j) {
                dArray[j] = line.p[j];
                dArray2[j] = line.q[j];
            }
            dArray[dArray.length - 1] = 1.0;
            dArray2[dArray2.length - 1] = 1.0;
            arrayList2.add(new LinUtil.Line(dArray, dArray2));
        }
        return arrayList2;
    }

    public ArrayList<LinUtil.Line> applyMatrixLines(double[][] dArray, ArrayList<LinUtil.Line> arrayList) {
        LinToolImpl linToolImpl = new LinToolImpl();
        ArrayList<LinUtil.Line> arrayList2 = new ArrayList<LinUtil.Line>();
        for (int i = 0; i < arrayList.size(); ++i) {
            LinUtil.Line line = arrayList.get(i);
            double[] dArray2 = linToolImpl.matrixVectorMult(dArray, line.p);
            double[] dArray3 = linToolImpl.matrixVectorMult(dArray, line.q);
            arrayList2.add(new LinUtil.Line(dArray2, dArray3));
        }
        return arrayList2;
    }

    public String solveEquations(double[][] dArray, double[] dArray2) {
        LinToolImpl linToolImpl = new LinToolImpl();
        LinResult linResult = linToolImpl.solveFromEither(dArray, dArray2, false, true);
        if (!linResult.solutionExists) {
            return "No solution exists";
        }
        if (linResult.isUniqueSolution) {
            Object object = "Unique solution exists: ";
            for (int i = 0; i < linResult.x.length; ++i) {
                object = (String)object + String.format(" x_%1d=%5.3f", i + 1, linResult.x[i]);
            }
            return object;
        }
        Object object = "Multiple solutions exist. Example: ";
        for (int i = 0; i < linResult.x.length; ++i) {
            object = (String)object + String.format(" x_%1d=%5.3f", i + 1, linResult.x[i]);
        }
        return object;
    }

    public ComplexNumber[] computeDFT(double[] dArray) {
        return this.linImpl.computeDFT(dArray);
    }

    public ComplexNumber[] computeInverseDFT(ComplexNumber[] complexNumberArray) {
        return this.linImpl.computeInverseDFT(complexNumberArray);
    }
}

