/*
 * Decompiled with CFR 0.152.
 */
package edu.gwu.lintool;

import edu.gwu.lintool.ComplexImpl;
import edu.gwu.lintool.ComplexNumber;
import edu.gwu.lintool.EigenvalueDecomposition;
import edu.gwu.lintool.JMatrix;
import edu.gwu.lintool.LinResult;
import edu.gwu.lintool.LinTool;
import edu.gwu.lintool.LinToolImpl;
import edu.gwu.lintool.LinUtil;
import edu.gwu.lintool.SingularValueDecomposition;
import java.util.Arrays;

public class LinTest {
    public static double EPSILON = Math.pow(2.0, -50.0);
    public static double EPSILON2 = Math.pow(2.0, -10.0);
    public static double EPSILON3 = Math.pow(2.0, -6.0);
    static String[] jokes = new String[]{"Voice-mail message on a mathematician's phone: The number you have dialed is imaginary. Rotate your phone by 90 degrees and try again.", "Q: Why do they never serve beer at a math party? A: Because you can't drink and derive.", "Q: Where do mathematicians like to vacation? A: Times Square.", "Q: What happened to the plant in the math classroom? A: It grew square roots.", "Q: What do you call a number that cannot keep still? A: A roamin' numeral.", "There are 10 kinds of people in the world, those who understand binary and those who don't", "Q: Why do Computer Scientists get Halloween and Christmas mixed up? A: Because Oct. 31 = Dec. 25.", "Cat Theorem: A cat has nine tails.\n Proof: No cat has eight tails. A cat has one tail more than no cat. Therefore, a cat has nine tails.", "Q: Why is a math book always unhappy? A: Because it always has lots of problems.", "Q: What do you get if you cross a mosquito with a mountain climber. A: You can't cross a vector with a scalar.", "Q: What's a polar bear? A: A rectangular bear after a coordinate transform."};
    static ComplexNumber complexImpl;

    public static void testClasspath() {
        System.out.println("It worked! LinTool is in the CLASSPATH");
    }

    public static void testRealNumberAdd(LinTool linTool) {
        double d = linTool.add(-8.0, 4.0);
        if (d == -4.0) {
            LinTest.passed("Test real number addition");
        }
    }

    static void passed(String string) {
        System.out.println("  => Passed " + string);
    }

    static void failed(String string) {
        System.out.println("  => Failed " + string);
        System.exit(0);
    }

    static boolean equals(double[] dArray, double[] dArray2, double d) {
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d2 += Math.abs(dArray[i] - dArray2[i]);
        }
        return d2 < d;
    }

    static boolean equals(double[][] dArray, double[][] dArray2, double d) {
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[0].length; ++j) {
                d2 += Math.abs(dArray[i][j] - dArray2[i][j]);
            }
        }
        return d2 < d;
    }

    public static void testVectorOperations(LinTool linTool) {
        System.out.println("Testing vector operations: add, dot-product, scalar-product, norm");
        LinTest.testVectorAdd(linTool);
        LinTest.testVectorScalarProduct(linTool);
        LinTest.testVectorDotProduct(linTool);
        LinTest.testVectorNorm(linTool);
        System.out.println("Passed all tests for vector operations: add, dot-product, scalar-product, norm");
        System.out.println(jokes[1]);
    }

    public static void testVectorAdd(LinTool linTool) {
        System.out.println("> Testing vector addition:");
        double[] dArray = new double[]{1.0};
        double[] dArray2 = new double[]{1.0};
        double[] dArray3 = linTool.add(null, dArray2);
        if (dArray3 != null) {
            LinTest.failed("test 1: null vector");
            return;
        }
        LinTest.passed("test 1: null vector");
        double[] dArray4 = new double[]{2.0};
        dArray3 = linTool.add(dArray, dArray2);
        if (dArray3 == null || dArray3.length != 1 || !LinTest.equals(dArray3, dArray4, EPSILON)) {
            LinTest.failed("test 2: (1) + (1)");
            return;
        }
        LinTest.passed("test 2: (1) + (1)");
        double[] dArray5 = new double[]{1.0, 2.0};
        double[] dArray6 = new double[]{3.0, 4.0};
        double[] dArray7 = new double[]{4.0, 6.0};
        dArray3 = linTool.add(dArray5, dArray6);
        if (dArray3 == null || dArray3.length != 2 || !LinTest.equals(dArray3, dArray7, EPSILON)) {
            LinTest.failed("test 3: (1,2) + (3,4)");
            return;
        }
        LinTest.passed("test 3: (1,2) + (3,4)");
        double[] dArray8 = new double[]{1.0, 2.0, 3.0};
        dArray3 = linTool.add(dArray8, dArray6);
        if (dArray3 != null) {
            LinTest.failed("test 4: unequal lengths");
            return;
        }
        LinTest.passed("test 4: unequal lengths");
        double[] dArray9 = new double[]{-1.0, -2.0, -3.0};
        double[] dArray10 = new double[]{1.0, 2.0, 3.0};
        double[] dArray11 = new double[]{0.0, 0.0, 0.0};
        dArray3 = linTool.add(dArray9, dArray10);
        if (dArray3 == null || dArray3.length != 3 || !LinTest.equals(dArray3, dArray11, EPSILON)) {
            LinTest.failed("test 5: (-1,-2,-3) + (1,2,3)");
            return;
        }
        LinTest.passed("test 5: (-1,-2,-3) + (1,2,3)");
        int n = 1000;
        double[] dArray12 = new double[n];
        double[] dArray13 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray12[i] = i;
            dArray13[i] = -i + 1;
        }
        dArray3 = linTool.add(dArray12, dArray13);
        if (dArray3 == null || dArray3.length != n) {
            LinTest.failed("test 6: vector of size " + n);
            return;
        }
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += dArray3[i];
        }
        if (Math.abs(d - (double)n) > EPSILON) {
            LinTest.failed("test 6: vector of size " + n);
            return;
        }
        LinTest.passed("test 6: vector of size " + n);
        LinTest.passed("all tests for vector addition");
    }

    public static void testVectorDotProduct(LinTool linTool) {
        System.out.println("> Testing vector dot product:");
        double[] dArray = new double[]{1.0, 2.0};
        double[] dArray2 = null;
        double d = linTool.dotProduct(dArray, dArray2);
        if (d != -1.0) {
            LinTest.failed("test 1: null vector");
            return;
        }
        LinTest.passed("test 1: null vector");
        double[] dArray3 = new double[]{1.0, 2.0};
        double[] dArray4 = new double[]{1.0, 2.0, 3.0};
        d = linTool.dotProduct(dArray3, dArray4);
        if (d != -1.0) {
            LinTest.failed("test 2: incompatible lengths");
            return;
        }
        LinTest.passed("test 2: incompatible lengths");
        double[] dArray5 = new double[]{1.0};
        double[] dArray6 = new double[]{2.0};
        d = linTool.dotProduct(dArray5, dArray6);
        if (d != 2.0) {
            LinTest.failed("test 3: size-1 vectors");
            return;
        }
        LinTest.passed("test 3: size-1 vectors");
        double[] dArray7 = new double[]{0.0, 1.0, 2.0};
        double[] dArray8 = new double[]{2.0, -1.0, 3.0};
        d = linTool.dotProduct(dArray7, dArray8);
        if (d != 5.0) {
            LinTest.failed("test 4: (0,1,2) * (2,-1,3)");
            return;
        }
        LinTest.passed("test 4: (0,1,2) * (2,-1,3)");
        LinTest.passed("all tests: vector dot product");
    }

    public static void testVectorScalarProduct(LinTool linTool) {
        System.out.println("> Testing vector multiplication by scalar:");
        double[] dArray = new double[]{1.0};
        double[] dArray2 = linTool.scalarProduct(1.0, (double[])null);
        if (dArray2 != null) {
            LinTest.failed("test 1: null vector");
            return;
        }
        LinTest.passed("test 1: null vector");
        dArray2 = linTool.scalarProduct(2.0, dArray);
        if (dArray2 == null || dArray2.length != 1 || dArray2[0] != 2.0) {
            LinTest.failed("test 2: 2 * (1) ");
            return;
        }
        LinTest.passed("test 2: 2 * (1)");
        double[] dArray3 = new double[]{1.0, 2.0};
        double[] dArray4 = new double[]{3.0, 6.0};
        dArray2 = linTool.scalarProduct(3.0, dArray3);
        if (dArray2 == null || dArray2.length != 2 || !LinTest.equals(dArray2, dArray4, EPSILON)) {
            LinTest.failed("test 3: 3 * (1,2)");
            return;
        }
        LinTest.passed("test 3: 3 * (1,2)");
        int n = 1000;
        double[] dArray5 = new double[n];
        double[] dArray6 = new double[n];
        double d = -2.0;
        for (int i = 0; i < n; ++i) {
            dArray5[i] = i;
            dArray6[i] = d * (double)i;
        }
        dArray2 = linTool.scalarProduct(d, dArray5);
        if (dArray2 == null || dArray2.length != n || !LinTest.equals(dArray2, dArray6, EPSILON)) {
            LinTest.failed("test 4: vector of size " + n);
            return;
        }
        LinTest.passed("test 4: vector of size " + n);
        LinTest.passed("all tests for vector scalar product");
    }

    public static void testVectorNorm(LinTool linTool) {
        System.out.println("> Testing vector norm (magnitude):");
        double d = linTool.norm((double[])null);
        if (d != -1.0) {
            LinTest.failed("test 1: null vector");
            return;
        }
        LinTest.passed("test 1: null vector");
        double[] dArray = new double[]{1.0};
        double d2 = 1.0;
        d = linTool.norm(dArray);
        if (Math.abs(d - d2) > EPSILON) {
            LinTest.failed("test 2: (1)");
            return;
        }
        LinTest.passed("test 2: (1)");
        double[] dArray2 = new double[]{3.0, 4.0};
        double d3 = 5.0;
        d = linTool.norm(dArray2);
        if (Math.abs(d - d3) > EPSILON) {
            LinTest.failed("test 3: (3,4)");
            return;
        }
        LinTest.passed("test 3: (3,4)");
        double[] dArray3 = new double[]{1.0, 2.0, 3.0, 4.0, 2.0, 1.0, 1.0};
        double d4 = 6.0;
        d = linTool.norm(dArray3);
        if (Math.abs(d - d4) > EPSILON) {
            LinTest.failed("test 4: (1,2,3,4,2,1,1)");
            return;
        }
        LinTest.passed("test 4: (1,2,3,4,2,1,1)");
        int n = 1000;
        double[] dArray4 = new double[n];
        double d5 = Math.sqrt(n);
        for (int i = 0; i < n; ++i) {
            dArray4[i] = 1.0;
        }
        d = linTool.norm(dArray4);
        if (Math.abs(d - d5) > EPSILON) {
            LinTest.failed("test 6: vector of size " + n);
            return;
        }
        LinTest.passed("test 6: vector of size " + n);
        LinTest.passed("all tests for vector norm (magnitude):");
    }

    public static void testMatrixOperations(LinTool linTool) {
        System.out.println("Testing matrix operations: add, mult, vector-mult, scalar-product, vector-matrix mult, transpose");
        LinTest.testMatrixAdd(linTool);
        LinTest.testMatrixVectorMult(linTool);
        LinTest.testMatrixMult(linTool);
        LinTest.testMatrixScalarProduct(linTool);
        LinTest.testVectorMatrixMult(linTool);
        LinTest.testMatrixTranspose(linTool);
        System.out.println("Passed all tests for matrix operations: add, mult, vector-mult, scalar-product, vector-matrix mult, transpose");
        System.out.println(jokes[2]);
    }

    public static void testMatrixAdd(LinTool linTool) {
        System.out.println("> Testing matrix addition:");
        double[][] dArrayArray = new double[][]{{0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}};
        double[][] dArray = null;
        double[][] dArray2 = linTool.add(dArrayArray, dArray);
        if (dArray2 != null) {
            LinTest.failed("test 1: null matrix");
            return;
        }
        LinTest.passed("test 1: null matrix");
        double[][] dArrayArray2 = new double[][]{{0.0, 0.0}, {0.0, 0.0}, {0.0, 0.0}};
        dArray2 = linTool.add(dArrayArray, dArrayArray2);
        if (dArray2 != null) {
            LinTest.failed("test 2: incompatible sizes");
            return;
        }
        LinTest.passed("test 2: incompatible sizes");
        double[][] dArrayArray3 = new double[][]{{1.0}};
        double[][] dArrayArray4 = new double[][]{{1.0}};
        dArray2 = linTool.add(dArrayArray3, dArrayArray4);
        if (dArray2 == null || dArray2.length != 1 || dArray2[0].length != 1 || dArray2[0][0] != 2.0) {
            LinTest.failed("test 3: unit size");
            return;
        }
        LinTest.passed("test 3: unit size");
        double[][] dArrayArray5 = new double[][]{{1.0, 1.0, 1.0, 1.0}, {2.0, 2.0, 2.0, 2.0}, {3.0, 3.0, 3.0, 3.0}};
        double[][] dArrayArray6 = new double[][]{{4.0, 0.0, 0.0, 0.0}, {-2.0, -2.0, -2.0, -2.0}, {3.0, 3.0, 3.0, 3.0}};
        dArray2 = linTool.add(dArrayArray5, dArrayArray6);
        if (dArray2 == null || dArray2.length != 3 || dArray2[0].length != 4) {
            LinTest.failed("test 4: 3x4 matrix");
            return;
        }
        LinToolImpl linToolImpl = new LinToolImpl();
        double[][] dArray3 = ((LinTool)linToolImpl).add(dArrayArray5, dArrayArray6);
        if (!LinTest.equals(dArray2, dArray3, EPSILON)) {
            LinTest.failed("test 4: 3x4 matrix");
            return;
        }
        LinTest.passed("test 4: 3x4 matrix");
        int n = 40;
        int n2 = 50;
        double[][] dArray4 = LinUtil.randomIntMatrix(n, n2, 0, 100);
        double[][] dArray5 = LinUtil.randomIntMatrix(n, n2, 0, 100);
        dArray2 = linTool.add(dArray4, dArray5);
        if (dArray2 == null || dArray2.length != n || dArray2[0].length != n2) {
            LinTest.failed("test 5: " + n + "x" + n2 + " matrix");
            return;
        }
        double[][] dArray6 = ((LinTool)linToolImpl).add(dArray4, dArray5);
        if (!LinTest.equals(dArray2, dArray6, EPSILON)) {
            LinTest.failed("test 5: " + n + "x" + n2 + " matrix");
            return;
        }
        LinTest.passed("test 5: " + n + "x" + n2 + " matrix");
        LinTest.passed("all tests for matrix addition");
    }

    public static void testMatrixMult(LinTool linTool) {
        System.out.println("> Testing matrix-matrix multiplication:");
        double[][] dArrayArray = new double[][]{{0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}};
        double[][] dArray = null;
        double[][] dArray2 = linTool.mult(dArrayArray, dArray);
        if (dArray2 != null) {
            LinTest.failed("test 1: null matrix");
            return;
        }
        LinTest.passed("test 1: null matrix");
        double[][] dArrayArray2 = new double[][]{{0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}};
        dArray2 = linTool.mult(dArrayArray, dArrayArray2);
        if (dArray2 != null) {
            LinTest.failed("test 2: incompatible sizes");
            return;
        }
        LinTest.passed("test 2: incompatible sizes");
        double[][] dArrayArray3 = new double[][]{{1.0}};
        double[][] dArrayArray4 = new double[][]{{1.0}};
        dArray2 = linTool.mult(dArrayArray3, dArrayArray4);
        if (dArray2 == null || dArray2.length != 1 || dArray2[0].length != 1 || dArray2[0][0] != 1.0) {
            LinTest.failed("test 3: unit size");
            return;
        }
        LinTest.passed("test 3: unit size");
        double[][] dArrayArray5 = new double[][]{{1.0, 1.0, 1.0, 1.0}, {2.0, 2.0, 2.0, 2.0}, {3.0, 3.0, 3.0, 3.0}};
        double[][] dArrayArray6 = new double[][]{{1.0, 0.0, 0.0, 0.0, 1.0}, {0.0, 1.0, 0.0, 0.0, 1.0}, {0.0, 0.0, 1.0, 0.0, 1.0}, {0.0, 0.0, 0.0, 1.0, 1.0}};
        dArray2 = linTool.mult(dArrayArray5, dArrayArray6);
        if (dArray2 == null || dArray2.length != 3 || dArray2[0].length != 5) {
            LinTest.failed("test 4: 3x4 times 4x5 matrices");
            return;
        }
        LinToolImpl linToolImpl = new LinToolImpl();
        double[][] dArray3 = ((LinTool)linToolImpl).mult(dArrayArray5, dArrayArray6);
        if (!LinTest.equals(dArray2, dArray3, EPSILON)) {
            LinTest.failed("test 4: 3x4 times 4x5 matrices");
            return;
        }
        LinTest.passed("test 4: 3x4 times 4x5 matrices");
        int n = 40;
        int n2 = 50;
        int n3 = 30;
        double[][] dArray4 = LinUtil.randomIntMatrix(n, n2, 0, 100);
        double[][] dArray5 = LinUtil.randomIntMatrix(n2, n3, 0, 100);
        dArray2 = linTool.mult(dArray4, dArray5);
        if (dArray2 == null || dArray2.length != n || dArray2[0].length != n3) {
            LinTest.failed("test 5: " + n + "x" + n2 + " times " + n2 + "x" + n3 + " matrix");
            return;
        }
        double[][] dArray6 = ((LinTool)linToolImpl).mult(dArray4, dArray5);
        if (!LinTest.equals(dArray2, dArray6, EPSILON)) {
            LinTest.failed("test 5: " + n + "x" + n2 + " times " + n2 + "x" + n3 + " matrix");
            return;
        }
        LinTest.passed("test 5: " + n + "x" + n2 + " times " + n2 + "x" + n3 + " matrix");
        LinTest.passed("all tests for matrix-matrix multiplication");
    }

    public static void testMatrixVectorMult(LinTool linTool) {
        System.out.println("> Testing matrix-vector multiplication:");
        double[][] dArrayArray = new double[][]{{0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}};
        double[] dArray = null;
        double[] dArray2 = linTool.matrixVectorMult(dArrayArray, dArray);
        if (dArray2 != null) {
            LinTest.failed("test 1: null matrix");
            return;
        }
        LinTest.passed("test 1: null matrix");
        double[] dArray3 = new double[]{0.0, 0.0};
        dArray2 = linTool.matrixVectorMult(dArrayArray, dArray3);
        if (dArray2 != null) {
            LinTest.failed("test 2: incompatible sizes");
            return;
        }
        LinTest.passed("test 2: incompatible sizes");
        double[][] dArrayArray2 = new double[][]{{1.0}};
        double[] dArray4 = new double[]{1.0};
        dArray2 = linTool.matrixVectorMult(dArrayArray2, dArray4);
        if (dArray2 == null || dArray2.length != 1 || dArray2[0] != 1.0) {
            LinTest.failed("test 3: unit size");
            return;
        }
        LinTest.passed("test 3: unit size");
        double[][] dArrayArray3 = new double[][]{{1.0, 1.0, 1.0, 1.0}, {2.0, 2.0, 2.0, 2.0}};
        double[] dArray5 = new double[]{1.0, 1.0, 1.0, 1.0};
        dArray2 = linTool.matrixVectorMult(dArrayArray3, dArray5);
        if (dArray2 == null || dArray2.length != 2 || dArray2[0] != 4.0 || dArray2[1] != 8.0) {
            LinTest.failed("test 4: 2x4 times 4x1");
            return;
        }
        LinTest.passed("test 4: 2x4 times 4x1");
        int n = 40;
        int n2 = 50;
        double[][] dArray6 = LinUtil.randomIntMatrix(n, n2, 0, 100);
        double[] dArray7 = LinUtil.randomIntVector(n2, 0, 100);
        dArray2 = linTool.matrixVectorMult(dArray6, dArray7);
        if (dArray2 == null || dArray2.length != n) {
            LinTest.failed("test 5: " + n + "x" + n2 + " times length-" + n2 + " vector");
            return;
        }
        LinToolImpl linToolImpl = new LinToolImpl();
        double[] dArray8 = ((LinTool)linToolImpl).matrixVectorMult(dArray6, dArray7);
        if (!LinTest.equals(dArray2, dArray8, EPSILON)) {
            LinTest.failed("test 5: " + n + "x" + n2 + " times length-" + n2 + " vector");
            return;
        }
        LinTest.passed("test 5: " + n + "x" + n2 + " times length-" + n2 + " vector");
        LinTest.passed("all tests for matrix-vector multiplication");
    }

    public static void testMatrixScalarProduct(LinTool linTool) {
        System.out.println("> Testing matrix multiplication by scalar:");
        double[][] dArrayArray = new double[][]{{1.0, 1.0}, {2.0, 2.0}};
        double[][] dArray = linTool.scalarProduct(1.0, (double[][])null);
        if (dArray != null) {
            LinTest.failed("test 1: null matrix");
            return;
        }
        LinTest.passed("test 1: null matrix");
        double[][] dArrayArray2 = new double[][]{{1.0}};
        dArray = linTool.scalarProduct(2.0, dArrayArray2);
        if (dArray == null || dArray.length != 1 || dArray[0].length != 1 || dArray[0][0] != 2.0) {
            LinTest.failed("test 2: unit-size matrix ");
            return;
        }
        LinTest.passed("test 2: unit-size matrix");
        double[][] dArrayArray3 = new double[][]{{1.0, 2.0}, {3.0, 4.0}, {5.0, 6.0}};
        double[][] dArrayArray4 = new double[][]{{2.0, 4.0}, {6.0, 8.0}, {10.0, 12.0}};
        dArray = linTool.scalarProduct(2.0, dArrayArray3);
        if (dArray == null || dArray.length != 3 || dArray[0].length != 2 || !LinTest.equals(dArray, dArrayArray4, EPSILON)) {
            LinTest.failed("test 3: 2 * 3x2 matrix");
            return;
        }
        LinTest.passed("test 3: 2 * 3x2 matrix");
        int n = 40;
        int n2 = 50;
        double d = 10.0;
        double[][] dArray2 = LinUtil.randomIntMatrix(n, n2, 0, 100);
        LinToolImpl linToolImpl = new LinToolImpl();
        double[][] dArray3 = ((LinTool)linToolImpl).scalarProduct(d, dArray2);
        dArray = linTool.scalarProduct(d, dArray2);
        if (dArray == null || dArray.length != n || dArray[0].length != n2 || !LinTest.equals(dArray, dArray3, EPSILON)) {
            LinTest.failed("test 4: " + n + "x" + n2 + " matrix times " + d);
            return;
        }
        LinTest.passed("test 4: " + n + "x" + n2 + " matrix times " + d);
        LinTest.passed("all tests for matrix scalar product");
    }

    public static void testVectorMatrixMult(LinTool linTool) {
        System.out.println("> Testing vector-matrix multiplication:");
        double[][] dArrayArray = new double[][]{{0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}};
        double[] dArray = new double[]{0.0, 0.0};
        double[] dArray2 = linTool.vectorMatrixMult(null, dArrayArray);
        if (dArray2 != null) {
            LinTest.failed("test 1: null matrix");
            return;
        }
        dArray2 = linTool.vectorMatrixMult(dArray, null);
        if (dArray2 != null) {
            LinTest.failed("test 1: null matrix");
            return;
        }
        LinTest.passed("test 1: null matrix");
        double[] dArray3 = new double[]{0.0, 0.0, 0.0};
        dArray2 = linTool.vectorMatrixMult(dArray3, dArrayArray);
        if (dArray2 != null) {
            LinTest.failed("test 2: incompatible sizes");
            return;
        }
        LinTest.passed("test 2: incompatible sizes");
        double[][] dArrayArray2 = new double[][]{{1.0}};
        double[] dArray4 = new double[]{1.0};
        dArray2 = linTool.vectorMatrixMult(dArray4, dArrayArray2);
        if (dArray2 == null || dArray2.length != 1 || dArray2[0] != 1.0) {
            LinTest.failed("test 3: unit size");
            return;
        }
        LinTest.passed("test 3: unit size");
        double[][] dArrayArray3 = new double[][]{{1.0, 1.0, 1.0}, {2.0, 3.0, 4.0}};
        double[] dArray5 = new double[]{1.0, 1.0};
        dArray2 = linTool.vectorMatrixMult(dArray5, dArrayArray3);
        if (dArray2 == null || dArray2.length != 3 || dArray2[0] != 3.0 || dArray2[1] != 4.0 || dArray2[2] != 5.0) {
            LinTest.failed("test 4: length-2 vector times 2x3 matrix");
            return;
        }
        LinTest.passed("test 4: length-2 vector times 2x3 matrix");
        int n = 50;
        int n2 = 40;
        double[][] dArray6 = LinUtil.randomIntMatrix(n, n2, 0, 100);
        double[] dArray7 = LinUtil.randomIntVector(n, 0, 100);
        dArray2 = linTool.vectorMatrixMult(dArray7, dArray6);
        if (dArray2 == null || dArray2.length != n2) {
            LinTest.failed("test 5: length " + n + " vector times " + n + "x" + n2 + " matrix");
            return;
        }
        LinToolImpl linToolImpl = new LinToolImpl();
        double[] dArray8 = ((LinTool)linToolImpl).vectorMatrixMult(dArray7, dArray6);
        if (!LinTest.equals(dArray2, dArray8, EPSILON)) {
            LinTest.failed("test 5: length " + n + " vector times " + n + "x" + n2 + " matrix");
            return;
        }
        LinTest.passed("test 5: length " + n + " vector times " + n + "x" + n2 + " matrix");
        LinTest.passed("all tests for matrix-vector multiplication");
    }

    public static void testMatrixTranspose(LinTool linTool) {
        System.out.println("> Testing matrix transpose:");
        double[][] dArray = linTool.transpose(null);
        if (dArray != null) {
            LinTest.failed("test 1: null matrix");
            return;
        }
        LinTest.passed("test 1: null matrix");
        double[][] dArrayArray = new double[][]{{1.0}};
        dArray = linTool.transpose(dArrayArray);
        if (dArray == null || dArray.length != 1 || dArray[0].length != 1 || dArray[0][0] != 1.0) {
            LinTest.failed("test 2: unit-size matrix ");
            return;
        }
        LinTest.passed("test 2: unit-size matrix");
        double[][] dArrayArray2 = new double[][]{{1.0, 2.0}, {3.0, 4.0}, {5.0, 6.0}};
        double[][] dArrayArray3 = new double[][]{{1.0, 3.0, 5.0}, {2.0, 4.0, 6.0}};
        dArray = linTool.transpose(dArrayArray2);
        if (dArray == null || dArray.length != 2 || dArray[0].length != 3 || !LinTest.equals(dArray, dArrayArray3, EPSILON)) {
            LinTest.failed("test 3: 3x2 matrix ");
            return;
        }
        LinTest.passed("test 3: 3x2 matrix ");
        double[][] dArrayArray4 = new double[][]{{1.0, 1.0, 1.0}, {2.0, 2.0, 2.0}, {3.0, 3.0, 3.0}, {4.0, 4.0, 4.0}, {5.0, 5.0, 5.0}};
        dArray = linTool.transpose(dArrayArray4);
        double[][] dArray2 = linTool.transpose(dArray);
        if (dArray == null || dArray.length != 3 || dArray[0].length != 5 || !LinTest.equals(dArrayArray4, dArray2, EPSILON)) {
            LinTest.failed("test 4: 5x3 matrix ");
            return;
        }
        LinTest.passed("test 4: 5x3 matrix ");
        double[][] dArray3 = LinUtil.randomIntMatrix(30, 40, 0, 100);
        dArray = linTool.transpose(dArray3);
        double[][] dArray4 = linTool.transpose(dArray);
        if (dArray == null || dArray.length != 40 || dArray[0].length != 30 || !LinTest.equals(dArray3, dArray4, EPSILON)) {
            LinTest.failed("test 5: 30x40 matrix ");
            return;
        }
        LinTest.passed("test 5: 30x40 matrix ");
        LinTest.passed("all tests for matrix tranpose");
    }

    public static void testREF(LinTool linTool) {
        System.out.println("Testing matrix REF:");
        LinTest.testReduction(linTool, true, false, false, false);
        LinTest.passed("all tests for REF");
    }

    public static void testRREF(LinTool linTool) {
        System.out.println("Testing matrix RREF:");
        LinTest.testReduction(linTool, false, true, false, false);
        LinTest.passed("all tests for RREF");
        System.out.println(jokes[4]);
    }

    public static void testReduction(LinTool linTool, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        Object object;
        Object object2;
        int n;
        LinResult linResult = null;
        if (bl) {
            linResult = linTool.computeREF(null, null);
        } else if (bl2) {
            linResult = linTool.computeRREF(null, null);
        }
        if (linResult != null) {
            LinTest.failed("test 1: null matrix");
            return;
        }
        LinTest.passed("test 1: null matrix");
        double[][] dArrayArray = new double[][]{{1.0}};
        double[] dArray = new double[]{1.0};
        double[][] dArrayArray2 = new double[][]{{1.0, 1.0}};
        double[][] dArrayArray3 = new double[][]{{1.0, 1.0}};
        double[] dArray2 = new double[]{1.0};
        boolean[] blArray = new boolean[]{true};
        double[][] dArrayArray4 = new double[][]{{1.0}};
        LinResult linResult2 = new LinResult(dArrayArray, dArray, dArrayArray2, dArrayArray3, dArray2, blArray, true, true, dArrayArray4);
        LinTest.testReduction(linTool, bl, bl2, bl3, bl4, "test 2: unit-size matrix", linResult2);
        double[][] dArrayArray5 = new double[][]{{1.0, 0.0}, {0.0, 1.0}};
        double[] dArray3 = new double[]{2.0, 3.0};
        double[] dArray4 = new double[]{2.0, 3.0};
        double[][] dArrayArray6 = new double[][]{{1.0, 0.0, 2.0}, {0.0, 1.0, 3.0}};
        double[][] dArrayArray7 = new double[][]{{1.0, 0.0, 2.0}, {0.0, 1.0, 3.0}};
        boolean[] blArray2 = new boolean[]{true, true};
        double[][] dArrayArray8 = new double[][]{{1.0, 0.0}, {0.0, 1.0}};
        LinResult linResult3 = new LinResult(dArrayArray5, dArray3, dArrayArray6, dArrayArray7, dArray4, blArray2, true, true, dArrayArray8);
        LinTest.testReduction(linTool, bl, bl2, bl3, bl4, "test 3: 2x2 matrix", linResult3);
        double[][] dArrayArray9 = new double[][]{{2.0, 0.0}, {0.0, 3.0}};
        double[] dArray5 = new double[]{4.0, 9.0};
        double[] dArray6 = new double[]{2.0, 3.0};
        double[][] dArrayArray10 = new double[][]{{1.0, 0.0, 2.0}, {0.0, 1.0, 3.0}};
        double[][] dArrayArray11 = new double[][]{{1.0, 0.0, 2.0}, {0.0, 1.0, 3.0}};
        boolean[] blArray3 = new boolean[]{true, true};
        double[][] dArrayArray12 = new double[][]{{0.5, 0.0}, {0.0, 0.3333333333333333}};
        LinResult linResult4 = new LinResult(dArrayArray9, dArray5, dArrayArray10, dArrayArray11, dArray6, blArray3, true, true, dArrayArray12);
        LinTest.testReduction(linTool, bl, bl2, bl3, bl4, "test 4: 2x2 matrix", linResult4);
        double[][] dArrayArray13 = new double[][]{{2.0, 1.0}, {4.0, 3.0}};
        double[] dArray7 = new double[]{7.0, 17.0};
        double[] dArray8 = new double[]{2.0, 3.0};
        double[][] dArrayArray14 = new double[][]{{1.0, 0.5, 3.5}, {0.0, 1.0, 3.0}};
        double[][] dArrayArray15 = new double[][]{{1.0, 0.0, 2.0}, {0.0, 1.0, 3.0}};
        boolean[] blArray4 = new boolean[]{true, true};
        double[][] dArrayArray16 = new double[][]{{1.5, -0.5}, {-2.0, 1.0}};
        LinResult linResult5 = new LinResult(dArrayArray13, dArray7, dArrayArray14, dArrayArray15, dArray8, blArray4, true, true, dArrayArray16);
        LinTest.testReduction(linTool, bl, bl2, bl3, bl4, "test 5: 2x2 matrix", linResult5);
        double[][] dArrayArray17 = new double[][]{{2.0, 0.0}, {0.0, 0.0}};
        double[] dArray9 = new double[]{4.0, 0.0};
        double[] dArray10 = new double[]{2.0, 0.0};
        double[][] dArrayArray18 = new double[][]{{1.0, 0.0, 2.0}, {0.0, 0.0, 0.0}};
        double[][] dArrayArray19 = new double[][]{{1.0, 0.0, 2.0}, {0.0, 0.0, 0.0}};
        boolean[] blArray5 = new boolean[]{true, false};
        double[][] dArray11 = null;
        LinResult linResult6 = new LinResult(dArrayArray17, dArray9, dArrayArray18, dArrayArray19, dArray10, blArray5, true, false, dArray11);
        LinTest.testReduction(linTool, bl, bl2, bl3, bl4, "test 6: 2x2 matrix", linResult6);
        double[][] dArrayArray20 = new double[][]{{0.0, 0.0}, {0.0, 3.0}};
        double[] dArray12 = new double[]{2.0, 9.0};
        double[] dArray13 = null;
        double[][] dArrayArray21 = new double[][]{{0.0, 1.0, 3.0}, {0.0, 0.0, 2.0}};
        double[][] dArrayArray22 = new double[][]{{0.0, 1.0, 3.0}, {0.0, 0.0, 2.0}};
        boolean[] blArray6 = new boolean[]{false, true};
        double[][] dArray14 = null;
        LinResult linResult7 = new LinResult(dArrayArray20, dArray12, dArrayArray21, dArrayArray22, dArray13, blArray6, false, false, dArray14);
        LinTest.testReduction(linTool, bl, bl2, bl3, bl4, "test 7: 2x2 matrix", linResult7);
        double[][] dArrayArray23 = new double[][]{{0.0, 0.0}, {0.0, 0.0}};
        double[] dArray15 = new double[]{2.0, 9.0};
        double[] dArray16 = null;
        double[][] dArrayArray24 = new double[][]{{0.0, 0.0, 2.0}, {0.0, 0.0, 9.0}};
        double[][] dArrayArray25 = new double[][]{{0.0, 0.0, 2.0}, {0.0, 0.0, 9.0}};
        boolean[] blArray7 = new boolean[]{false, false};
        double[][] dArray17 = null;
        LinResult linResult8 = new LinResult(dArrayArray23, dArray15, dArrayArray24, dArrayArray25, dArray16, blArray7, false, false, dArray17);
        LinTest.testReduction(linTool, bl, bl2, bl3, bl4, "test 8: 2x2 matrix", linResult8);
        double[][] dArrayArray26 = new double[][]{{2.0, 0.0}, {0.0, 3.0}, {4.0, 4.0}};
        double[] dArray18 = new double[]{4.0, 9.0, 20.0};
        double[] dArray19 = new double[]{2.0, 3.0};
        double[][] dArrayArray27 = new double[][]{{1.0, 0.0, 2.0}, {0.0, 1.0, 3.0}, {0.0, 0.0, 0.0}};
        double[][] dArrayArray28 = new double[][]{{1.0, 0.0, 2.0}, {0.0, 1.0, 3.0}, {0.0, 0.0, 0.0}};
        boolean[] blArray8 = new boolean[]{true, true};
        double[][] dArray20 = null;
        LinResult linResult9 = new LinResult(dArrayArray26, dArray18, dArrayArray27, dArrayArray28, dArray19, blArray8, true, true, dArray20);
        LinTest.testReduction(linTool, bl, bl2, bl3, bl4, "test 9: 3x2 matrix", linResult9);
        double[][] dArrayArray29 = new double[][]{{2.0, 0.0}, {0.0, 3.0}, {4.0, 4.0}};
        double[] dArray21 = new double[]{4.0, 9.0, 10.0};
        double[] dArray22 = null;
        double[][] dArrayArray30 = new double[][]{{1.0, 0.0, 2.0}, {0.0, 1.0, 3.0}, {0.0, 0.0, -10.0}};
        double[][] dArrayArray31 = new double[][]{{1.0, 0.0, 2.0}, {0.0, 1.0, 3.0}, {0.0, 0.0, -10.0}};
        boolean[] blArray9 = new boolean[]{true, true};
        double[][] dArray23 = null;
        LinResult linResult10 = new LinResult(dArrayArray29, dArray21, dArrayArray30, dArrayArray31, dArray22, blArray9, false, false, dArray23);
        LinTest.testReduction(linTool, bl, bl2, bl3, bl4, "test 10: 3x2 matrix", linResult10);
        double[][] dArrayArray32 = new double[][]{{2.0, 0.0}, {0.0, 3.0}, {1.0, 1.0}, {3.0, 0.0}};
        double[] dArray24 = new double[]{4.0, 9.0, 5.0, 6.0};
        double[] dArray25 = new double[]{2.0, 3.0};
        double[][] dArrayArray33 = new double[][]{{1.0, 0.0, 2.0}, {0.0, 1.0, 3.0}, {0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}};
        double[][] dArrayArray34 = new double[][]{{1.0, 0.0, 2.0}, {0.0, 1.0, 3.0}, {0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}};
        boolean[] blArray10 = new boolean[]{true, true};
        double[][] dArray26 = null;
        LinResult linResult11 = new LinResult(dArrayArray32, dArray24, dArrayArray33, dArrayArray34, dArray25, blArray10, true, true, dArray26);
        LinTest.testReduction(linTool, bl, bl2, bl3, bl4, "test 11: 4x2 matrix", linResult11);
        double[][] dArrayArray35 = new double[][]{{2.0, 0.0}, {0.0, 3.0}, {1.0, 1.0}, {0.0, 2.0}};
        double[] dArray27 = new double[]{4.0, 9.0, 5.0, 4.0};
        double[] dArray28 = null;
        double[][] dArrayArray36 = new double[][]{{1.0, 0.0, 2.0}, {0.0, 1.0, 3.0}, {0.0, 0.0, 0.0}, {0.0, 0.0, -2.0}};
        double[][] dArrayArray37 = new double[][]{{1.0, 0.0, 2.0}, {0.0, 1.0, 3.0}, {0.0, 0.0, 0.0}, {0.0, 0.0, -2.0}};
        boolean[] blArray11 = new boolean[]{true, true};
        double[][] dArray29 = null;
        LinResult linResult12 = new LinResult(dArrayArray35, dArray27, dArrayArray36, dArrayArray37, dArray28, blArray11, false, false, dArray29);
        LinTest.testReduction(linTool, bl, bl2, bl3, bl4, "test 12: 4x2 matrix", linResult12);
        double[][] dArrayArray38 = new double[][]{{2.0, -3.0, 2.0}, {-2.0, 1.0, 0.0}, {1.0, 1.0, -1.0}};
        double[] dArray30 = new double[]{5.0, -1.0, 0.0};
        double[] dArray31 = new double[]{2.0, 3.0, 5.0};
        double[][] dArrayArray39 = new double[][]{{1.0, -1.5, 1.0, 2.5}, {0.0, 1.0, -1.0, -2.0}, {0.0, 0.0, 1.0, 5.0}};
        double[][] dArrayArray40 = new double[][]{{1.0, 0.0, 0.0, 2.0}, {0.0, 1.0, 0.0, 3.0}, {0.0, 0.0, 1.0, 5.0}};
        boolean[] blArray12 = new boolean[]{true, true, true};
        double[][] dArrayArray41 = new double[][]{{0.5, 0.5, 1.0}, {1.0, 2.0, 2.0}, {1.5, 2.5, 2.0}};
        LinResult linResult13 = new LinResult(dArrayArray38, dArray30, dArrayArray39, dArrayArray40, dArray31, blArray12, true, true, dArrayArray41);
        LinTest.testReduction(linTool, bl, bl2, bl3, bl4, "test 13: 3x3 matrix", linResult13);
        double[][] dArrayArray42 = new double[][]{{2.0, -3.0, 2.0}, {-3.0, 7.0, -5.0}, {1.0, 1.0, -1.0}};
        double[] dArray32 = new double[]{5.0, -10.0, 0.0};
        double[] dArray33 = new double[]{2.0, 3.0, 5.0};
        double[][] dArrayArray43 = new double[][]{{1.0, -1.5, 1.0, 2.5}, {0.0, 1.0, -0.8, -1.0}, {0.0, 0.0, 0.0, 0.0}};
        double[][] dArrayArray44 = new double[][]{{1.0, 0.0, -0.2, 1.0}, {0.0, 1.0, -0.8, -1.0}, {0.0, 0.0, 0.0, 0.0}};
        boolean[] blArray13 = new boolean[]{true, true, false};
        double[][] dArray34 = null;
        LinResult linResult14 = new LinResult(dArrayArray42, dArray32, dArrayArray43, dArrayArray44, dArray33, blArray13, true, false, dArray34);
        LinTest.testReduction(linTool, bl, bl2, bl3, bl4, "test 14: 3x3 matrix", linResult14);
        double[][] dArrayArray45 = new double[][]{{2.0, -3.0, 2.0}, {-3.0, 7.0, -5.0}, {1.0, 1.0, -1.0}};
        double[] dArray35 = new double[]{5.0, -9.0, 0.0};
        double[] dArray36 = null;
        double[][] dArrayArray46 = new double[][]{{1.0, -1.5, 1.0, 2.5}, {0.0, 1.0, -0.8, -0.6}, {0.0, 0.0, 0.0, -1.0}};
        double[][] dArrayArray47 = new double[][]{{1.0, 0.0, -0.2, 1.6}, {0.0, 1.0, -0.8, -0.6}, {0.0, 0.0, 0.0, -1.0}};
        boolean[] blArray14 = new boolean[]{true, true, false};
        double[][] dArray37 = null;
        LinResult linResult15 = new LinResult(dArrayArray45, dArray35, dArrayArray46, dArrayArray47, dArray36, blArray14, false, false, dArray37);
        LinTest.testReduction(linTool, bl, bl2, bl3, bl4, "test 15: 3x3 matrix", linResult15);
        double[][] dArrayArray48 = new double[][]{{2.0, -3.0, 2.0}, {-2.0, 1.0, 0.0}};
        double[] dArray38 = new double[]{5.0, -1.0};
        double[] dArray39 = new double[]{2.0, 3.0, 5.0};
        double[][] dArrayArray49 = new double[][]{{1.0, -1.5, 1.0, 2.5}, {0.0, 1.0, -1.0, -2.0}};
        double[][] dArrayArray50 = new double[][]{{1.0, 0.0, -0.5, -0.5}, {0.0, 1.0, -1.0, -2.0}};
        boolean[] blArray15 = new boolean[]{true, true, false};
        double[][] dArray40 = null;
        LinResult linResult16 = new LinResult(dArrayArray48, dArray38, dArrayArray49, dArrayArray50, dArray39, blArray15, true, false, dArray40);
        LinTest.testReduction(linTool, bl, bl2, bl3, bl4, "test 16: 2x3 matrix", linResult16);
        double[][] dArrayArray51 = new double[][]{{2.0, 1.0, 1.0, 3.0}, {1.0, -1.0, 1.0, 0.0}, {0.0, 0.0, 2.0, 1.0}, {1.0, 0.0, 1.0, 0.0}};
        double[] dArray41 = new double[]{6.0, -2.0, -2.0, 1.0};
        double[] dArray42 = new double[]{2.0, 3.0, -1.0, 0.0};
        double[][] dArrayArray52 = new double[][]{{1.0, 0.5, 0.5, 1.5, 3.0}, {0.0, 1.0, -0.3333333333333333, 1.0, 3.3333333333333335}, {0.0, 0.0, 1.0, 0.5, -1.0}, {0.0, 0.0, 0.0, 1.0, 0.0}};
        double[][] dArrayArray53 = new double[][]{{1.0, 0.0, 0.0, 0.0, 2.0}, {0.0, 1.0, 0.0, 0.0, 3.0}, {0.0, 0.0, 1.0, 0.0, -1.0}, {0.0, 0.0, 0.0, 1.0, 0.0}};
        boolean[] blArray16 = new boolean[]{true, true, true, true};
        double[][] dArrayArray54 = new double[][]{{0.143, 0.143, -0.429, 0.571}, {0.0, -1.0, 0.0, 1.0}, {-0.143, -0.143, 0.429, 0.429}, {0.286, 0.286, 0.143, -0.857}};
        LinResult linResult17 = new LinResult(dArrayArray51, dArray41, dArrayArray52, dArrayArray53, dArray42, blArray16, true, true, dArrayArray54);
        LinTest.testReduction(linTool, bl, bl2, bl3, bl4, "test 17: 4x4 matrix", linResult17);
        double[][] dArrayArray55 = new double[][]{{0.0, -3.0, -6.0, 4.0}, {-1.0, -2.0, -1.0, 3.0}, {-2.0, -3.0, 0.0, 3.0}, {1.0, 4.0, 5.0, -9.0}};
        double[] dArray43 = new double[]{9.0, 1.0, -1.0, -7.0};
        double[] dArray44 = null;
        double[][] dArrayArray56 = new double[][]{{1.0, 2.0, 1.0, -3.0, -1.0}, {0.0, 1.0, 2.0, -1.3333333333333333, -3.0}, {0.0, 0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0}};
        double[][] dArrayArray57 = new double[][]{{1.0, 0.0, -3.0, 0.0, 5.0}, {0.0, 1.0, 2.0, 0.0, -3.0}, {0.0, 0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0}};
        boolean[] blArray17 = new boolean[]{true, true, false, true};
        double[][] dArray45 = null;
        LinResult linResult18 = new LinResult(dArrayArray55, dArray43, dArrayArray56, dArrayArray57, dArray44, blArray17, true, false, dArray45);
        LinTest.testReduction(linTool, bl, bl2, bl3, bl4, "test 18: 4x4 matrix", linResult18);
        double[][] dArrayArray58 = new double[][]{{0.0, 3.0, -6.0, 6.0, 4.0}, {3.0, -7.0, 8.0, -5.0, 8.0}, {3.0, -9.0, 12.0, -9.0, 6.0}};
        double[] dArray46 = new double[]{-5.0, 9.0, 15.0};
        double[] dArray47 = null;
        double[][] dArrayArray59 = new double[][]{{1.0, -2.3333333333333335, 2.6666666666666665, -1.6666666666666667, 2.6666666666666665, 3.0}, {0.0, 1.0, -2.0, 2.0, 1.3333333333333333, -1.6666666666666667}, {0.0, 0.0, 0.0, 0.0, 1.0, 4.0}};
        double[][] dArrayArray60 = new double[][]{{1.0, 0.0, -2.0, 3.0, 0.0, -24.0}, {0.0, 1.0, -2.0, 2.0, 0.0, -7.0}, {0.0, 0.0, 0.0, 0.0, 1.0, 4.0}};
        boolean[] blArray18 = new boolean[]{true, true, false, false, true};
        double[][] dArray48 = null;
        LinResult linResult19 = new LinResult(dArrayArray58, dArray46, dArrayArray59, dArrayArray60, dArray47, blArray18, true, false, dArray48);
        LinTest.testReduction(linTool, bl, bl2, bl3, bl4, "test 19: 3x5 matrix", linResult19);
        for (n = 0; n < 10; ++n) {
            LinResult linResult20 = LinUtil.generateLinSystem(8, 8, 8);
            object2 = new LinToolImpl();
            object = ((LinToolImpl)object2).solveFromRREF(linResult20.A, linResult20.b);
            LinTest.testReduction(linTool, bl, bl2, bl3, bl4, "test 20: 8x8 full-rank matrix", (LinResult)object);
        }
        for (n = 0; n < 10; ++n) {
            int n2 = LinUtil.uniform(1, 7);
            object2 = LinUtil.generateLinSystem(8, 8, n2);
            object = new LinToolImpl();
            LinResult linResult21 = ((LinToolImpl)object).solveFromRREF(((LinResult)object2).A, ((LinResult)object2).b);
            LinTest.testReduction(linTool, bl, bl2, bl3, bl4, "test 21: 8x8 non-full-rank matrix", linResult21);
        }
    }

    static void testReduction(LinTool linTool, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string, LinResult linResult) {
        if (!bl3 && bl) {
            LinResult linResult2 = linTool.computeREF(linResult.A, linResult.b);
            if (linResult2 == null || !LinTest.checkREF(linResult2, linResult.ref, linResult.isPivotColumn)) {
                LinTest.failed(string);
                System.exit(0);
                return;
            }
            LinTest.passed(string);
            return;
        }
        if (!bl3 && bl2) {
            LinResult linResult3 = linTool.computeRREF(linResult.A, linResult.b);
            if (linResult3 == null || !LinTest.checkRREF(linResult3, linResult.rref, linResult.isPivotColumn)) {
                LinTest.failed(string);
                System.exit(0);
                return;
            }
            LinTest.passed(string);
            return;
        }
        if (bl3 && bl) {
            LinResult linResult4 = linTool.solveFromREF(linResult.A, linResult.b);
            if (linResult4 == null || !LinTest.checkSolution(linResult4, linResult)) {
                LinTest.failed(string);
                System.exit(0);
                return;
            }
            LinTest.passed(string);
            return;
        }
        if (bl3 && bl2) {
            LinResult linResult5 = linTool.solveFromRREF(linResult.A, linResult.b);
            if (linResult5 == null || !LinTest.checkSolution(linResult5, linResult)) {
                LinTest.failed(string);
                System.exit(0);
                return;
            }
            LinTest.passed(string);
            return;
        }
        if (bl4) {
            LinResult linResult6 = linTool.inverse(linResult.A);
            if (linResult6 == null || !LinTest.checkInverse(linResult6, linResult)) {
                LinTest.failed(string);
                System.exit(0);
                return;
            }
            LinTest.passed(string);
            return;
        }
        if (bl3) {
            LinResult linResult7 = null;
            if (linResult7 == null || !LinTest.checkSolution(linResult7, linResult)) {
                LinTest.failed(string);
                System.exit(0);
                return;
            }
            LinTest.passed(string);
            return;
        }
    }

    static boolean checkREF(LinResult linResult, double[][] dArray, boolean[] blArray) {
        LinToolImpl linToolImpl = new LinToolImpl();
        if (!((LinTool)linToolImpl).approxEquals(linResult.ref, dArray, EPSILON)) {
            return false;
        }
        return LinTest.equals(linResult.isPivotColumn, blArray);
    }

    static boolean checkRREF(LinResult linResult, double[][] dArray, boolean[] blArray) {
        LinToolImpl linToolImpl = new LinToolImpl();
        if (!((LinTool)linToolImpl).approxEquals(linResult.rref, dArray, EPSILON)) {
            return false;
        }
        return LinTest.equals(linResult.isPivotColumn, blArray);
    }

    static boolean checkSolution(LinResult linResult, LinResult linResult2) {
        LinToolImpl linToolImpl;
        if (linResult.solutionExists != linResult2.solutionExists) {
            return false;
        }
        if (linResult.isUniqueSolution != linResult2.isUniqueSolution) {
            return false;
        }
        return !linResult2.isUniqueSolution || ((LinTool)(linToolImpl = new LinToolImpl())).approxEquals(linResult.x, linResult2.x, EPSILON);
    }

    static boolean checkInverse(LinResult linResult, LinResult linResult2) {
        if (linResult2.Ainv == null) {
            return linResult.Ainv == null;
        }
        if (linResult.Ainv.length != linResult.Ainv[0].length) {
            return false;
        }
        if (linResult.Ainv.length != linResult2.A.length) {
            return false;
        }
        LinToolImpl linToolImpl = new LinToolImpl();
        double[][] dArray = linToolImpl.mult(linResult.Ainv, linResult2.A);
        if (dArray == null) {
            return false;
        }
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[0].length; ++j) {
                if (i == j) {
                    d += (dArray[i][j] - 1.0) * (dArray[i][j] - 1.0);
                    continue;
                }
                d += dArray[i][j] * dArray[i][j];
            }
        }
        return !(d > EPSILON);
    }

    public static void testSolveFromREF(LinTool linTool) {
        System.out.println("Testing matrix Solve-From-REF:");
        LinTest.testReduction(linTool, true, false, true, false);
        LinTest.passed("all tests for Solve-From-REF");
    }

    public static void testSolveFromRREF(LinTool linTool) {
        System.out.println("Testing matrix Solve-From-RREF:");
        LinTest.testReduction(linTool, false, true, true, false);
        LinTest.passed("all tests for Solve-From-RREF");
    }

    public static void testInverse(LinTool linTool) {
        System.out.println("Testing matrix inverse:");
        LinTest.testReduction(linTool, false, false, false, true);
        LinTest.passed("all tests for inverse");
        System.out.println(jokes[5]);
    }

    static boolean equals(boolean[] blArray, boolean[] blArray2) {
        if (blArray == null || blArray2 == null || blArray.length != blArray2.length) {
            return false;
        }
        for (int i = 0; i < blArray.length; ++i) {
            if (blArray[i] == blArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static void testGeneration() {
        int n = 10;
        for (int i = 0; i < n; ++i) {
            int n2;
            System.out.println("testGen t=" + i);
            LinResult linResult = LinUtil.generateLinSystem(8, 8, 1);
            LinToolImpl linToolImpl = new LinToolImpl();
            LinResult linResult2 = linToolImpl.computeREF(linResult.A, linResult.b);
            if (LinTest.equals(linResult.isPivotColumn, linResult2.isPivotColumn)) continue;
            System.out.println("Pivot column error");
            System.out.print("Original: ");
            for (n2 = 0; n2 < linResult.isPivotColumn.length; ++n2) {
                System.out.print(" " + linResult.isPivotColumn[n2]);
            }
            System.out.print("\nAnalysed: ");
            for (n2 = 0; n2 < linResult2.isPivotColumn.length; ++n2) {
                System.out.print(" " + linResult2.isPivotColumn[n2]);
            }
            System.out.println();
            LinUtil.print("Generated A", linResult.A);
            LinUtil.print("Generated b", linResult.b);
            LinUtil.print(linResult2.ref);
        }
    }

    public static void testAreColumnsLI(LinTool linTool) {
        System.out.println("Testing Are-Columns-LI:");
        double[][] dArrayArray = new double[][]{{1.0, 0.0}, {0.0, 1.0}};
        if (!linTool.areColumnsLI(dArrayArray)) {
            LinTest.failed("Test 1: 2x2 matrix");
            System.exit(0);
        } else {
            LinTest.passed("Test 1: 2x2 matrix");
        }
        double[][] dArrayArray2 = new double[][]{{2.0, 1.0}, {4.0, 3.0}};
        if (!linTool.areColumnsLI(dArrayArray2)) {
            LinTest.failed("Test 2: 2x2 matrix");
            System.exit(0);
        } else {
            LinTest.passed("Test 2: 2x2 matrix");
        }
        double[][] dArrayArray3 = new double[][]{{2.0, 1.0}, {4.0, 2.0}};
        if (linTool.areColumnsLI(dArrayArray3)) {
            LinTest.failed("Test 3: 2x2 matrix");
            System.exit(0);
        } else {
            LinTest.passed("Test 3: 2x2 matrix");
        }
        double[][] dArrayArray4 = new double[][]{{2.0, -3.0, 2.0}, {-2.0, 1.0, 0.0}, {1.0, 1.0, -1.0}};
        if (!linTool.areColumnsLI(dArrayArray4)) {
            LinTest.failed("Test 4: 3x3 matrix");
            System.exit(0);
        } else {
            LinTest.passed("Test 4: 3x3 matrix");
        }
        double[][] dArrayArray5 = new double[][]{{2.0, -3.0, 2.0}, {-3.0, 7.0, -5.0}, {1.0, 1.0, -1.0}};
        if (linTool.areColumnsLI(dArrayArray5)) {
            LinTest.failed("Test 5: 3x3 matrix");
            System.exit(0);
        } else {
            LinTest.passed("Test 5: 3x3 matrix");
        }
        double[][] dArrayArray6 = new double[][]{{1.0, 4.0}, {2.0, 3.0}, {3.0, 2.0}, {4.0, 1.0}};
        if (!linTool.areColumnsLI(dArrayArray6)) {
            LinTest.failed("Test 6: 4x2 matrix");
            System.exit(0);
        } else {
            LinTest.passed("Test 6: 4x2 matrix");
        }
        double[][] dArrayArray7 = new double[][]{{1.0, 2.0, 3.0, 4.0}, {4.0, 3.0, 2.0, 1.0}};
        if (linTool.areColumnsLI(dArrayArray7)) {
            LinTest.failed("Test 7: 2x4 matrix");
            System.exit(0);
        } else {
            LinTest.passed("Test 7: 2x4 matrix");
        }
        double[][] dArrayArray8 = new double[][]{{1.0, 2.0, 3.0, 4.0}, {4.0, 3.0, 2.0, 1.0}};
        if (linTool.areColumnsLI(dArrayArray8)) {
            LinTest.failed("Test 8: 2x4 matrix");
            System.exit(0);
        } else {
            LinTest.passed("Test 8: 2x4 matrix");
        }
        double[][] dArrayArray9 = new double[][]{{2.0, 1.0, 1.0, 3.0}, {1.0, -1.0, 1.0, 0.0}, {0.0, 0.0, 2.0, 1.0}, {1.0, 0.0, 1.0, 0.0}};
        if (linTool.areColumnsLI(dArrayArray8)) {
            LinTest.failed("Test 9: 4x4 matrix");
            System.exit(0);
        } else {
            LinTest.passed("Test 9: 4x4 matrix");
        }
        LinTest.passed("all tests for Are-Columns-LI");
    }

    public static void testGramSchmidt(LinTool linTool) {
        System.out.println("Testing Gram-Schmidt process:");
        double[][] dArrayArray = new double[][]{{1.0, 0.0}, {0.0, 1.0}};
        LinResult linResult = linTool.gramSchmidt(dArrayArray);
        if (!LinTest.checkOrthogonal(linResult.V) || !LinTest.checkOrthonormal(linResult.Q)) {
            LinTest.failed("Test 1: 2x2 matrix");
            System.exit(0);
        } else {
            LinTest.passed("Test 1: 2x2 matrix");
        }
        double[][] dArrayArray2 = new double[][]{{2.0, 0.0}, {0.0, 3.0}};
        linResult = linTool.gramSchmidt(dArrayArray2);
        if (!LinTest.checkOrthogonal(linResult.V) || !LinTest.checkOrthonormal(linResult.Q)) {
            LinTest.failed("Test 2: 2x2 matrix");
            System.exit(0);
        } else {
            LinTest.passed("Test 2: 2x2 matrix");
        }
        double[][] dArrayArray3 = new double[][]{{2.0, 1.0}, {4.0, 3.0}};
        linResult = linTool.gramSchmidt(dArrayArray3);
        if (!LinTest.checkOrthogonal(linResult.V) || !LinTest.checkOrthonormal(linResult.Q)) {
            LinTest.failed("Test 3: 2x2 matrix");
            System.exit(0);
        } else {
            LinTest.passed("Test 3: 2x2 matrix");
        }
        double[][] dArrayArray4 = new double[][]{{2.0, -3.0, 2.0}, {-2.0, 1.0, 0.0}, {1.0, 1.0, -1.0}};
        linResult = linTool.gramSchmidt(dArrayArray4);
        if (!LinTest.checkOrthogonal(linResult.V) || !LinTest.checkOrthonormal(linResult.Q)) {
            LinTest.failed("Test 4: 3x3 matrix");
            System.exit(0);
        } else {
            LinTest.passed("Test 4: 3x3 matrix");
        }
        double[][] dArrayArray5 = new double[][]{{2.0, 1.0, 1.0, 3.0}, {1.0, -1.0, 1.0, 0.0}, {0.0, 0.0, 2.0, 1.0}, {1.0, 0.0, 1.0, 0.0}};
        linResult = linTool.gramSchmidt(dArrayArray5);
        if (!LinTest.checkOrthogonal(linResult.V) || !LinTest.checkOrthonormal(linResult.Q)) {
            LinTest.failed("Test 5: 4x4 matrix");
            System.exit(0);
        } else {
            LinTest.passed("Test 5: 4x4 matrix");
        }
        for (int i = 0; i < 10; ++i) {
            LinResult linResult2 = LinUtil.generateLinSystem(8, 8, 8);
            linResult = linTool.gramSchmidt(linResult2.A);
            if (LinTest.checkOrthogonal(linResult.V) && LinTest.checkOrthonormal(linResult.Q)) continue;
            LinTest.failed("Test 6: 8x8 matrix");
            System.exit(0);
        }
        LinTest.passed("Test 6: ten 8x8 random full-rank matrices");
        LinTest.passed("all tests for Gram-Schmidt process");
    }

    static boolean checkOrthogonal(double[][] dArray) {
        if (dArray == null) {
            return false;
        }
        int n = dArray.length;
        int n2 = dArray[0].length;
        for (int i = 0; i < n2 - 1; ++i) {
            for (int j = i + 1; j < n2; ++j) {
                double d = 0.0;
                for (int k = 0; k < n; ++k) {
                    d += dArray[k][i] * dArray[k][j];
                }
                if (!(d > EPSILON2)) continue;
                System.out.println("Not orthogonal: col=" + i + " col=" + j);
                return false;
            }
        }
        return true;
    }

    static boolean checkOrthonormal(double[][] dArray) {
        if (dArray == null) {
            return false;
        }
        if (!LinTest.checkOrthogonal(dArray)) {
            return false;
        }
        int n = dArray.length;
        int n2 = dArray[0].length;
        LinToolImpl linToolImpl = new LinToolImpl();
        for (int i = 0; i < n2 - 1; ++i) {
            double[] dArray2 = LinTest.getVector(dArray, i);
            double d = linToolImpl.norm(dArray2);
            if (!(Math.abs(d - 1.0) > EPSILON3)) continue;
            System.out.println("Not orthonormal: col=" + i + " norm=" + d);
            return false;
        }
        return true;
    }

    static double[] getVector(double[][] dArray, int n) {
        int n2 = dArray.length;
        double[] dArray2 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray2[i] = dArray[i][n];
        }
        return dArray2;
    }

    public static void testQR(LinTool linTool) {
        System.out.println("Testing QR factorization:");
        double[][] dArrayArray = new double[][]{{1.0, 0.0}, {0.0, 1.0}};
        LinResult linResult = linTool.computeQR(dArrayArray);
        if (!LinTest.checkOrthonormal(linResult.Q) || !LinTest.checkQR(dArrayArray, linResult)) {
            LinTest.failed("Test 1: 2x2 matrix");
            System.exit(0);
        } else {
            LinTest.passed("Test 1: 2x2 matrix");
        }
        double[][] dArrayArray2 = new double[][]{{2.0, 0.0}, {0.0, 3.0}};
        linResult = linTool.computeQR(dArrayArray2);
        if (!LinTest.checkOrthonormal(linResult.Q) || !LinTest.checkQR(dArrayArray2, linResult)) {
            LinTest.failed("Test 2: 2x2 matrix");
            System.exit(0);
        } else {
            LinTest.passed("Test 2: 2x2 matrix");
        }
        double[][] dArrayArray3 = new double[][]{{2.0, 1.0}, {4.0, 3.0}};
        linResult = linTool.computeQR(dArrayArray3);
        if (!LinTest.checkOrthonormal(linResult.Q) || !LinTest.checkQR(dArrayArray3, linResult)) {
            LinTest.failed("Test 3: 2x2 matrix");
            System.exit(0);
        } else {
            LinTest.passed("Test 3: 2x2 matrix");
        }
        double[][] dArrayArray4 = new double[][]{{2.0, -3.0, 2.0}, {-2.0, 1.0, 0.0}, {1.0, 1.0, -1.0}};
        linResult = linTool.computeQR(dArrayArray4);
        if (!LinTest.checkOrthonormal(linResult.Q) || !LinTest.checkQR(dArrayArray4, linResult)) {
            LinTest.failed("Test 4: 3x3 matrix");
            System.exit(0);
        } else {
            LinTest.passed("Test 4: 3x3 matrix");
        }
        double[][] dArrayArray5 = new double[][]{{2.0, 1.0, 1.0, 3.0}, {1.0, -1.0, 1.0, 0.0}, {0.0, 0.0, 2.0, 1.0}, {1.0, 0.0, 1.0, 0.0}};
        linResult = linTool.computeQR(dArrayArray5);
        if (!LinTest.checkOrthonormal(linResult.Q) || !LinTest.checkQR(dArrayArray5, linResult)) {
            LinTest.failed("Test 5: 4x4 matrix");
            System.exit(0);
        } else {
            LinTest.passed("Test 5: 4x4 matrix");
        }
        for (int i = 0; i < 10; ++i) {
            LinResult linResult2 = LinUtil.generateLinSystem(8, 8, 8);
            linResult = linTool.computeQR(linResult2.A);
            if (LinTest.checkOrthonormal(linResult.Q) && LinTest.checkQR(linResult2.A, linResult)) continue;
            LinTest.failed("Test 6: 8x8 matrix");
            System.exit(0);
        }
        LinTest.passed("Test 6: ten 8x8 random full-rank matrices");
        LinTest.passed("all tests for QR factorization");
    }

    static boolean checkQR(double[][] dArray, LinResult linResult) {
        LinToolImpl linToolImpl = new LinToolImpl();
        double[][] dArray2 = linToolImpl.mult(linResult.Q, linResult.R);
        if (dArray2 == null) {
            return false;
        }
        return linToolImpl.approxEquals(dArray, dArray2, EPSILON2);
    }

    public static void testEigenvalues(LinTool linTool) {
        LinTest.testEigenvalues(linTool, false);
    }

    public static void testEigenvaluesAndVectors(LinTool linTool) {
        LinTest.testEigenvalues(linTool, true);
    }

    public static void testEigenvalues(LinTool linTool, boolean bl) {
        System.out.println("Testing eigenvalue computation:");
        double[][] dArrayArray = new double[][]{{2.0, 1.0}, {2.0, 3.0}};
        LinResult linResult = LinTest.computeEigenvalues(linTool, dArrayArray, bl);
        if (!LinTest.checkEigenvalues(dArrayArray, linResult, bl, false)) {
            LinTest.failed("Test 1: 2x2 matrix");
            System.exit(0);
        } else {
            LinTest.passed("Test 1: 2x2 matrix");
        }
        double[][] dArrayArray2 = new double[][]{{1.0, 0.0}, {1.0, 1.0}};
        linResult = LinTest.computeEigenvalues(linTool, dArrayArray2, bl);
        if (!LinTest.checkEigenvalues(dArrayArray2, linResult, bl, false)) {
            LinTest.failed("Test 2: 2x2 matrix");
            System.exit(0);
        } else {
            LinTest.passed("Test 2: 2x2 matrix");
        }
        double[][] dArrayArray3 = new double[][]{{2.0, 0.0}, {1.0, 3.0}};
        linResult = LinTest.computeEigenvalues(linTool, dArrayArray3, bl);
        if (!LinTest.checkEigenvalues(dArrayArray3, linResult, bl, false)) {
            LinTest.failed("Test 3: 2x2 matrix");
            System.exit(0);
        } else {
            LinTest.passed("Test 3: 2x2 matrix");
        }
        double[][] dArrayArray4 = new double[][]{{1.0, 4.0, 5.0}, {0.0, 2.0, 6.0}, {0.0, 0.0, 3.0}};
        linResult = LinTest.computeEigenvalues(linTool, dArrayArray4, bl);
        if (!LinTest.checkEigenvalues(dArrayArray4, linResult, bl, false)) {
            LinTest.failed("Test 4: 3x3 matrix");
            System.exit(0);
        } else {
            LinTest.passed("Test 4: 3x3 matrix");
        }
        double[][] dArrayArray5 = new double[][]{{1.0, 4.0, 5.0}, {0.0, 2.0, 6.0}, {0.0, 0.0, 2.0}};
        linResult = LinTest.computeEigenvalues(linTool, dArrayArray5, bl);
        if (!LinTest.checkEigenvalues(dArrayArray5, linResult, bl, false)) {
            LinTest.failed("Test 5: 3x3 matrix");
            System.exit(0);
        } else {
            LinTest.passed("Test 5: 3x3 matrix");
        }
        double[][] dArrayArray6 = new double[][]{{2.0, 4.0, 5.0}, {0.0, 2.0, 6.0}, {0.0, 0.0, 2.0}};
        linResult = LinTest.computeEigenvalues(linTool, dArrayArray6, bl);
        if (!LinTest.checkEigenvalues(dArrayArray6, linResult, bl, false)) {
            LinTest.failed("Test 6: 3x3 matrix");
            System.exit(0);
        } else {
            LinTest.passed("Test 6: 3x3 matrix");
        }
        double[][] dArrayArray7 = new double[][]{{2.0, 1.0, 0.0}, {1.0, 3.0, -1.0}, {0.0, -1.0, 6.0}};
        linResult = LinTest.computeEigenvalues(linTool, dArrayArray7, bl);
        if (!LinTest.checkEigenvalues(dArrayArray7, linResult, bl, false)) {
            LinTest.failed("Test 7: 3x3 matrix");
            System.exit(0);
        } else {
            LinTest.passed("Test 7: 3x3 matrix");
        }
        LinTest.passed("all tests for eigenvalue computation");
    }

    static LinResult computeEigenvalues(LinTool linTool, double[][] dArray, boolean bl) {
        if (!bl) {
            return linTool.computeEigenvalues(dArray);
        }
        return linTool.computeEigenvaluesAndVectors(dArray);
    }

    static boolean checkEigenvalues(double[][] dArray, LinResult linResult, boolean bl, boolean bl2) {
        if (linResult == null || linResult.S == null || linResult.lambda == null) {
            return false;
        }
        JMatrix jMatrix = new JMatrix(dArray);
        EigenvalueDecomposition eigenvalueDecomposition = new EigenvalueDecomposition(jMatrix);
        double[] dArray2 = eigenvalueDecomposition.getRealEigenvalues();
        Arrays.sort(dArray2);
        double[] dArray3 = LinTest.copy(linResult.lambda);
        Arrays.sort(dArray3);
        LinToolImpl linToolImpl = new LinToolImpl();
        if (!linToolImpl.approxEquals(dArray2, dArray3, EPSILON3)) {
            System.out.println("FAILED: eigenvalues not approximately correct");
            return false;
        }
        if (!bl && !bl2) {
            return true;
        }
        double[][] dArray4 = eigenvalueDecomposition.getV().getArray();
        dArray2 = eigenvalueDecomposition.getRealEigenvalues();
        if (bl) {
            return LinTest.checkEigenvectors(dArray, linResult.S, linResult.lambda);
        }
        if (bl2) {
            if (!LinTest.checkEigenDecomposition(dArray, linResult)) {
                System.out.println("FAILED: eigendecomposition test");
                return false;
            }
            return true;
        }
        return true;
    }

    static boolean checkEigenvectors(double[][] dArray, double[][] dArray2, double[] dArray3) {
        LinToolImpl linToolImpl = new LinToolImpl();
        for (int i = 0; i < dArray2[0].length; ++i) {
            double[] dArray4 = linToolImpl.getColumnAsVector(dArray2, i);
            double[] dArray5 = linToolImpl.scalarProduct(dArray3[i], dArray4);
            double[] dArray6 = linToolImpl.matrixVectorMult(dArray, dArray4);
            boolean bl = true;
            for (int j = 0; j < dArray5.length; ++j) {
                double d;
                double d2 = Math.abs(dArray6[j] - dArray5[j]);
                if (dArray5[j] == 0.0 || !((d = Math.abs(d2 / dArray5[j])) > 0.1)) continue;
                bl = false;
            }
            if (bl) continue;
            System.out.println("FAILED: eigenvector: Ax!=lambdax");
            return false;
        }
        return true;
    }

    static boolean checkEigenDecomposition(double[][] dArray, LinResult linResult) {
        int n = dArray.length;
        double[][] dArray2 = new double[n][n];
        for (int i = 0; i < n; ++i) {
            dArray2[i][i] = linResult.lambda[i];
        }
        LinToolImpl linToolImpl = new LinToolImpl();
        double[][] dArray3 = linToolImpl.mult(linResult.S, dArray2);
        double[][] dArray4 = linToolImpl.mult(dArray3, linResult.Sinv);
        if (!linToolImpl.approxEquals(dArray4, dArray, EPSILON3)) {
            System.out.println("FAILED: eigendecomposition check");
            LinUtil.print("S3", dArray4);
            LinUtil.print("A", dArray);
            return false;
        }
        return true;
    }

    public static void testEigenvaluesAndVectorsSymmetric(LinTool linTool) {
        System.out.println("Testing eigenvalue+eigenvector computation for symmetric matrices:");
        LinTest.testEigenvaluesAndVectorsSymmetric(linTool, false);
        LinTest.passed("all tests for eigenvalue+eigenvector computation for symmetric matrices");
    }

    public static void testEigenvaluesAndVectorsSymmetric(LinTool linTool, boolean bl) {
        double[][] dArrayArray = new double[][]{{2.0, 2.0}, {2.0, 3.0}};
        LinResult linResult = LinTest.computeEigenSymmetric(linTool, dArrayArray, bl);
        if (!LinTest.checkEigenvalues(dArrayArray, linResult, false, bl)) {
            LinTest.failed("Test 1: 2x2 matrix");
            System.exit(0);
        } else {
            LinTest.passed("Test 1: 2x2 matrix");
        }
        double[][] dArrayArray2 = new double[][]{{2.0, 2.0, 1.0}, {2.0, 3.0, 4.0}, {1.0, 4.0, 1.0}};
        linResult = LinTest.computeEigenSymmetric(linTool, dArrayArray2, bl);
        if (!LinTest.checkEigenvalues(dArrayArray2, linResult, false, bl)) {
            LinTest.failed("Test 2: 3x3 matrix");
            System.exit(0);
        } else {
            LinTest.passed("Test 2: 3x3 matrix");
        }
        double[][] dArrayArray3 = new double[][]{{2.0, 2.0, 1.0}, {2.0, 2.0, 4.0}, {1.0, 4.0, 1.0}};
        linResult = LinTest.computeEigenSymmetric(linTool, dArrayArray3, bl);
        if (!LinTest.checkEigenvalues(dArrayArray3, linResult, false, bl)) {
            LinTest.failed("Test 3: 3x3 matrix");
            System.exit(0);
        } else {
            LinTest.passed("Test 3: 3x3 matrix");
        }
        double[][] dArrayArray4 = new double[][]{{2.0, 2.0, 1.0, 5.0}, {2.0, 2.0, 4.0, 3.0}, {1.0, 4.0, 1.0, -1.0}, {5.0, 3.0, -1.0, 6.0}};
        linResult = LinTest.computeEigenSymmetric(linTool, dArrayArray4, bl);
        if (!LinTest.checkEigenvalues(dArrayArray4, linResult, false, bl)) {
            LinTest.failed("Test 4: 4x4 matrix");
            System.exit(0);
        } else {
            LinTest.passed("Test 4: 4x4 matrix");
        }
        double[][] dArrayArray5 = new double[][]{{6.0, 3.0, 7.0, 8.0, 5.0, 9.0, 8.0, 5.0}, {3.0, 9.0, 4.0, 10.0, 7.0, 4.0, 3.0, 8.0}, {7.0, 4.0, 5.0, 9.0, 5.0, 3.0, 7.0, 6.0}, {8.0, 10.0, 9.0, 4.0, 9.0, 1.0, 1.0, 2.0}, {5.0, 7.0, 5.0, 9.0, 9.0, 5.0, 1.0, 2.0}, {9.0, 4.0, 3.0, 1.0, 5.0, 10.0, 5.0, 5.0}, {8.0, 3.0, 7.0, 1.0, 1.0, 5.0, 1.0, 5.0}, {5.0, 8.0, 6.0, 2.0, 2.0, 5.0, 5.0, 6.0}};
        linResult = LinTest.computeEigenSymmetric(linTool, dArrayArray5, bl);
        if (!LinTest.checkEigenvalues(dArrayArray5, linResult, false, bl)) {
            LinTest.failed("Test 5: 8x8 matrix");
            System.exit(0);
        } else {
            LinTest.passed("Test 5: 8x8 matrix");
        }
        double[][] dArrayArray6 = new double[][]{{8.0, 8.0, 10.0, 8.0, 10.0, 10.0, 8.0, 1.0}, {8.0, 10.0, 6.0, 9.0, 9.0, 1.0, 8.0, 2.0}, {10.0, 6.0, 6.0, 2.0, 5.0, 10.0, 7.0, 9.0}, {8.0, 9.0, 2.0, 3.0, 9.0, 8.0, 6.0, 3.0}, {10.0, 9.0, 5.0, 9.0, 5.0, 7.0, 8.0, 4.0}, {10.0, 1.0, 10.0, 8.0, 7.0, 1.0, 6.0, 7.0}, {8.0, 8.0, 7.0, 6.0, 8.0, 6.0, 8.0, 10.0}, {1.0, 2.0, 9.0, 3.0, 4.0, 7.0, 10.0, 5.0}};
        linResult = LinTest.computeEigenSymmetric(linTool, dArrayArray6, bl);
        if (!LinTest.checkEigenvalues(dArrayArray6, linResult, false, bl)) {
            LinTest.failed("Test 6: 8x8 matrix");
            System.exit(0);
        } else {
            LinTest.passed("Test 6: 8x8 matrix");
        }
        double[][] dArrayArray7 = new double[][]{{3.0, 2.0, 4.0, 9.0, 9.0, 2.0, 7.0, 6.0}, {2.0, 6.0, 7.0, 5.0, 6.0, 2.0, 6.0, 4.0}, {4.0, 7.0, 7.0, 1.0, 4.0, 9.0, 1.0, 6.0}, {9.0, 5.0, 1.0, 1.0, 7.0, 4.0, 9.0, 8.0}, {9.0, 6.0, 4.0, 7.0, 7.0, 4.0, 5.0, 2.0}, {2.0, 2.0, 9.0, 4.0, 4.0, 6.0, 7.0, 6.0}, {7.0, 6.0, 1.0, 9.0, 5.0, 7.0, 5.0, 7.0}, {6.0, 4.0, 6.0, 8.0, 2.0, 6.0, 7.0, 10.0}};
        linResult = LinTest.computeEigenSymmetric(linTool, dArrayArray7, bl);
        if (!LinTest.checkEigenvalues(dArrayArray7, linResult, false, bl)) {
            LinTest.failed("Test 7: 8x8 matrix");
            System.exit(0);
        } else {
            LinTest.passed("Test 7: 8x8 matrix");
        }
    }

    static LinResult computeEigenSymmetric(LinTool linTool, double[][] dArray, boolean bl) {
        if (!bl) {
            return linTool.computeEigenvaluesAndVectorsSymmetric(dArray);
        }
        return linTool.computeSpectralDecompositionSymmetric(dArray);
    }

    static void libraryEigenvalues(double[][] dArray) {
        JMatrix jMatrix = new JMatrix(dArray);
        EigenvalueDecomposition eigenvalueDecomposition = new EigenvalueDecomposition(jMatrix);
        double[][] dArray2 = eigenvalueDecomposition.getV().getArray();
        double[] dArray3 = eigenvalueDecomposition.getRealEigenvalues();
    }

    static double[] copy(double[] dArray) {
        if (dArray == null) {
            return null;
        }
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = dArray[i];
        }
        return dArray2;
    }

    public static void testSpectralDecompositionSymmetric(LinTool linTool) {
        System.out.println("Testing eigenvalue decompostion for symmetric matrices:");
        LinTest.testEigenvaluesAndVectorsSymmetric(linTool, true);
        LinTest.passed("all tests for eigenvalue decomposition for symmetric matrices");
    }

    public static void testSVD(LinTool linTool) {
        double[][] dArrayArray = new double[][]{{1.0, -1.0}, {-2.0, 2.0}, {2.0, -2.0}};
        LinResult linResult = linTool.computeSVD(dArrayArray);
        if (linResult == null || !LinTest.checkSVD(dArrayArray, linResult)) {
            LinTest.failed("Test 1: 3x2 matrix");
            System.exit(0);
        }
        LinTest.passed("Test 1: 3x2 matrix");
        double[][] dArrayArray2 = new double[][]{{1.0, -1.0, 2.0}, {2.0, 3.0, 4.0}, {-3.0, 2.0, 3.0}, {3.0, 4.0, 5.0}};
        linResult = linTool.computeSVD(dArrayArray2);
        if (linResult == null || !LinTest.checkSVD(dArrayArray2, linResult)) {
            LinTest.failed("Test 2: 4x3 matrix");
            System.exit(0);
        }
        LinTest.passed("Test 2: 4x3 matrix");
        double[][] dArrayArray3 = new double[][]{{6.0, -8.0, -4.0, 5.0, -4.0}, {2.0, 7.0, -5.0, -6.0, 4.0}, {0.0, -1.0, -8.0, 2.0, 2.0}, {-1.0, -2.0, 4.0, 4.0, -8.0}};
        linResult = linTool.computeSVD(dArrayArray3);
        if (linResult == null || !LinTest.checkSVD(dArrayArray3, linResult)) {
            LinTest.failed("Test 3: 4x5 matrix");
            System.exit(0);
        }
        LinTest.passed("Test 3: 4x5 matrix");
        double[][] dArrayArray4 = new double[][]{{2.0, 0.0, 8.0, 6.0, 0.0}, {1.0, 6.0, 0.0, 1.0, 7.0}, {5.0, 0.0, 7.0, 4.0, 0.0}, {7.0, 0.0, 8.0, 5.0, 0.0}, {0.0, 10.0, 0.0, 0.0, 7.0}};
        linResult = linTool.computeSVD(dArrayArray4);
        if (linResult == null || !LinTest.checkSVD(dArrayArray4, linResult)) {
            LinTest.failed("Test 4: 5x5 matrix");
            System.exit(0);
        }
        LinTest.passed("Test 4: 5x5 matrix");
        double[][] dArrayArray5 = new double[][]{{1.0, 0.0, 1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 1.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 0.0, 0.0, 1.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0, 0.0, 1.0}};
        linResult = linTool.computeSVD(dArrayArray5);
        if (linResult == null || !LinTest.checkSVD(dArrayArray5, linResult)) {
            LinTest.failed("Test 5: 5x6 matrix");
            System.exit(0);
        }
        LinTest.passed("Test 5: 5x6 matrix");
        double[][] dArrayArray6 = new double[][]{{1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 1.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0}};
        linResult = linTool.computeSVD(dArrayArray6);
        if (linResult == null || !LinTest.checkSVD(dArrayArray6, linResult)) {
            LinTest.failed("Test 6: 12x9 matrix");
            System.exit(0);
        }
        LinTest.passed("Test 6: 12x9 matrix");
        double[][] dArrayArray7 = new double[][]{{0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.0, 0.0}, {1.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0}, {0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
        linResult = linTool.computeSVD(dArrayArray7);
        if (linResult == null || !LinTest.checkSVD(dArrayArray7, linResult)) {
            LinTest.failed("Test 7: 12x9 matrix");
            System.exit(0);
        }
        LinTest.passed("Test 7: 12x9 matrix");
    }

    static boolean checkSVD(double[][] dArray, LinResult linResult) {
        if (linResult == null || linResult.U == null || linResult.V == null || linResult.sigma == null) {
            System.out.println("null problem");
            return false;
        }
        int n = dArray.length;
        int n2 = dArray[0].length;
        int n3 = linResult.sigma.length;
        if (linResult.U.length != n || linResult.U[0].length != n3 || linResult.V.length != n2 || linResult.V[0].length != n3) {
            System.out.println("size problem: U is " + linResult.U.length + "x" + linResult.U[0].length + "  V is " + linResult.V.length + "x" + linResult.V[0].length);
            return false;
        }
        double[][] dArray2 = new double[n3][n3];
        System.out.println("m=" + n + " n=" + n2 + " sigL=" + linResult.sigma.length);
        for (int i = 0; i < n3; ++i) {
            dArray2[i][i] = linResult.sigma[i];
        }
        LinToolImpl linToolImpl = new LinToolImpl();
        double[][] dArray3 = linToolImpl.mult(linResult.U, dArray2);
        double[][] dArray4 = linToolImpl.transpose(linResult.V);
        double[][] dArray5 = linToolImpl.mult(dArray3, dArray4);
        if (!LinTest.checkOrthonormal(linResult.U) || !LinTest.checkOrthonormal(linResult.V)) {
            System.out.println("ortho problem: checkU=" + LinTest.checkOrthonormal(linResult.U) + " checkV=" + LinTest.checkOrthonormal(linResult.V));
            LinTest.printSVDProblem(dArray, linResult, dArray5, dArray2);
            return false;
        }
        if (!linToolImpl.approxEquals(dArray, dArray5, EPSILON3)) {
            System.out.println("approx problem: Rank=" + linResult.rank);
            LinTest.printSVDProblem(dArray, linResult, dArray5, dArray2);
            return false;
        }
        return true;
    }

    static void printSVDProblem(double[][] dArray, LinResult linResult, double[][] dArray2, double[][] dArray3) {
        System.out.println("SVD: rank=" + linResult.rank);
        LinToolImpl linToolImpl = new LinToolImpl();
        JMatrix jMatrix = new JMatrix(dArray);
        SingularValueDecomposition singularValueDecomposition = new SingularValueDecomposition(jMatrix);
        double[][] dArray4 = linToolImpl.mult(singularValueDecomposition.getU().getArray(), dArray3);
        double[][] dArray5 = linToolImpl.transpose(singularValueDecomposition.getV().getArray());
        double[][] dArray6 = linToolImpl.mult(dArray4, dArray5);
        LinUtil.print("sigma", linResult.sigma);
        LinUtil.print("Correct-sigma", singularValueDecomposition.getSingularValues());
        LinUtil.print("Sigma", dArray3);
        LinUtil.print("A", dArray);
        LinUtil.print("Am", dArray2);
        LinUtil.print("A2", dArray6);
        LinUtil.print("U", linResult.U);
        LinUtil.print("Correct-U", singularValueDecomposition.getU().getArray());
        LinUtil.print("V", linResult.V);
        LinUtil.print("Correct-V", singularValueDecomposition.getV().getArray());
    }

    public static void testPseudoInverse(LinTool linTool) {
        double[][] dArrayArray = new double[][]{{1.0, 0.0}, {0.0, 1.0}};
        LinResult linResult = linTool.pseudoInverse(dArrayArray);
        LinTest.testPseudoInverse(dArrayArray, linResult, "Test 1: 2x2");
        double[][] dArrayArray2 = new double[][]{{2.0, 0.0}, {0.0, 3.0}};
        linResult = linTool.pseudoInverse(dArrayArray2);
        LinTest.testPseudoInverse(dArrayArray2, linResult, "Test 2: 2x2");
        double[][] dArrayArray3 = new double[][]{{2.0, 1.0}, {4.0, 3.0}};
        linResult = linTool.pseudoInverse(dArrayArray3);
        LinTest.testPseudoInverse(dArrayArray3, linResult, "Test 3: 2x2");
        double[][] dArrayArray4 = new double[][]{{2.0, 0.0}, {0.0, 3.0}, {4.0, 4.0}};
        linResult = linTool.pseudoInverse(dArrayArray4);
        LinTest.testPseudoInverse(dArrayArray4, linResult, "Test 4: 3x2");
        double[][] dArrayArray5 = new double[][]{{2.0, 0.0}, {0.0, 3.0}, {4.0, 4.0}, {3.0, 0.0}};
        linResult = linTool.pseudoInverse(dArrayArray5);
        LinTest.testPseudoInverse(dArrayArray5, linResult, "Test 5: 4x2");
        double[][] dArrayArray6 = new double[][]{{2.0, 0.0}, {0.0, 3.0}, {4.0, 4.0}, {0.0, 2.0}};
        linResult = linTool.pseudoInverse(dArrayArray6);
        LinTest.testPseudoInverse(dArrayArray6, linResult, "Test 6: 4x2");
        double[][] dArrayArray7 = new double[][]{{2.0, -3.0, 2.0}, {-2.0, 1.0, 0.0}, {1.0, 1.0, -1.0}};
        linResult = linTool.pseudoInverse(dArrayArray7);
        LinTest.testPseudoInverse(dArrayArray7, linResult, "Test 7: 3x3");
        double[][] dArrayArray8 = new double[][]{{2.0, -3.0, 2.0}, {-3.0, 7.0, -5.0}, {1.0, 1.0, -1.0}};
        linResult = linTool.pseudoInverse(dArrayArray8);
        LinTest.testPseudoInverse(dArrayArray8, linResult, "Test 8: 3x3");
        double[][] dArrayArray9 = new double[][]{{2.0, 1.0, 1.0, 3.0}, {1.0, -1.0, 1.0, 0.0}, {0.0, 0.0, 2.0, 1.0}, {1.0, 0.0, 1.0, 0.0}};
        linResult = linTool.pseudoInverse(dArrayArray9);
        LinTest.testPseudoInverse(dArrayArray9, linResult, "Test 9: 4x4");
        double[][] dArrayArray10 = new double[][]{{2.0, 1.0, 1.0, 3.0}, {1.0, -1.0, 1.0, 0.0}, {0.0, 0.0, 2.0, 1.0}, {1.0, 0.0, 1.0, 0.0}, {2.0, 1.0, 3.0, 3.0}, {1.0, 2.0, 0.0, 3.0}};
        linResult = linTool.pseudoInverse(dArrayArray10);
        LinTest.testPseudoInverse(dArrayArray10, linResult, "Test 10: 6x4");
        double[][] dArrayArray11 = new double[][]{{2.0, 1.0, 1.0, 2.0}, {1.0, -1.0, 1.0, 2.0}, {0.0, 0.0, 2.0, 4.0}, {1.0, 0.0, 1.0, 2.0}, {3.0, 0.0, 2.0, 4.0}};
        linResult = linTool.pseudoInverse(dArrayArray11);
        LinTest.testPseudoInverse(dArrayArray11, linResult, "Test 11: 5x4");
    }

    public static void testPseudoInverse(double[][] dArray, LinResult linResult, String string) {
        if (linResult == null || linResult.A_plus == null) {
            LinTest.failed(string);
            System.exit(0);
            return;
        }
        if (linResult.A_plus.length != dArray[0].length || linResult.A_plus[0].length != dArray.length) {
            LinTest.failed(string + " improper dimensions");
            System.exit(0);
            return;
        }
        LinToolImpl linToolImpl = new LinToolImpl();
        double[][] dArray2 = linToolImpl.mult(linResult.A_plus, dArray);
        double d = 0.0;
        for (int i = 0; i < dArray2.length; ++i) {
            for (int j = 0; j < dArray2[0].length; ++j) {
                if (i == j) {
                    d += (dArray2[i][j] - 1.0) * (dArray2[i][j] - 1.0);
                    continue;
                }
                d += dArray2[i][j] * dArray2[i][j];
            }
        }
        System.out.println(" >> Squared-Diff(A+ * A, I) = " + d);
        LinTest.passed(string);
    }

    public static void testLeastSquares(LinTool linTool) {
        double[][] dArrayArray = new double[][]{{0.0, 1.0}, {1.0, 1.0}, {2.0, 1.0}, {3.0, 1.0}};
        double[] dArray = new double[]{3.0, 5.0, 7.0, 9.0};
        double[] dArray2 = new double[]{2.0, 3.0};
        LinResult linResult = linTool.solveLeastSquares(dArrayArray, dArray);
        LinTest.testLeastSquares(dArrayArray, dArray, dArray2, linResult, "Test 1: 4x2 exact");
        double[][] dArrayArray2 = new double[][]{{0.0, 1.0}, {0.9, 1.0}, {2.0, 1.0}};
        double[] dArray3 = new double[]{3.1, 5.0, 6.8};
        double[] dArray4 = new double[]{2.0, 3.0};
        linResult = linTool.solveLeastSquares(dArrayArray2, dArray3);
        LinTest.testLeastSquares(dArrayArray2, dArray3, dArray4, linResult, "Test 2: 3x2");
        double[][] dArrayArray3 = new double[][]{{0.0, 1.0}, {0.9, 1.0}, {2.0, 1.0}, {2.9, 1.0}};
        double[] dArray5 = new double[]{3.1, 5.0, 6.8, 8.8};
        double[] dArray6 = new double[]{2.0, 3.0};
        linResult = linTool.solveLeastSquares(dArrayArray3, dArray5);
        LinTest.testLeastSquares(dArrayArray3, dArray5, dArray6, linResult, "Test 3: 4x2");
        double[][] dArrayArray4 = new double[][]{{1.0, 0.0, 0.0}, {0.0, 2.0, 1.0}, {-2.0, 3.0, 1.0}, {11.0, 1.0, 4.0}, {9.0, -1.0, 2.0}};
        double[] dArray7 = new double[]{1.0, 1.0, 1.0, 1.0, 1.0};
        double[] dArray8 = new double[]{1.0, 2.0, -3.0};
        linResult = linTool.solveLeastSquares(dArrayArray4, dArray7);
        LinTest.testLeastSquares(dArrayArray4, dArray7, dArray8, linResult, "Test 4: 5x3");
        double[][] dArrayArray5 = new double[][]{{0.9, 0.0, 0.1}, {0.0, 2.1, 1.0}, {-1.9, 2.9, 1.1}, {10.9, 0.9, 4.0}};
        double[] dArray9 = new double[]{1.0, 1.0, 1.0, 1.0};
        double[] dArray10 = new double[]{1.0, 2.0, -3.0};
        linResult = linTool.solveLeastSquares(dArrayArray5, dArray9);
        LinTest.testLeastSquares(dArrayArray5, dArray9, dArray10, linResult, "Test 5: 4x3");
        double[][] dArrayArray6 = new double[][]{{0.9, 0.0, 0.1}, {0.0, 2.1, 1.0}, {-1.9, 2.9, 1.1}, {10.9, 0.9, 4.0}, {8.8, -1.0, 2.2}};
        double[] dArray11 = new double[]{1.0, 1.0, 1.0, 1.0, 1.0};
        double[] dArray12 = new double[]{1.0, 2.0, -3.0};
        linResult = linTool.solveLeastSquares(dArrayArray6, dArray11);
        LinTest.testLeastSquares(dArrayArray6, dArray11, dArray12, linResult, "Test 6: 5x3");
    }

    static void makeRandomCirclePoints(double d, double d2, double d3, int n, double[] dArray, double[] dArray2) {
        for (int i = 0; i < n; ++i) {
            double d4 = LinUtil.uniform(0.0, Math.PI * 2);
            double d5 = d + d3 * Math.cos(d4);
            double d6 = d2 + d3 * Math.sin(d4);
            double d7 = LinUtil.uniform(0.0, 0.4 * d3) - 0.2 * d3;
            double d8 = LinUtil.uniform(0.0, 0.4 * d3) - 0.2 * d3;
            dArray[i] = d5 + d7;
            dArray2[i] = d6 + d8;
        }
    }

    static double[][] makeCircle_A(double[] dArray, double[] dArray2) {
        double[][] dArray3 = new double[dArray.length][3];
        for (int i = 0; i < dArray3.length; ++i) {
            dArray3[i][0] = 2.0 * dArray[i];
            dArray3[i][1] = 2.0 * dArray2[i];
            dArray3[i][2] = 1.0;
        }
        return dArray3;
    }

    static double[] makeCircle_b(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[dArray.length];
        for (int i = 0; i < dArray3.length; ++i) {
            dArray3[i] = dArray[i] * dArray[i] + dArray2[i] * dArray2[i];
        }
        return dArray3;
    }

    static void testLeastSquares(double[][] dArray, double[] dArray2, double[] dArray3, LinResult linResult, String string) {
        if (linResult == null || linResult.x == null) {
            LinTest.failed(string + " null");
            System.exit(0);
            return;
        }
        if (dArray[0].length != linResult.x.length) {
            LinTest.failed(string + " improper dimension: #cols(A)=" + dArray[0].length + " x.len=" + linResult.x.length);
            System.exit(0);
            return;
        }
        LinToolImpl linToolImpl = new LinToolImpl();
        double[] dArray4 = linToolImpl.matrixVectorMult(dArray, linResult.x);
        LinUtil.print("c", dArray4);
        double d = 0.0;
        for (int i = 0; i < dArray2.length; ++i) {
            d += (dArray4[i] - dArray2[i]) * (dArray4[i] - dArray2[i]);
        }
        System.out.println("Least-squares: mse=" + d);
    }

    public static void testComplex(ComplexNumber complexNumber) {
        System.out.println("Testing complex-number implementation:");
        complexImpl = complexNumber;
        ComplexNumber complexNumber2 = LinTest.make(3.0, 5.0);
        if (complexNumber2 == null) {
            LinTest.failed("No-parameter constructor needed");
            System.exit(0);
        }
        LinTest.passed("Test 1: no-parameter constructor");
        complexNumber2 = LinTest.make(3.0, -4.0);
        double d = complexNumber2.magnitude();
        if (Math.abs(d - 5.0) > EPSILON) {
            LinTest.failed("Test 2: magnitude");
            System.exit(0);
        }
        if (Math.abs((d = (complexNumber2 = LinTest.make(0.0, -4.0)).magnitude()) - 4.0) > EPSILON) {
            LinTest.failed("Test 2: magnitude");
            System.exit(0);
        }
        LinTest.passed("Test 2: magnitude");
        int n = 8;
        double d2 = Math.PI * 2 / (double)n;
        d = 2.0;
        for (double d3 = 0.0; d3 <= Math.PI * 2; d3 += d2) {
            double d4;
            double d5 = d * Math.cos(d3);
            complexNumber2 = LinTest.make(d5, d4 = d * Math.sin(d3));
            double d6 = complexNumber2.angle();
            if (!(Math.abs(d3 - d6) > EPSILON)) continue;
            LinTest.failed("Test 3: angle");
            System.exit(0);
        }
        LinTest.passed("Test 3: angle");
        ComplexNumber complexNumber3 = LinTest.make(1.0, 2.0);
        ComplexNumber complexNumber4 = LinTest.make(3.0, -4.0);
        ComplexNumber complexNumber5 = complexNumber3.add(complexNumber4);
        if (Math.abs(complexNumber5.re - 4.0) > EPSILON || Math.abs(complexNumber5.im + 2.0) > EPSILON) {
            LinTest.failed("Test 4: addition");
            System.exit(0);
        }
        complexNumber3 = LinTest.make(-3.0, 0.0);
        complexNumber4 = LinTest.make(3.0, -4.0);
        complexNumber5 = complexNumber3.add(complexNumber4);
        if (Math.abs(complexNumber5.re) > EPSILON || Math.abs(complexNumber5.im + 4.0) > EPSILON) {
            LinTest.failed("Test 4: addition");
            System.exit(0);
        }
        LinTest.passed("Test 4: addition");
        complexNumber3 = LinTest.make(1.0, 2.0);
        complexNumber4 = LinTest.make(3.0, -4.0);
        complexNumber5 = complexNumber3.sub(complexNumber4);
        if (Math.abs(complexNumber5.re + 2.0) > EPSILON || Math.abs(complexNumber5.im - 6.0) > EPSILON) {
            LinTest.failed("Test 5: subtraction");
            System.exit(0);
        }
        complexNumber3 = LinTest.make(-3.0, 0.0);
        complexNumber4 = LinTest.make(3.0, -4.0);
        complexNumber5 = complexNumber3.sub(complexNumber4);
        if (Math.abs(complexNumber5.re + 6.0) > EPSILON || Math.abs(complexNumber5.im - 4.0) > EPSILON) {
            LinTest.failed("Test 5: subtraction");
            System.exit(0);
        }
        LinTest.passed("Test 5: subtraction");
        complexNumber3 = LinTest.make(1.0, 2.0);
        complexNumber4 = LinTest.make(3.0, -4.0);
        complexNumber5 = complexNumber3.mult(complexNumber4);
        if (Math.abs(complexNumber5.re - 11.0) > EPSILON || Math.abs(complexNumber5.im - 2.0) > EPSILON) {
            LinTest.failed("Test 6: multiplication");
            System.exit(0);
        }
        complexNumber3 = LinTest.make(-3.0, 0.0);
        complexNumber4 = LinTest.make(3.0, -4.0);
        complexNumber5 = complexNumber3.mult(complexNumber4);
        if (Math.abs(complexNumber5.re + 9.0) > EPSILON || Math.abs(complexNumber5.im - 12.0) > EPSILON) {
            LinTest.failed("Test 6: multiplication");
            System.exit(0);
        }
        LinTest.passed("Test 6: multiplication");
        complexNumber3 = LinTest.make(3.0, -4.0);
        complexNumber5 = complexNumber3.mult(-2.0);
        if (Math.abs(complexNumber5.re + 6.0) > EPSILON || Math.abs(complexNumber5.im - 8.0) > EPSILON) {
            LinTest.failed("Test 7: scalar multiplication");
            System.exit(0);
        }
        complexNumber3 = LinTest.make(-3.0, 0.0);
        complexNumber5 = complexNumber3.mult(1.0);
        if (Math.abs(complexNumber5.re + 3.0) > EPSILON || Math.abs(complexNumber5.im) > EPSILON) {
            LinTest.failed("Test 7: scalar multiplication");
            System.exit(0);
        }
        LinTest.passed("Test 7: scalar multiplication");
        complexNumber3 = LinTest.make(3.0, -4.0);
        complexNumber5 = complexNumber3.conjugate();
        if (Math.abs(complexNumber5.re - 3.0) > EPSILON || Math.abs(complexNumber5.im - 4.0) > EPSILON) {
            LinTest.failed("Test 8: conjugate");
            System.exit(0);
        }
        complexNumber3 = LinTest.make(-3.0, 0.0);
        complexNumber5 = complexNumber3.conjugate();
        if (Math.abs(complexNumber5.re + 3.0) > EPSILON || Math.abs(complexNumber5.im) > EPSILON) {
            LinTest.failed("Test 8: conjugate");
            System.exit(0);
        }
        LinTest.passed("Test 8: conjugate");
        complexNumber3 = LinTest.make(3.0, -4.0);
        complexNumber4 = complexNumber3.pow(5);
        ComplexImpl complexImpl = new ComplexImpl(3.0, -4.0);
        ComplexImpl complexImpl2 = (ComplexImpl)complexImpl.pow(5);
        if (Math.abs(complexNumber4.re - complexImpl2.re) > EPSILON || Math.abs(complexNumber4.im - complexImpl2.im) > EPSILON) {
            LinTest.failed("Test 9: pow");
            System.exit(0);
        }
        LinTest.passed("Test 9: pow");
        LinTest.passed("all tests: complex-number implementation:");
        System.out.println(jokes[0]);
    }

    static ComplexNumber make(double d, double d2) {
        try {
            Class<?> clazz = complexImpl.getClass();
            ComplexNumber complexNumber = (ComplexNumber)clazz.newInstance();
            complexNumber.re = d;
            complexNumber.im = d2;
            return complexNumber;
        }
        catch (Exception exception) {
            System.out.println(exception);
            return null;
        }
    }

    public static void testComplexVectors(LinTool linTool) {
        System.out.println("Testing add, dotProduct, norm, scalarProduct for complex vectors");
        LinToolImpl linToolImpl = new LinToolImpl();
        ComplexNumber[] complexNumberArray = new ComplexNumber[]{new ComplexImpl(1.0, 2.0), new ComplexImpl(1.0, 3.0), new ComplexImpl(-1.0, -2.0)};
        ComplexNumber[] complexNumberArray2 = new ComplexNumber[]{new ComplexImpl(1.0, 2.0), new ComplexImpl(-1.0, -3.0), new ComplexImpl(-1.0, 2.0)};
        ComplexNumber[] complexNumberArray3 = new ComplexNumber[]{new ComplexImpl(2.0, 4.0), new ComplexImpl(0.0, 0.0), new ComplexImpl(-2.0, 0.0)};
        ComplexNumber[] complexNumberArray4 = new ComplexNumber[]{new ComplexImpl(0.0, 0.0), new ComplexImpl(0.0, 0.0), new ComplexImpl(0.0, 0.0)};
        ComplexNumber[] complexNumberArray5 = new ComplexNumber[]{new ComplexImpl(1.0, 1.0), new ComplexImpl(1.0, 1.0), new ComplexImpl(1.0, 1.0)};
        ComplexNumber[] complexNumberArray6 = new ComplexNumber[]{new ComplexImpl(1.0, 0.0), new ComplexImpl(1.0, 0.0), new ComplexImpl(1.0, 0.0)};
        ComplexNumber[] complexNumberArray7 = linTool.add(complexNumberArray, complexNumberArray2);
        if (!linToolImpl.approxEquals(complexNumberArray3, complexNumberArray7, EPSILON)) {
            LinTest.failed("Test 1: add");
            System.exit(0);
        }
        LinTest.passed("Test 1: add");
        complexNumberArray7 = linTool.add(complexNumberArray, complexNumberArray4);
        if (!linToolImpl.approxEquals(complexNumberArray7, complexNumberArray, EPSILON)) {
            LinTest.failed("Test 2: add");
            System.exit(0);
        }
        LinTest.passed("Test 2: add");
        ComplexNumber complexNumber = linTool.dotProduct(complexNumberArray, complexNumberArray2);
        ComplexNumber complexNumber2 = ComplexNumber.makeComplexNumber(-8.0, 4.0);
        if (!linToolImpl.approxEquals(complexNumber, complexNumber2, EPSILON)) {
            LinTest.failed("Test 3: dot product");
            System.exit(0);
        }
        LinTest.passed("Test 3: dot product");
        complexNumber = linTool.dotProduct(complexNumberArray, complexNumberArray4);
        complexNumber2 = ComplexNumber.makeComplexNumber(0.0, 0.0);
        if (!linToolImpl.approxEquals(complexNumber, complexNumber2, EPSILON)) {
            LinTest.failed("Test 4: dot product");
            System.exit(0);
        }
        LinTest.passed("Test 4: dot product");
        complexNumber = linTool.dotProduct(complexNumberArray, complexNumberArray6);
        complexNumber2 = ComplexNumber.makeComplexNumber(1.0, 3.0);
        if (!linToolImpl.approxEquals(complexNumber, complexNumber2, EPSILON)) {
            LinTest.failed("Test 5: dot product");
            System.exit(0);
        }
        LinTest.passed("Test 5: dot product");
        double d = linTool.norm(complexNumberArray6);
        double d2 = Math.sqrt(3.0);
        if (Math.abs(d - d2) > EPSILON) {
            LinTest.failed("Test 6: norm");
            System.exit(0);
        }
        LinTest.passed("Test 6: norm");
        d = linTool.norm(complexNumberArray5);
        d2 = Math.sqrt(6.0);
        if (Math.abs(d - d2) > EPSILON) {
            LinTest.failed("Test 7: norm");
            System.out.println("norm=" + d + " norm2=" + d2);
            System.exit(0);
        }
        LinTest.passed("Test 7: norm");
        d = linTool.norm(complexNumberArray);
        d2 = Math.sqrt(20.0);
        if (Math.abs(d - d2) > EPSILON) {
            LinTest.failed("Test 8: norm");
            System.out.println("norm=" + d + " norm2=" + d2);
            System.exit(0);
        }
        LinTest.passed("Test 8: norm");
        complexNumber2 = ComplexNumber.makeComplexNumber(1.0, 0.0);
        complexNumberArray7 = linTool.scalarProduct(complexNumber2, complexNumberArray5);
        ComplexNumber[] complexNumberArray8 = new ComplexNumber[]{new ComplexImpl(1.0, 1.0), new ComplexImpl(1.0, 1.0), new ComplexImpl(1.0, 1.0)};
        if (!linToolImpl.approxEquals(complexNumberArray7, complexNumberArray8, EPSILON)) {
            LinTest.failed("Test 9: scalar product");
            System.exit(0);
        }
        LinTest.passed("Test 9: scalar product");
        complexNumber2 = ComplexNumber.makeComplexNumber(1.0, 1.0);
        complexNumberArray7 = linTool.scalarProduct(complexNumber2, complexNumberArray5);
        complexNumberArray8[0] = new ComplexImpl(0.0, 2.0);
        complexNumberArray8[1] = new ComplexImpl(0.0, 2.0);
        complexNumberArray8[2] = new ComplexImpl(0.0, 2.0);
        if (!linToolImpl.approxEquals(complexNumberArray7, complexNumberArray8, EPSILON)) {
            LinTest.failed("Test 10: scalar product");
            System.exit(0);
        }
        LinTest.passed("Test 10: scalar product");
        complexNumber2 = ComplexNumber.makeComplexNumber(1.0, 2.0);
        complexNumberArray7 = linTool.scalarProduct(complexNumber2, complexNumberArray);
        complexNumberArray8[0] = new ComplexImpl(-3.0, 4.0);
        complexNumberArray8[1] = new ComplexImpl(-5.0, 5.0);
        complexNumberArray8[2] = new ComplexImpl(3.0, -4.0);
        if (!linToolImpl.approxEquals(complexNumberArray7, complexNumberArray8, EPSILON)) {
            LinTest.failed("Test 11: scalar product");
            System.exit(0);
        }
        LinTest.passed("Test 11: scalar product");
        LinTest.passed("all tests for add, dotProduct, norm, scalarProduct for complex vectors");
        System.out.println(jokes[3]);
    }

    public static void testComplexMatrices(LinTool linTool) {
        System.out.println("Testing add, scalarProduct, mult, matrix-vector mult, hermitian-tranpose for complex matrices");
        LinToolImpl linToolImpl = new LinToolImpl();
        ComplexNumber[][] complexNumberArray = new ComplexNumber[3][3];
        complexNumberArray[0][0] = new ComplexImpl(1.0, 2.0);
        complexNumberArray[1][0] = new ComplexImpl(1.0, 3.0);
        complexNumberArray[2][0] = new ComplexImpl(-1.0, -2.0);
        complexNumberArray[0][1] = new ComplexImpl(1.0, 0.0);
        complexNumberArray[1][1] = new ComplexImpl(1.0, 0.0);
        complexNumberArray[2][1] = new ComplexImpl(1.0, 0.0);
        complexNumberArray[0][2] = new ComplexImpl(0.0, 0.0);
        complexNumberArray[1][2] = new ComplexImpl(0.0, 0.0);
        complexNumberArray[2][2] = new ComplexImpl(0.0, 0.0);
        ComplexNumber[][] complexNumberArray2 = new ComplexNumber[3][3];
        complexNumberArray2[0][0] = new ComplexImpl(1.0, 2.0);
        complexNumberArray2[1][0] = new ComplexImpl(1.0, 3.0);
        complexNumberArray2[2][0] = new ComplexImpl(-1.0, -2.0);
        complexNumberArray2[0][1] = new ComplexImpl(1.0, 0.0);
        complexNumberArray2[1][1] = new ComplexImpl(1.0, 0.0);
        complexNumberArray2[2][1] = new ComplexImpl(1.0, 0.0);
        complexNumberArray2[0][2] = new ComplexImpl(0.0, 0.0);
        complexNumberArray2[1][2] = new ComplexImpl(0.0, 0.0);
        complexNumberArray2[2][2] = new ComplexImpl(0.0, 0.0);
        ComplexNumber[][] complexNumberArray3 = new ComplexNumber[3][3];
        complexNumberArray3[0][0] = new ComplexImpl(2.0, 4.0);
        complexNumberArray3[1][0] = new ComplexImpl(2.0, 6.0);
        complexNumberArray3[2][0] = new ComplexImpl(-2.0, -4.0);
        complexNumberArray3[0][1] = new ComplexImpl(2.0, 0.0);
        complexNumberArray3[1][1] = new ComplexImpl(2.0, 0.0);
        complexNumberArray3[2][1] = new ComplexImpl(2.0, 0.0);
        complexNumberArray3[0][2] = new ComplexImpl(0.0, 0.0);
        complexNumberArray3[1][2] = new ComplexImpl(0.0, 0.0);
        complexNumberArray3[2][2] = new ComplexImpl(0.0, 0.0);
        ComplexNumber[][] complexNumberArray4 = linTool.add(complexNumberArray, complexNumberArray2);
        if (!linToolImpl.approxEquals(complexNumberArray3, complexNumberArray4, EPSILON)) {
            LinTest.failed("Test 1: add");
            System.exit(0);
        }
        LinTest.passed("Test 1: add");
        complexNumberArray2[0][0] = new ComplexImpl(0.0, 0.0);
        complexNumberArray2[1][0] = new ComplexImpl(0.0, 0.0);
        complexNumberArray2[2][0] = new ComplexImpl(0.0, 0.0);
        complexNumberArray2[0][1] = new ComplexImpl(0.0, 0.0);
        complexNumberArray2[1][1] = new ComplexImpl(0.0, 0.0);
        complexNumberArray2[2][1] = new ComplexImpl(0.0, 0.0);
        complexNumberArray2[0][2] = new ComplexImpl(0.0, 0.0);
        complexNumberArray2[1][2] = new ComplexImpl(0.0, 0.0);
        complexNumberArray2[2][2] = new ComplexImpl(0.0, 0.0);
        complexNumberArray4 = linTool.mult(complexNumberArray, complexNumberArray2);
        if (!linToolImpl.approxEquals(complexNumberArray2, complexNumberArray4, EPSILON)) {
            LinTest.failed("Test 2: mult");
            System.exit(0);
        }
        LinTest.passed("Test 2: mult");
        complexNumberArray2[0][0] = new ComplexImpl(1.0, 0.0);
        complexNumberArray2[1][0] = new ComplexImpl(0.0, 0.0);
        complexNumberArray2[2][0] = new ComplexImpl(0.0, 0.0);
        complexNumberArray2[0][1] = new ComplexImpl(0.0, 0.0);
        complexNumberArray2[1][1] = new ComplexImpl(1.0, 0.0);
        complexNumberArray2[2][1] = new ComplexImpl(0.0, 0.0);
        complexNumberArray2[0][2] = new ComplexImpl(0.0, 0.0);
        complexNumberArray2[1][2] = new ComplexImpl(0.0, 0.0);
        complexNumberArray2[2][2] = new ComplexImpl(1.0, 0.0);
        complexNumberArray4 = linTool.mult(complexNumberArray, complexNumberArray2);
        if (!linToolImpl.approxEquals(complexNumberArray, complexNumberArray4, EPSILON)) {
            LinTest.failed("Test 3: mult");
            System.exit(0);
        }
        LinTest.passed("Test 3: mult");
        complexNumberArray2[0][0] = new ComplexImpl(1.0, 0.0);
        complexNumberArray2[1][0] = new ComplexImpl(0.0, 1.0);
        complexNumberArray2[2][0] = new ComplexImpl(1.0, 1.0);
        complexNumberArray2[0][1] = new ComplexImpl(0.0, 0.0);
        complexNumberArray2[1][1] = new ComplexImpl(1.0, 2.0);
        complexNumberArray2[2][1] = new ComplexImpl(1.0, 2.0);
        complexNumberArray2[0][2] = new ComplexImpl(0.0, 0.0);
        complexNumberArray2[1][2] = new ComplexImpl(0.0, 0.0);
        complexNumberArray2[2][2] = new ComplexImpl(0.0, 0.0);
        complexNumberArray3[0][0] = new ComplexImpl(1.0, 3.0);
        complexNumberArray3[1][0] = new ComplexImpl(1.0, 4.0);
        complexNumberArray3[2][0] = new ComplexImpl(-1.0, -1.0);
        complexNumberArray3[0][1] = new ComplexImpl(1.0, 2.0);
        complexNumberArray3[1][1] = new ComplexImpl(1.0, 2.0);
        complexNumberArray3[2][1] = new ComplexImpl(1.0, 2.0);
        complexNumberArray3[0][2] = new ComplexImpl(0.0, 0.0);
        complexNumberArray3[1][2] = new ComplexImpl(0.0, 0.0);
        complexNumberArray3[2][2] = new ComplexImpl(0.0, 0.0);
        complexNumberArray4 = linTool.mult(complexNumberArray, complexNumberArray2);
        if (!linToolImpl.approxEquals(complexNumberArray3, complexNumberArray4, EPSILON)) {
            LinTest.failed("Test 4: mult");
            System.exit(0);
        }
        LinTest.passed("Test 4: mult");
        ComplexNumber[] complexNumberArray5 = new ComplexNumber[]{new ComplexImpl(1.0, 0.0), new ComplexImpl(0.0, 1.0), new ComplexImpl(1.0, 1.0)};
        ComplexNumber[] complexNumberArray6 = new ComplexNumber[]{new ComplexImpl(1.0, 3.0), new ComplexImpl(1.0, 4.0), new ComplexImpl(-1.0, -1.0)};
        ComplexNumber[] complexNumberArray7 = linTool.matrixVectorMult(complexNumberArray, complexNumberArray5);
        if (!linToolImpl.approxEquals(complexNumberArray6, complexNumberArray7, EPSILON)) {
            LinTest.failed("Test 5: matrix-vector mult");
            System.exit(0);
        }
        LinTest.passed("Test 5: matrix-vector mult");
        complexNumberArray5[0] = new ComplexImpl(0.0, 0.0);
        complexNumberArray5[1] = new ComplexImpl(1.0, 2.0);
        complexNumberArray5[2] = new ComplexImpl(1.0, 2.0);
        complexNumberArray6[0] = new ComplexImpl(1.0, 2.0);
        complexNumberArray6[1] = new ComplexImpl(1.0, 2.0);
        complexNumberArray6[2] = new ComplexImpl(1.0, 2.0);
        complexNumberArray7 = linTool.matrixVectorMult(complexNumberArray, complexNumberArray5);
        if (!linToolImpl.approxEquals(complexNumberArray6, complexNumberArray7, EPSILON)) {
            LinTest.failed("Test 6: matrix-vector mult");
            System.exit(0);
        }
        LinTest.passed("Test 6: matrix-vector mult");
        complexNumberArray5[0] = new ComplexImpl(0.0, 0.0);
        complexNumberArray5[1] = new ComplexImpl(0.0, 0.0);
        complexNumberArray5[2] = new ComplexImpl(0.0, 0.0);
        complexNumberArray7 = linTool.matrixVectorMult(complexNumberArray, complexNumberArray5);
        if (!linToolImpl.approxEquals(complexNumberArray5, complexNumberArray7, EPSILON)) {
            LinTest.failed("Test 7: matrix-vector mult");
            System.exit(0);
        }
        LinTest.passed("Test 7: matrix-vector mult");
        complexNumberArray4 = linTool.hermitianTranspose(complexNumberArray);
        complexNumberArray3[0][0] = new ComplexImpl(1.0, -2.0);
        complexNumberArray3[1][0] = new ComplexImpl(1.0, 0.0);
        complexNumberArray3[2][0] = new ComplexImpl(0.0, 0.0);
        complexNumberArray3[0][1] = new ComplexImpl(1.0, -3.0);
        complexNumberArray3[1][1] = new ComplexImpl(1.0, 0.0);
        complexNumberArray3[2][1] = new ComplexImpl(0.0, 0.0);
        complexNumberArray3[0][2] = new ComplexImpl(-1.0, 2.0);
        complexNumberArray3[1][2] = new ComplexImpl(1.0, 0.0);
        complexNumberArray3[2][2] = new ComplexImpl(0.0, 0.0);
        if (!linToolImpl.approxEquals(complexNumberArray3, complexNumberArray4, EPSILON)) {
            LinTest.failed("Test 8: hermitian tranpose");
            System.exit(0);
        }
        LinTest.passed("Test 8: hermitian tranpose");
        LinTest.passed("all tests for add, scalarProduct, mult, matrix-vector mult, hermitian-tranpose for complex matrices");
    }

    public static void testFourierMatrices(LinTool linTool) {
        System.out.println("Testing DFT and FFT");
        ComplexNumber[][] complexNumberArray = linTool.makeDFTMatrix(8);
        if (!LinTest.checkOrthonormal(complexNumberArray)) {
            LinTest.failed("Test 1: 8x8 dft orthonormality test");
            System.exit(0);
        }
        LinTest.passed("Test 1: 8x8 dft orthonormality test");
        int n = 2;
        complexNumberArray = linTool.makeDFTMatrix(n);
        ComplexNumber[][] complexNumberArray2 = LinUtil.makeDFTMatrix(n);
        if (!LinTest.checkEqual(complexNumberArray, complexNumberArray2, EPSILON)) {
            LinTest.failed("Test 2: entries in 2x2 DFT matrix");
            System.exit(0);
        }
        LinTest.passed("Test 2: entries in 2x2 DFT matrix");
        n = 4;
        complexNumberArray = linTool.makeDFTMatrix(n);
        complexNumberArray2 = LinUtil.makeDFTMatrix(n);
        if (!LinTest.checkEqual(complexNumberArray, complexNumberArray2, EPSILON)) {
            LinTest.failed("Test 3: entries in 4x4 DFT matrix");
            System.exit(0);
        }
        LinTest.passed("Test 3: entries in 4x4 DFT matrix");
        n = 8;
        complexNumberArray = linTool.makeDFTMatrix(n);
        complexNumberArray2 = LinUtil.makeDFTMatrix(n);
        if (!LinTest.checkEqual(complexNumberArray, complexNumberArray2, EPSILON)) {
            LinTest.failed("Test 4: entries in 8x8 DFT matrix");
            System.exit(0);
        }
        LinTest.passed("Test 4: entries in 8x8 DFT matrix");
        n = 2;
        ComplexNumber[][] complexNumberArray3 = linTool.makeInverseDFTMatrix(n);
        ComplexNumber[][] complexNumberArray4 = LinUtil.makeInverseDFTMatrix(n);
        if (!LinTest.checkEqual(complexNumberArray3, complexNumberArray4, EPSILON)) {
            LinTest.failed("Test 5: entries in 2x2 inverse DFT matrix");
            System.exit(0);
        }
        LinTest.passed("Test 5: entries in 2x2 inverse DFT matrix");
        n = 4;
        complexNumberArray3 = linTool.makeInverseDFTMatrix(n);
        complexNumberArray4 = LinUtil.makeInverseDFTMatrix(n);
        if (!LinTest.checkEqual(complexNumberArray3, complexNumberArray4, EPSILON)) {
            LinTest.failed("Test 6: entries in inverse 4x4 DFT matrix");
            System.exit(0);
        }
        LinTest.passed("Test 6: entries in 4x4 inverse DFT matrix");
        n = 8;
        complexNumberArray3 = linTool.makeInverseDFTMatrix(n);
        complexNumberArray4 = LinUtil.makeInverseDFTMatrix(n);
        if (!LinTest.checkEqual(complexNumberArray3, complexNumberArray4, EPSILON)) {
            LinTest.failed("Test 7: entries in 8x8 inverse DFT matrix");
            System.exit(0);
        }
        LinTest.passed("Test 7: entries in 8x8 inverse DFT matrix");
        n = 8;
        complexNumberArray = linTool.makeDFTMatrix(n);
        complexNumberArray3 = linTool.makeInverseDFTMatrix(n);
        LinToolImpl linToolImpl = new LinToolImpl();
        ComplexNumber[][] complexNumberArray5 = ((LinTool)linToolImpl).mult(complexNumberArray3, complexNumberArray);
        ComplexImpl complexImpl = new ComplexImpl(n, 0.0);
        ComplexImpl complexImpl2 = new ComplexImpl(0.0, 0.0);
        for (int i = 0; i < complexNumberArray5.length; ++i) {
            for (int j = 0; j < complexNumberArray5[0].length; ++j) {
                if (i == j) {
                    if (LinTest.checkEqual(complexNumberArray5[i][j], complexImpl, EPSILON)) continue;
                    LinTest.failed("Test 8: product of inverse-dft with dft");
                    System.exit(0);
                    continue;
                }
                if (LinTest.checkEqual(complexNumberArray5[i][j], complexImpl2, EPSILON)) continue;
                LinTest.failed("Test 8: product of inverse-dft with dft");
                System.exit(0);
            }
        }
        LinTest.passed("Test 8: product of inverse-dft with dft");
        ComplexNumber[] complexNumberArray6 = LinTest.makeComplexArray(8);
        complexNumberArray6[0] = new ComplexImpl(1.0, 0.0);
        ComplexNumber[] complexNumberArray7 = linTool.computeInverseDFT(complexNumberArray6);
        ComplexNumber[] complexNumberArray8 = LinUtil.computeInverseDFT(complexNumberArray6);
        if (!LinTest.checkEqual(complexNumberArray7, complexNumberArray8, EPSILON2)) {
            LinTest.failed("Test 9: compute-inverse-DFT");
            System.exit(0);
        }
        LinTest.passed("Test 9: compute-inverse-DFT");
        ComplexNumber[] complexNumberArray9 = LinTest.makeComplexArray(8);
        complexNumberArray9[0] = new ComplexImpl(0.0, 0.0);
        complexNumberArray9[1] = new ComplexImpl(1.0, 0.0);
        complexNumberArray9[2] = new ComplexImpl(1.0, 0.0);
        complexNumberArray9[3] = new ComplexImpl(2.0, 2.0);
        complexNumberArray7 = linTool.computeInverseDFT(complexNumberArray9);
        ComplexNumber[] complexNumberArray10 = LinUtil.computeInverseDFT(complexNumberArray9);
        if (!LinTest.checkEqual(complexNumberArray7, complexNumberArray10, EPSILON2)) {
            LinTest.failed("Test 10: compute-inverse-DFT");
            System.exit(0);
        }
        LinTest.passed("Test 10: compute-inverse-DFT");
        ComplexNumber[] complexNumberArray11 = linTool.computeDFT(LinTest.getReal(complexNumberArray8));
        if (!LinTest.checkEqual(complexNumberArray6, complexNumberArray11, EPSILON2)) {
            LinTest.failed("Test 11: compute-DFT");
            System.exit(0);
        }
        LinTest.passed("Test 11: compute-DFT");
        double[] dArray = new double[8];
        dArray[0] = 8.0;
        dArray[1] = 4.0;
        dArray[2] = 2.0;
        dArray[3] = 1.0;
        complexNumberArray11 = linTool.computeDFT(dArray);
        ComplexNumber[] complexNumberArray12 = LinUtil.computeDFT(dArray);
        if (!LinTest.checkEqual(complexNumberArray11, complexNumberArray12, EPSILON2)) {
            LinTest.failed("Test 12: compute-DFT");
            System.exit(0);
        }
        LinTest.passed("Test 12: compute-DFT");
        ComplexNumber[] complexNumberArray13 = linTool.computeFFT(dArray);
        if (!LinTest.checkEqual(complexNumberArray13, complexNumberArray12, EPSILON2)) {
            LinTest.failed("Test 13: compute-FFT");
            System.exit(0);
        }
        LinTest.passed("Test 13: compute-FFT");
        ComplexNumber[] complexNumberArray14 = linTool.computeInverseFFT(complexNumberArray9);
        if (!LinTest.checkEqual(complexNumberArray14, complexNumberArray10, EPSILON2)) {
            LinTest.failed("Test 14: compute-inverse-FFT");
            System.exit(0);
        }
        LinTest.passed("Test 14: compute-inverse-FFT");
        LinTest.passed("all tests for DFT and FFT");
    }

    static double[] getReal(ComplexNumber[] complexNumberArray) {
        if (complexNumberArray == null) {
            return null;
        }
        double[] dArray = new double[complexNumberArray.length];
        for (int i = 0; i < complexNumberArray.length; ++i) {
            dArray[i] = complexNumberArray[i].re;
        }
        return dArray;
    }

    static ComplexNumber[] makeComplexArray(int n) {
        ComplexNumber[] complexNumberArray = new ComplexNumber[n];
        for (int i = 0; i < n; ++i) {
            complexNumberArray[i] = new ComplexImpl(0.0, 0.0);
        }
        return complexNumberArray;
    }

    static boolean checkOrthonormal(ComplexNumber[][] complexNumberArray) {
        int n;
        if (complexNumberArray == null) {
            return false;
        }
        for (n = 0; n < complexNumberArray[0].length; ++n) {
            ComplexNumber complexNumber = new ComplexImpl(0.0, 0.0);
            for (int i = 0; i < complexNumberArray.length; ++i) {
                ComplexNumber complexNumber2 = complexNumberArray[i][n].conjugate();
                complexNumber = ((ComplexNumber)complexNumber).add(complexNumberArray[i][n].mult(complexNumber2));
            }
            complexNumber = ((ComplexNumber)complexNumber).mult(1.0 / (double)complexNumberArray.length);
            if (!(Math.abs(complexNumber.re - 1.0) > EPSILON) && !(Math.abs(complexNumber.im) > EPSILON)) continue;
            System.out.println("Ortho-test: col*col!=1, j=" + n + " sum=" + complexNumber);
            return false;
        }
        for (n = 0; n < complexNumberArray[0].length - 1; ++n) {
            for (int i = n + 1; i < complexNumberArray[0].length; ++i) {
                ComplexNumber complexNumber = new ComplexImpl(0.0, 0.0);
                for (int j = 0; j < complexNumberArray.length; ++j) {
                    ComplexNumber complexNumber3 = complexNumberArray[j][i].conjugate();
                    complexNumber = ((ComplexNumber)complexNumber).add(complexNumberArray[j][n].mult(complexNumber3));
                }
                if (!(Math.abs(complexNumber.re) > EPSILON2) && !(Math.abs(complexNumber.im) > EPSILON2)) continue;
                System.out.println("Ortho: colj*colk!=0, j=" + n + " k=" + i + " sum=" + complexNumber);
                return false;
            }
        }
        return true;
    }

    static boolean checkEqual(ComplexNumber[][] complexNumberArray, ComplexNumber[][] complexNumberArray2, double d) {
        if (complexNumberArray == null || complexNumberArray2 == null) {
            return false;
        }
        if (complexNumberArray.length != complexNumberArray2.length || complexNumberArray[0].length != complexNumberArray2[0].length) {
            return false;
        }
        for (int i = 0; i < complexNumberArray.length; ++i) {
            for (int j = 0; j < complexNumberArray[0].length; ++j) {
                if (!(Math.abs(complexNumberArray[i][j].re - complexNumberArray2[i][j].re) > EPSILON) && !(Math.abs(complexNumberArray[i][j].im - complexNumberArray2[i][j].im) > EPSILON)) continue;
                System.out.println("Mismatch in matrix comp: i=" + i + " j=" + j + " A[i][j]=" + complexNumberArray[i][j] + "  B[i][j]=" + complexNumberArray2[i][j]);
                return false;
            }
        }
        return true;
    }

    static boolean checkEqual(ComplexNumber[] complexNumberArray, ComplexNumber[] complexNumberArray2, double d) {
        if (complexNumberArray == null || complexNumberArray2 == null) {
            return false;
        }
        if (complexNumberArray.length != complexNumberArray2.length) {
            return false;
        }
        for (int i = 0; i < complexNumberArray.length; ++i) {
            if (LinTest.checkEqual(complexNumberArray[i], complexNumberArray2[i], d)) continue;
            return false;
        }
        return true;
    }

    static boolean checkEqual(ComplexNumber complexNumber, ComplexNumber complexNumber2, double d) {
        if (Math.abs(complexNumber.re - complexNumber2.re) > EPSILON2) {
            return false;
        }
        return !(Math.abs(complexNumber.im - complexNumber2.im) > EPSILON2);
    }
}

