/*
 * Decompiled with CFR 0.152.
 */
package edu.gwu.lintool;

import edu.gwu.lintool.ComplexImpl;
import edu.gwu.lintool.ComplexNumber;
import edu.gwu.lintool.LinResult;
import edu.gwu.lintool.LinToolImpl;
import java.util.HashSet;
import java.util.Iterator;

public class LinUtil {
    static final int defWidth = 8;
    static final int defDec = 3;
    static final long m = Integer.MAX_VALUE;
    static final long a = 48271L;
    static final long q = 44488L;
    static final long r = 3399L;
    static long r_seed = 12345678L;

    public static void set_seed(long l) {
        r_seed = l;
    }

    public static double uniform() {
        long l = r_seed / 44488L;
        long l2 = r_seed - 44488L * l;
        long l3 = 48271L * l2 - 3399L * l;
        r_seed = l3 > 0L ? l3 : l3 + Integer.MAX_VALUE;
        return (double)r_seed / 2.147483647E9;
    }

    public static double uniform(double d, double d2) {
        if (d2 > d) {
            return d + (d2 - d) * LinUtil.uniform();
        }
        System.out.println("ERR in uniform(double,double):a=" + d + "b=" + d2);
        return 0.0;
    }

    public static long uniform(long l, long l2) {
        if (l2 > l) {
            double d = LinUtil.uniform();
            long l3 = l + (long)Math.floor((double)(l2 - l + 1L) * d);
            return l3;
        }
        if (l == l2) {
            return l;
        }
        System.out.println("ERR: in uniform(long,long):a=" + l + "b=" + l2);
        return 0L;
    }

    public static int uniform(int n, int n2) {
        return (int)LinUtil.uniform((long)n, (long)n2);
    }

    public static double[][] randomIntMatrix(int n, int n2, int n3, int n4) {
        if (n < 1 || n2 < 1 || n3 > n4) {
            System.out.println("ERROR: LinTool.randomIntMatrix: illegal # rows or cols, or illegal range");
            System.exit(0);
        }
        double[][] dArray = new double[n][n2];
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[0].length; ++j) {
                dArray[i][j] = LinUtil.uniform(n3, n4);
            }
        }
        return dArray;
    }

    public static double[][] randomSymmetricIntMatrix(int n, int n2, int n3, int n4) {
        if (n < 1 || n2 < 1 || n3 > n4) {
            System.out.println("ERROR: LinTool.randomIntMatrix: illegal # rows or cols, or illegal range");
            System.exit(0);
        }
        double[][] dArray = new double[n][n2];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i][i] = LinUtil.uniform(n3, n4);
            for (int j = i + 1; j < dArray[0].length; ++j) {
                dArray[i][j] = LinUtil.uniform(n3, n4);
                dArray[j][i] = dArray[i][j];
            }
        }
        return dArray;
    }

    public static double[] randomIntVector(int n, int n2, int n3) {
        if (n < 1 || n2 > n3) {
            System.out.println("ERROR: LinTool.randomIntVector: illegal # rows or cols, or illegal range");
            System.exit(0);
        }
        double[] dArray = new double[n];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = LinUtil.uniform(n2, n3);
        }
        return dArray;
    }

    public static void print(String string, double[] dArray) {
        System.out.println(LinUtil.toString(string, dArray, 8, 3));
    }

    public static void print(String string, double[][] dArray) {
        System.out.println(LinUtil.toString(string, dArray, 8, 3));
    }

    public static void print(double[][] dArray) {
        System.out.println(LinUtil.toString("", dArray, 8, 3));
    }

    public static void print(double[][] dArray, int n, int n2) {
        System.out.println(LinUtil.toString("", dArray, n, n2));
    }

    public static void print(double[] dArray, int n, int n2) {
        System.out.println(LinUtil.toString("", dArray, n, n2));
    }

    public static void print(String string, double[][] dArray, int n, int n2) {
        System.out.println(LinUtil.toString(string, dArray, n, n2));
    }

    public static String toString(double[][] dArray) {
        return LinUtil.toString("", dArray, 8, 3);
    }

    public static String toString(double[] dArray) {
        return LinUtil.toString("", dArray, 8, 3);
    }

    public static String toString(String string, double[][] dArray, int n, int n2) {
        if (dArray == null) {
            return string + ": Matrix: null";
        }
        int n3 = dArray.length;
        int n4 = dArray[0].length;
        String string2 = string + ": Matrix, numRows=" + n3 + " numCols=" + n4 + ":\n";
        String string3 = " %" + n + "." + n2 + "f";
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                string2 = string2 + String.format(string3, dArray[i][j]);
            }
            string2 = string2 + "\n";
        }
        return string2;
    }

    public static String toString(String string, double[] dArray, int n, int n2) {
        if (dArray == null) {
            return string + ": vector: null";
        }
        String string2 = string + ": Vector, length=" + dArray.length + ": (";
        String string3 = " %" + n + "." + n2 + "f";
        for (int i = 0; i < dArray.length; ++i) {
            string2 = string2 + String.format(string3, dArray[i]);
        }
        string2 = string2 + ")\n";
        return string2;
    }

    public static void print(String string, boolean[] blArray) {
        if (blArray == null) {
            System.out.println("Boolean vector: null");
            return;
        }
        String string2 = "Boolean vec (len=" + blArray.length + "): ";
        for (int i = 0; i < blArray.length; ++i) {
            string2 = string2 + " " + blArray[i];
        }
        System.out.println(string2);
    }

    public static LinResult generateLinSystem(int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        if (n < 2 || n2 < 2 || n3 > Math.min(n, n2) || n3 < 1) {
            System.out.println("ERROR: LinUtil.generateLinSys: parameter error: numRows=" + n + " numCols=" + n2 + " numBasic=" + n3);
            return null;
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(0);
        if (n3 >= 2) {
            hashSet.add(n2 - 1);
        }
        while (hashSet.size() < n3) {
            int n10 = LinUtil.uniform(0, n2 - 1);
            if (hashSet.contains(n10)) continue;
            hashSet.add(n10);
        }
        double[] dArray = new double[n2];
        boolean[] blArray = new boolean[n2];
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            int n11 = (Integer)iterator.next();
            dArray[n11] = LinUtil.uniform(1, 9);
            blArray[n11] = true;
        }
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i] != 0.0) continue;
            dArray[i] = LinUtil.uniform(1, 3);
            dArray[i] = -dArray[i];
        }
        double[][] dArray2 = new double[n][n2];
        int[] nArray = new int[n2];
        for (n9 = 0; n9 < n2; ++n9) {
            nArray[n9] = -1;
        }
        n9 = 0;
        for (n8 = 0; n8 < dArray.length; ++n8) {
            if (!hashSet.contains(n8)) continue;
            n7 = LinUtil.uniform(1, 5);
            dArray2[n9][n8] = n7;
            nArray[n9] = n8;
            ++n9;
        }
        for (n8 = 0; n8 < n3; ++n8) {
            n7 = nArray[n8];
            for (n9 = n8 + 1; n9 < n3; ++n9) {
                if (dArray2[n9][n7] != 0.0) continue;
                dArray2[n9][n7] = LinUtil.uniform(0, 3);
                dArray2[n9][n7] = -dArray2[n8][n7];
            }
        }
        for (n8 = 0; n8 < n3; ++n8) {
            n7 = nArray[n8];
            n6 = n2;
            if (n8 + 1 < nArray.length) {
                n6 = nArray[n8 + 1];
            }
            for (n5 = n7 + 1; n5 < n6; ++n5) {
                dArray2[n8][n5] = -LinUtil.uniform(0, 3);
            }
            for (n5 = n8 + 1; n5 < n3; ++n5) {
                for (n4 = n7 + 1; n4 < n6; ++n4) {
                    double d = dArray2[n5][n7] / dArray2[n8][n7];
                    dArray2[n5][n4] = d * dArray2[n8][n4];
                }
            }
        }
        for (n8 = 0; n8 < n3; ++n8) {
        }
        for (n8 = n3; n8 < n; ++n8) {
            n7 = LinUtil.uniform(0, n3 - 1);
            n6 = LinUtil.uniform(0, n3 - 1);
            n5 = 2 * LinUtil.uniform(1, 2);
            n4 = -LinUtil.uniform(1, 3);
            for (int i = 0; i < n2; ++i) {
                dArray2[n8][i] = n7 == n6 ? (double)n5 * dArray2[n7][i] : (double)n5 * dArray2[n7][i] + (double)n4 * dArray2[n7][i];
            }
        }
        LinToolImpl linToolImpl = new LinToolImpl();
        double[] dArray3 = linToolImpl.matrixVectorMult(dArray2, dArray);
        LinResult linResult = new LinResult();
        linResult.A = dArray2;
        linResult.b = dArray3;
        linResult.isPivotColumn = blArray;
        linResult.x = dArray;
        return linResult;
    }

    public static void print(String string, ComplexNumber[] complexNumberArray) {
        System.out.println(LinUtil.toString(string, complexNumberArray, 8, 3));
    }

    public static void print(String string, ComplexNumber[][] complexNumberArray) {
        System.out.println(LinUtil.toString(string, complexNumberArray, 8, 3));
    }

    public static String toString(String string, ComplexNumber[] complexNumberArray, int n, int n2) {
        if (complexNumberArray == null) {
            return string + ": complex vector: null";
        }
        String string2 = string + ": Vector, length=" + complexNumberArray.length + ": [";
        String string3 = " %" + n + "." + n2 + "f";
        for (int i = 0; i < complexNumberArray.length; ++i) {
            string2 = string2 + "(" + String.format(string3, complexNumberArray[i].re) + "," + String.format(string3, complexNumberArray[i].im) + ")";
        }
        string2 = string2 + "]\n";
        return string2;
    }

    public static String toString(String string, ComplexNumber[][] complexNumberArray, int n, int n2) {
        if (complexNumberArray == null) {
            return string + ": complex matrix: null";
        }
        int n3 = complexNumberArray.length;
        int n4 = complexNumberArray[0].length;
        String string2 = string + ": Matrix, numRows=" + n3 + " numCols=" + n4 + ":\n";
        String string3 = " %" + n + "." + n2 + "f";
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                string2 = string2 + "(" + String.format(string3, complexNumberArray[i][j].re) + "," + String.format(string3, complexNumberArray[i][j].im) + ")";
            }
            string2 = string2 + "\n";
        }
        return string2;
    }

    public static ComplexNumber[][] makeDFTMatrix(int n) {
        ComplexNumber[][] complexNumberArray = new ComplexNumber[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                double d = Math.cos(Math.PI * 2 * (double)i * (double)j / (double)n);
                double d2 = -Math.sin(Math.PI * 2 * (double)i * (double)j / (double)n);
                ComplexImpl complexImpl = new ComplexImpl(d, d2);
                complexNumberArray[j][i] = complexImpl;
            }
        }
        return complexNumberArray;
    }

    public static ComplexNumber[][] makeInverseDFTMatrix(int n) {
        ComplexNumber[][] complexNumberArray = new ComplexNumber[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                double d = Math.cos(Math.PI * 2 * (double)j * (double)i / (double)n);
                double d2 = Math.sin(Math.PI * 2 * (double)j * (double)i / (double)n);
                ComplexImpl complexImpl = new ComplexImpl(d, d2);
                complexNumberArray[i][j] = complexImpl;
            }
        }
        return complexNumberArray;
    }

    public static ComplexNumber[] computeDFT(double[] dArray) {
        if (dArray == null) {
            return null;
        }
        int n = dArray.length;
        ComplexNumber[] complexNumberArray = new ComplexNumber[n];
        for (int i = 0; i < n; ++i) {
            complexNumberArray[i] = new ComplexImpl(dArray[i], 0.0);
        }
        ComplexNumber[] complexNumberArray2 = new ComplexNumber[n];
        for (int i = 0; i < n; ++i) {
            ComplexNumber complexNumber = new ComplexImpl(0.0, 0.0);
            for (int j = 0; j < n; ++j) {
                double d = Math.cos(Math.PI * 2 * (double)i * (double)j / (double)n);
                double d2 = -Math.sin(Math.PI * 2 * (double)i * (double)j / (double)n);
                ComplexImpl complexImpl = new ComplexImpl(d, d2);
                ComplexNumber complexNumber2 = complexNumberArray[j].mult(complexImpl);
                complexNumber = ((ComplexNumber)complexNumber).add(complexNumber2);
            }
            complexNumberArray2[i] = ((ComplexNumber)complexNumber).mult(1.0 / (double)n);
        }
        return complexNumberArray2;
    }

    public static ComplexNumber[] computeInverseDFT(ComplexNumber[] complexNumberArray) {
        if (complexNumberArray == null) {
            return null;
        }
        int n = complexNumberArray.length;
        ComplexNumber[] complexNumberArray2 = new ComplexNumber[n];
        for (int i = 0; i < n; ++i) {
            ComplexNumber complexNumber = new ComplexImpl(0.0, 0.0);
            for (int j = 0; j < n; ++j) {
                double d = Math.cos(Math.PI * 2 * (double)j * (double)i / (double)n);
                double d2 = Math.sin(Math.PI * 2 * (double)j * (double)i / (double)n);
                ComplexImpl complexImpl = new ComplexImpl(d, d2);
                ComplexNumber complexNumber2 = complexNumberArray[j].mult(complexImpl);
                complexNumber = ((ComplexNumber)complexNumber).add(complexNumber2);
            }
            complexNumberArray2[i] = complexNumber;
        }
        return complexNumberArray2;
    }

    public static ComplexNumber[] computeFFT(double[] dArray) {
        if (dArray == null) {
            return null;
        }
        int n = dArray.length;
        if (!LinUtil.isPowerOf2(n)) {
            return null;
        }
        ComplexNumber[] complexNumberArray = new ComplexNumber[n];
        for (int i = 0; i < n; ++i) {
            complexNumberArray[i] = new ComplexImpl(dArray[i], 0.0);
        }
        ComplexNumber[] complexNumberArray2 = LinUtil.recursiveFFT(complexNumberArray, n);
        for (int i = 0; i < n; ++i) {
            complexNumberArray2[i] = complexNumberArray2[i].mult(1.0 / (double)n);
        }
        return complexNumberArray2;
    }

    static ComplexNumber[] recursiveFFT(ComplexNumber[] complexNumberArray, int n) {
        ComplexImpl complexImpl;
        double d;
        int n2;
        if (n == 1) {
            return new ComplexNumber[]{complexNumberArray[0]};
        }
        if (n % 2 != 0) {
            System.out.println("ERROR: N not divisible by 2");
            return null;
        }
        ComplexNumber[] complexNumberArray2 = new ComplexNumber[n / 2];
        for (int i = 0; i < n / 2; ++i) {
            complexNumberArray2[i] = complexNumberArray[2 * i];
        }
        ComplexNumber[] complexNumberArray3 = LinUtil.recursiveFFT(complexNumberArray2, n / 2);
        ComplexNumber[] complexNumberArray4 = new ComplexNumber[n / 2];
        for (int i = 0; i < n / 2; ++i) {
            complexNumberArray4[i] = complexNumberArray[2 * i + 1];
        }
        ComplexNumber[] complexNumberArray5 = LinUtil.recursiveFFT(complexNumberArray4, n / 2);
        ComplexNumber[] complexNumberArray6 = new ComplexNumber[n];
        for (n2 = 0; n2 < n / 2; ++n2) {
            d = (double)(-2 * n2) * Math.PI / (double)n;
            complexImpl = new ComplexImpl(Math.cos(d), Math.sin(d));
            complexNumberArray6[n2] = complexNumberArray3[n2].add(((ComplexNumber)complexImpl).mult(complexNumberArray5[n2]));
        }
        for (n2 = n / 2; n2 < n; ++n2) {
            d = (double)(-2 * n2) * Math.PI / (double)n;
            complexImpl = new ComplexImpl(Math.cos(d), Math.sin(d));
            complexNumberArray6[n2] = complexNumberArray3[n2 - n / 2].add(((ComplexNumber)complexImpl).mult(complexNumberArray5[n2 - n / 2]));
        }
        return complexNumberArray6;
    }

    public static ComplexNumber[] computeInverseFFT(ComplexNumber[] complexNumberArray) {
        if (complexNumberArray == null) {
            return null;
        }
        int n = complexNumberArray.length;
        if (!LinUtil.isPowerOf2(n)) {
            return null;
        }
        return LinUtil.inverseFFT(complexNumberArray, n);
    }

    public static ComplexNumber[] inverseFFT(ComplexNumber[] complexNumberArray, int n) {
        ComplexImpl complexImpl;
        double d;
        int n2;
        if (n == 1) {
            return new ComplexNumber[]{complexNumberArray[0]};
        }
        if (n % 2 != 0) {
            System.out.println("ERROR: N not divisible by 2");
            return null;
        }
        ComplexNumber[] complexNumberArray2 = new ComplexNumber[n / 2];
        for (int i = 0; i < n / 2; ++i) {
            complexNumberArray2[i] = complexNumberArray[2 * i];
        }
        ComplexNumber[] complexNumberArray3 = LinUtil.inverseFFT(complexNumberArray2, n / 2);
        ComplexNumber[] complexNumberArray4 = new ComplexNumber[n / 2];
        for (int i = 0; i < n / 2; ++i) {
            complexNumberArray4[i] = complexNumberArray[2 * i + 1];
        }
        ComplexNumber[] complexNumberArray5 = LinUtil.inverseFFT(complexNumberArray4, n / 2);
        ComplexNumber[] complexNumberArray6 = new ComplexNumber[n];
        for (n2 = 0; n2 < n / 2; ++n2) {
            d = (double)(2 * n2) * Math.PI / (double)n;
            complexImpl = new ComplexImpl(Math.cos(d), Math.sin(d));
            complexNumberArray6[n2] = complexNumberArray3[n2].add(((ComplexNumber)complexImpl).mult(complexNumberArray5[n2]));
        }
        for (n2 = n / 2; n2 < n; ++n2) {
            d = (double)(2 * n2) * Math.PI / (double)n;
            complexImpl = new ComplexImpl(Math.cos(d), Math.sin(d));
            complexNumberArray6[n2] = complexNumberArray3[n2 - n / 2].add(((ComplexNumber)complexImpl).mult(complexNumberArray5[n2 - n / 2]));
        }
        return complexNumberArray6;
    }

    public static boolean isPowerOf2(int n) {
        int n2;
        double d;
        if (n == 0) {
            return false;
        }
        if (n == 1 || n == 2) {
            return true;
        }
        double d2 = Math.log10(n) / Math.log10(2.0);
        return !(Math.abs(d2 - (d = (double)(n2 = (int)Math.floor(d2)))) > 1.0E-7);
    }

    public static double[][] makeEquations(double[][] dArray) {
        int n;
        int n2;
        int n3;
        LinToolImpl linToolImpl = new LinToolImpl();
        double[][] dArray2 = linToolImpl.copy(dArray);
        for (n3 = 0; n3 < dArray2.length; ++n3) {
            for (n2 = 0; n2 < dArray2[0].length - 1; ++n2) {
                dArray2[n3][n2] = n3 == n2 ? 1.0 : 0.0;
            }
        }
        for (n3 = dArray2[0].length - 2; n3 >= 0; --n3) {
            for (n2 = n3 - 1; n2 >= 0; --n2) {
                for (n = 0; n < dArray2[0].length; ++n) {
                    dArray2[n2][n] = dArray2[n2][n] + dArray[n2][n3] * dArray2[n3][n];
                }
            }
        }
        LinUtil.print("REF", dArray2);
        for (n3 = dArray2[0].length - 2; n3 >= 0; --n3) {
            for (n2 = n3 + 1; n2 < dArray2.length; ++n2) {
                for (n = 0; n < dArray2[0].length; ++n) {
                    dArray2[n2][n] = dArray2[n2][n] + dArray[n2][n3] * dArray2[n3][n];
                }
            }
        }
        return dArray2;
    }

    public static double[][] swapRows(double[][] dArray, int n, int n2) {
        LinToolImpl linToolImpl = new LinToolImpl();
        double[][] dArray2 = linToolImpl.copy(dArray);
        linToolImpl.swapRows(dArray2, n, n2);
        return dArray2;
    }

    public static double[] extractLastColumn(double[][] dArray) {
        LinToolImpl linToolImpl = new LinToolImpl();
        double[] dArray2 = linToolImpl.getColumnAsVector(dArray, dArray[0].length - 1);
        return dArray2;
    }

    public static double[][] extractMatrix(double[][] dArray) {
        double[][] dArray2 = new double[dArray.length][dArray[0].length - 1];
        for (int i = 0; i < dArray2.length; ++i) {
            for (int j = 0; j < dArray2[0].length; ++j) {
                dArray2[i][j] = dArray[i][j];
            }
        }
        return dArray2;
    }

    public static class Line {
        public double[] p;
        public double[] q;

        public Line(double[] dArray, double[] dArray2) {
            this.p = dArray;
            this.q = dArray2;
        }
    }
}

