/*
 * Decompiled with CFR 0.152.
 */
package edu.gwu.lintool;

import edu.gwu.lintool.EigenvalueDecomposition;
import edu.gwu.lintool.LUDecomposition;
import edu.gwu.lintool.Maths;
import edu.gwu.lintool.QRDecomposition;
import edu.gwu.lintool.SingularValueDecomposition;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Vector;

class JMatrix
implements Cloneable {
    private double[][] A;
    private int m;
    private int n;

    public JMatrix(int n, int n2) {
        this.m = n;
        this.n = n2;
        this.A = new double[n][n2];
    }

    public JMatrix(int n, int n2, double d) {
        this.m = n;
        this.n = n2;
        this.A = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.A[i][j] = d;
            }
        }
    }

    public JMatrix(double[][] dArray) {
        this.m = dArray.length;
        this.n = dArray[0].length;
        for (int i = 0; i < this.m; ++i) {
            if (dArray[i].length == this.n) continue;
            System.out.println("ERROR: JMatrix: all rows must have the same length");
            System.exit(0);
        }
        this.A = dArray;
    }

    public JMatrix(double[][] dArray, int n, int n2) {
        this.A = dArray;
        this.m = n;
        this.n = n2;
    }

    public static JMatrix constructWithCopy(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        JMatrix jMatrix = new JMatrix(n, n2);
        double[][] dArray2 = jMatrix.getArray();
        for (int i = 0; i < n; ++i) {
            if (dArray[i].length != n2) {
                System.out.println("All rows must have the same length.");
                System.exit(0);
            }
            for (int j = 0; j < n2; ++j) {
                dArray2[i][j] = dArray[i][j];
            }
        }
        return jMatrix;
    }

    public JMatrix copy() {
        JMatrix jMatrix = new JMatrix(this.m, this.n);
        double[][] dArray = jMatrix.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                dArray[i][j] = this.A[i][j];
            }
        }
        return jMatrix;
    }

    public Object clone() {
        return this.copy();
    }

    public double[][] getArray() {
        return this.A;
    }

    public double[][] getArrayCopy() {
        double[][] dArray = new double[this.m][this.n];
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                dArray[i][j] = this.A[i][j];
            }
        }
        return dArray;
    }

    public int getRowDimension() {
        return this.m;
    }

    public int getColumnDimension() {
        return this.n;
    }

    public double get(int n, int n2) {
        return this.A[n][n2];
    }

    public JMatrix getMatrix(int n, int n2, int n3, int n4) {
        JMatrix jMatrix = new JMatrix(n2 - n + 1, n4 - n3 + 1);
        double[][] dArray = jMatrix.getArray();
        try {
            for (int i = n; i <= n2; ++i) {
                for (int j = n3; j <= n4; ++j) {
                    dArray[i - n][j - n3] = this.A[i][j];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("JMatrix ERROR: submatrix index out of bounds");
            System.exit(0);
        }
        return jMatrix;
    }

    public JMatrix getMatrix(int[] nArray, int[] nArray2) {
        JMatrix jMatrix = new JMatrix(nArray.length, nArray2.length);
        double[][] dArray = jMatrix.getArray();
        try {
            for (int i = 0; i < nArray.length; ++i) {
                for (int j = 0; j < nArray2.length; ++j) {
                    dArray[i][j] = this.A[nArray[i]][nArray2[j]];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("JMatrix ERROR: submatrix index out of bounds");
            System.exit(0);
        }
        return jMatrix;
    }

    public JMatrix getMatrix(int n, int n2, int[] nArray) {
        JMatrix jMatrix = new JMatrix(n2 - n + 1, nArray.length);
        double[][] dArray = jMatrix.getArray();
        try {
            for (int i = n; i <= n2; ++i) {
                for (int j = 0; j < nArray.length; ++j) {
                    dArray[i - n][j] = this.A[i][nArray[j]];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("JMatrix ERROR: submatrix index out of bounds");
            System.exit(0);
        }
        return jMatrix;
    }

    public JMatrix getMatrix(int[] nArray, int n, int n2) {
        JMatrix jMatrix = new JMatrix(nArray.length, n2 - n + 1);
        double[][] dArray = jMatrix.getArray();
        try {
            for (int i = 0; i < nArray.length; ++i) {
                for (int j = n; j <= n2; ++j) {
                    dArray[i][j - n] = this.A[nArray[i]][j];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("JMatrix ERROR: submatrix index out of bounds");
            System.exit(0);
        }
        return jMatrix;
    }

    public void set(int n, int n2, double d) {
        this.A[n][n2] = d;
    }

    public void setMatrix(int n, int n2, int n3, int n4, JMatrix jMatrix) {
        try {
            for (int i = n; i <= n2; ++i) {
                for (int j = n3; j <= n4; ++j) {
                    this.A[i][j] = jMatrix.get(i - n, j - n3);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("JMatrix ERROR: submatrix index out of bounds");
            System.exit(0);
        }
    }

    public void setMatrix(int[] nArray, int[] nArray2, JMatrix jMatrix) {
        try {
            for (int i = 0; i < nArray.length; ++i) {
                for (int j = 0; j < nArray2.length; ++j) {
                    this.A[nArray[i]][nArray2[j]] = jMatrix.get(i, j);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("JMatrix ERROR: submatrix index out of bounds");
            System.exit(0);
        }
    }

    public void setMatrix(int[] nArray, int n, int n2, JMatrix jMatrix) {
        try {
            for (int i = 0; i < nArray.length; ++i) {
                for (int j = n; j <= n2; ++j) {
                    this.A[nArray[i]][j] = jMatrix.get(i, j - n);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("JMatrix ERROR: submatrix index out of bounds");
            System.exit(0);
        }
    }

    public void setMatrix(int n, int n2, int[] nArray, JMatrix jMatrix) {
        try {
            for (int i = n; i <= n2; ++i) {
                for (int j = 0; j < nArray.length; ++j) {
                    this.A[i][nArray[j]] = jMatrix.get(i - n, j);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("JMatrix ERROR: submatrix index out of bounds");
            System.exit(0);
        }
    }

    public JMatrix transpose() {
        JMatrix jMatrix = new JMatrix(this.n, this.m);
        double[][] dArray = jMatrix.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                dArray[j][i] = this.A[i][j];
            }
        }
        return jMatrix;
    }

    public double norm1() {
        double d = 0.0;
        for (int i = 0; i < this.n; ++i) {
            double d2 = 0.0;
            for (int j = 0; j < this.m; ++j) {
                d2 += Math.abs(this.A[j][i]);
            }
            d = Math.max(d, d2);
        }
        return d;
    }

    public double norm2() {
        return new SingularValueDecomposition(this).norm2();
    }

    public double normInf() {
        double d = 0.0;
        for (int i = 0; i < this.m; ++i) {
            double d2 = 0.0;
            for (int j = 0; j < this.n; ++j) {
                d2 += Math.abs(this.A[i][j]);
            }
            d = Math.max(d, d2);
        }
        return d;
    }

    public double normF() {
        double d = 0.0;
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                d = Maths.hypot(d, this.A[i][j]);
            }
        }
        return d;
    }

    public JMatrix uminus() {
        JMatrix jMatrix = new JMatrix(this.m, this.n);
        double[][] dArray = jMatrix.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                dArray[i][j] = -this.A[i][j];
            }
        }
        return jMatrix;
    }

    public JMatrix plus(JMatrix jMatrix) {
        this.checkMatrixDimensions(jMatrix);
        JMatrix jMatrix2 = new JMatrix(this.m, this.n);
        double[][] dArray = jMatrix2.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                dArray[i][j] = this.A[i][j] + jMatrix.A[i][j];
            }
        }
        return jMatrix2;
    }

    public JMatrix plusEquals(JMatrix jMatrix) {
        this.checkMatrixDimensions(jMatrix);
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.A[i][j] = this.A[i][j] + jMatrix.A[i][j];
            }
        }
        return this;
    }

    public JMatrix minus(JMatrix jMatrix) {
        this.checkMatrixDimensions(jMatrix);
        JMatrix jMatrix2 = new JMatrix(this.m, this.n);
        double[][] dArray = jMatrix2.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                dArray[i][j] = this.A[i][j] - jMatrix.A[i][j];
            }
        }
        return jMatrix2;
    }

    public JMatrix minusEquals(JMatrix jMatrix) {
        this.checkMatrixDimensions(jMatrix);
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.A[i][j] = this.A[i][j] - jMatrix.A[i][j];
            }
        }
        return this;
    }

    public JMatrix arrayTimes(JMatrix jMatrix) {
        this.checkMatrixDimensions(jMatrix);
        JMatrix jMatrix2 = new JMatrix(this.m, this.n);
        double[][] dArray = jMatrix2.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                dArray[i][j] = this.A[i][j] * jMatrix.A[i][j];
            }
        }
        return jMatrix2;
    }

    public JMatrix arrayTimesEquals(JMatrix jMatrix) {
        this.checkMatrixDimensions(jMatrix);
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.A[i][j] = this.A[i][j] * jMatrix.A[i][j];
            }
        }
        return this;
    }

    public JMatrix arrayRightDivide(JMatrix jMatrix) {
        this.checkMatrixDimensions(jMatrix);
        JMatrix jMatrix2 = new JMatrix(this.m, this.n);
        double[][] dArray = jMatrix2.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                dArray[i][j] = this.A[i][j] / jMatrix.A[i][j];
            }
        }
        return jMatrix2;
    }

    public JMatrix arrayRightDivideEquals(JMatrix jMatrix) {
        this.checkMatrixDimensions(jMatrix);
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.A[i][j] = this.A[i][j] / jMatrix.A[i][j];
            }
        }
        return this;
    }

    public JMatrix arrayLeftDivide(JMatrix jMatrix) {
        this.checkMatrixDimensions(jMatrix);
        JMatrix jMatrix2 = new JMatrix(this.m, this.n);
        double[][] dArray = jMatrix2.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                dArray[i][j] = jMatrix.A[i][j] / this.A[i][j];
            }
        }
        return jMatrix2;
    }

    public JMatrix arrayLeftDivideEquals(JMatrix jMatrix) {
        this.checkMatrixDimensions(jMatrix);
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.A[i][j] = jMatrix.A[i][j] / this.A[i][j];
            }
        }
        return this;
    }

    public JMatrix times(double d) {
        JMatrix jMatrix = new JMatrix(this.m, this.n);
        double[][] dArray = jMatrix.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                dArray[i][j] = d * this.A[i][j];
            }
        }
        return jMatrix;
    }

    public JMatrix timesEquals(double d) {
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.A[i][j] = d * this.A[i][j];
            }
        }
        return this;
    }

    public JMatrix times(JMatrix jMatrix) {
        if (jMatrix.m != this.n) {
            System.out.println("JMatrix ERROR: times(): Matrix inner dimensions must agree.");
            System.exit(0);
        }
        JMatrix jMatrix2 = new JMatrix(this.m, jMatrix.n);
        double[][] dArray = jMatrix2.getArray();
        double[] dArray2 = new double[this.n];
        for (int i = 0; i < jMatrix.n; ++i) {
            int n;
            for (n = 0; n < this.n; ++n) {
                dArray2[n] = jMatrix.A[n][i];
            }
            for (n = 0; n < this.m; ++n) {
                double[] dArray3 = this.A[n];
                double d = 0.0;
                for (int j = 0; j < this.n; ++j) {
                    d += dArray3[j] * dArray2[j];
                }
                dArray[n][i] = d;
            }
        }
        return jMatrix2;
    }

    public LUDecomposition lu() {
        return new LUDecomposition(this);
    }

    public QRDecomposition qr() {
        return new QRDecomposition(this);
    }

    public SingularValueDecomposition svd() {
        return new SingularValueDecomposition(this);
    }

    public EigenvalueDecomposition eig() {
        return new EigenvalueDecomposition(this);
    }

    public JMatrix solve(JMatrix jMatrix) {
        return this.m == this.n ? new LUDecomposition(this).solve(jMatrix) : new QRDecomposition(this).solve(jMatrix);
    }

    public JMatrix solveTranspose(JMatrix jMatrix) {
        return this.transpose().solve(jMatrix.transpose());
    }

    public JMatrix inverse() {
        return this.solve(JMatrix.identity(this.m, this.m));
    }

    public double det() {
        return new LUDecomposition(this).det();
    }

    public int rank() {
        return new SingularValueDecomposition(this).rank();
    }

    public double cond() {
        return new SingularValueDecomposition(this).cond();
    }

    public double trace() {
        double d = 0.0;
        for (int i = 0; i < Math.min(this.m, this.n); ++i) {
            d += this.A[i][i];
        }
        return d;
    }

    public static JMatrix random(int n, int n2) {
        JMatrix jMatrix = new JMatrix(n, n2);
        double[][] dArray = jMatrix.getArray();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[i][j] = Math.random();
            }
        }
        return jMatrix;
    }

    public static JMatrix identity(int n, int n2) {
        JMatrix jMatrix = new JMatrix(n, n2);
        double[][] dArray = jMatrix.getArray();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[i][j] = i == j ? 1.0 : 0.0;
            }
        }
        return jMatrix;
    }

    public void print(int n, int n2) {
        this.print(new PrintWriter(System.out, true), n, n2);
    }

    public void print(PrintWriter printWriter, int n, int n2) {
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
        decimalFormat.setMinimumIntegerDigits(1);
        decimalFormat.setMaximumFractionDigits(n2);
        decimalFormat.setMinimumFractionDigits(n2);
        decimalFormat.setGroupingUsed(false);
        this.print(printWriter, decimalFormat, n + 2);
    }

    public void print(NumberFormat numberFormat, int n) {
        this.print(new PrintWriter(System.out, true), numberFormat, n);
    }

    public void print(PrintWriter printWriter, NumberFormat numberFormat, int n) {
        printWriter.println();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                String string = numberFormat.format(this.A[i][j]);
                int n2 = Math.max(1, n - string.length());
                for (int k = 0; k < n2; ++k) {
                    printWriter.print(' ');
                }
                printWriter.print(string);
            }
            printWriter.println();
        }
        printWriter.println();
    }

    public static JMatrix read(BufferedReader bufferedReader) {
        try {
            int n;
            StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
            streamTokenizer.resetSyntax();
            streamTokenizer.wordChars(0, 255);
            streamTokenizer.whitespaceChars(0, 32);
            streamTokenizer.eolIsSignificant(true);
            Vector<Double> vector = new Vector<Double>();
            while (streamTokenizer.nextToken() == 10) {
            }
            if (streamTokenizer.ttype == -1) {
                throw new IOException("Unexpected EOF on matrix read.");
            }
            do {
                vector.addElement(Double.valueOf(streamTokenizer.sval));
            } while (streamTokenizer.nextToken() == -3);
            int n2 = vector.size();
            double[] dArray = new double[n2];
            for (int i = 0; i < n2; ++i) {
                dArray[i] = (Double)vector.elementAt(i);
            }
            Vector<double[]> vector2 = new Vector<double[]>();
            vector2.addElement(dArray);
            while (streamTokenizer.nextToken() == -3) {
                dArray = new double[n2];
                vector2.addElement(dArray);
                n = 0;
                do {
                    if (n >= n2) {
                        throw new IOException("Row " + vector2.size() + " is too long.");
                    }
                    dArray[n++] = Double.valueOf(streamTokenizer.sval);
                } while (streamTokenizer.nextToken() == -3);
                if (n >= n2) continue;
                throw new IOException("Row " + vector2.size() + " is too short.");
            }
            n = vector2.size();
            double[][] dArrayArray = new double[n][];
            vector2.copyInto((Object[])dArrayArray);
            return new JMatrix(dArrayArray);
        }
        catch (Exception exception) {
            System.out.println("ERROR: JMatrix.read(): IO exception e=" + exception);
            System.exit(0);
            return null;
        }
    }

    private void checkMatrixDimensions(JMatrix jMatrix) {
        if (jMatrix.m != this.m || jMatrix.n != this.n) {
            System.out.println("ERROR: JMatrix matrix Dim mismatch");
            System.exit(0);
        }
    }
}

