/*
 * Decompiled with CFR 0.152.
 */
package edu.gwu.lintool;

import edu.gwu.lintool.EigenvalueDecomposition;
import edu.gwu.lintool.JMatrix;
import edu.gwu.lintool.LinResult;
import edu.gwu.lintool.LinToolImpl;
import edu.gwu.lintool.QRDecomposition;
import edu.gwu.lintool.SingularValueDecomposition;

public class LinToolLibrary {
    public static LinResult inverse(double[][] dArray) {
        JMatrix jMatrix = new JMatrix(dArray);
        JMatrix jMatrix2 = jMatrix.inverse();
        LinResult linResult = new LinResult();
        linResult.Ainv = jMatrix2.getArray();
        return linResult;
    }

    public static LinResult computeQR(double[][] dArray) {
        JMatrix jMatrix = new JMatrix(dArray);
        QRDecomposition qRDecomposition = new QRDecomposition(jMatrix);
        JMatrix jMatrix2 = qRDecomposition.getQ();
        JMatrix jMatrix3 = qRDecomposition.getR();
        LinResult linResult = new LinResult();
        linResult.A = dArray;
        linResult.Q = jMatrix2.getArray();
        linResult.R = jMatrix3.getArray();
        return linResult;
    }

    public static LinResult computeEigenvaluesAndVectors(double[][] dArray) {
        JMatrix jMatrix = new JMatrix(dArray);
        EigenvalueDecomposition eigenvalueDecomposition = new EigenvalueDecomposition(jMatrix);
        double[] dArray2 = eigenvalueDecomposition.getRealEigenvalues();
        JMatrix jMatrix2 = eigenvalueDecomposition.getV();
        LinResult linResult = new LinResult();
        linResult.A = dArray;
        linResult.S = jMatrix2.getArray();
        linResult.lambda = dArray2;
        linResult.imagLambda = eigenvalueDecomposition.getImagEigenvalues();
        return linResult;
    }

    public static LinResult computeSVD(double[][] dArray) {
        if (dArray == null) {
            return null;
        }
        if (dArray.length >= dArray[0].length) {
            JMatrix jMatrix = new JMatrix(dArray);
            SingularValueDecomposition singularValueDecomposition = new SingularValueDecomposition(jMatrix);
            LinResult linResult = new LinResult();
            linResult.A = dArray;
            linResult.V = singularValueDecomposition.getV().getArray();
            linResult.U = singularValueDecomposition.getU().getArray();
            linResult.sigma = singularValueDecomposition.getSingularValues();
            int n = linResult.rank = singularValueDecomposition.rank();
            linResult.Sigma = new double[n][n];
            for (int i = 0; i < n; ++i) {
                linResult.Sigma[i][i] = linResult.sigma[i];
            }
            return linResult;
        }
        LinToolImpl linToolImpl = new LinToolImpl();
        double[][] dArray2 = linToolImpl.transpose(dArray);
        JMatrix jMatrix = new JMatrix(dArray2);
        SingularValueDecomposition singularValueDecomposition = new SingularValueDecomposition(jMatrix);
        LinResult linResult = new LinResult();
        linResult.A = dArray;
        linResult.V = singularValueDecomposition.getU().getArray();
        linResult.U = singularValueDecomposition.getV().getArray();
        linResult.sigma = singularValueDecomposition.getSingularValues();
        int n = linResult.rank = singularValueDecomposition.rank();
        linResult.Sigma = new double[n][n];
        for (int i = 0; i < n; ++i) {
            linResult.Sigma[i][i] = linResult.sigma[i];
        }
        return linResult;
    }

    public static LinResult computeSVDShortForm(double[][] dArray) {
        int n;
        if (dArray == null) {
            return null;
        }
        LinResult linResult = LinToolLibrary.computeSVD(dArray);
        int n2 = linResult.rank;
        int n3 = dArray.length;
        int n4 = dArray[0].length;
        double[][] dArray2 = new double[n3][n2];
        for (int i = 0; i < n3; ++i) {
            for (n = 0; n < n2; ++n) {
                dArray2[i][n] = linResult.U[i][n];
            }
        }
        double[][] dArray3 = new double[n4][n2];
        for (n = 0; n < n4; ++n) {
            for (int i = 0; i < n2; ++i) {
                dArray3[n][i] = linResult.V[n][i];
            }
        }
        linResult.U = dArray2;
        linResult.V = dArray3;
        return linResult;
    }

    public static LinResult oldComputeSVD(double[][] dArray) {
        JMatrix jMatrix = new JMatrix(dArray);
        SingularValueDecomposition singularValueDecomposition = new SingularValueDecomposition(jMatrix);
        JMatrix jMatrix2 = singularValueDecomposition.getU();
        JMatrix jMatrix3 = singularValueDecomposition.getV();
        double[] dArray2 = singularValueDecomposition.getSingularValues();
        LinResult linResult = new LinResult();
        linResult.A = dArray;
        linResult.U = jMatrix2.getArray();
        linResult.V = jMatrix3.getArray();
        linResult.sigma = dArray2;
        return linResult;
    }
}

