/* $Id: MsqlException.java,v 2.0 1998/10/21 02:38:49 borg Exp $ */
/* Copyright (c) 1997 George Reese */
package com.imaginary.sql.msql;

import java.sql.SQLException;

/**
 * This class is an SQLException that has special constructors for
 * messages directly from mSQL.<BR>
 * Last modified $Date: 1998/10/21 02:38:49 $
 * @version $Revision: 2.0 $
 * @author George Reese (borg@imaginary.com)
 */
public class MsqlException extends SQLException {
    /**
     * Constructs an MsqlException based on an error message from mSQL.
     * @param data an error message starting with -1:
     */
    public MsqlException(String data) {
	super(data.substring(3));
    }

    /**
     * Constructs an MsqlException based on some odd exception.
     * @param e the exception that caused this to be thrown.
     */
    public MsqlException(Exception e) {
	super(e.getMessage());
    }
}
