/* $Id: MsqlDatabaseMetaData.java,v 2.0.2.1 1999/01/22 05:33:48 borg Exp $ */
/* Copyright (c) 1997 George Reese */
package com.imaginary.sql.msql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * This class is not yet done.<BR>
 * Last modified $Date: 1999/01/22 05:33:48 $
 * @version $Revision: 2.0.2.1 $
 * @author George Reese (borg@imaginary.com)
 */
public class MsqlDatabaseMetaData implements DatabaseMetaData {
    private MsqlConnection connection = null;
    
    MsqlDatabaseMetaData(MsqlConnection conn) {
	super();
	connection = conn;
    }
    
    public boolean allProceduresAreCallable() throws SQLException {
	return false;
    }

    public boolean allTablesAreSelectable() throws SQLException {
	return true;
    }

    public String getURL() throws SQLException {
	return connection.url;
    }
    
    public String getUserName() throws SQLException {
	return connection.user;
    }

    public boolean isReadOnly() throws SQLException {
	return false;
    }

    public boolean nullsAreSortedHigh() throws SQLException {
	return true;
    }

    public boolean nullsAreSortedLow() throws SQLException {
	return false;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
	return false;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
	return false;
    }

    public String getDatabaseProductName() throws SQLException {
	return "miniSQL";
    }

    public String getDatabaseProductVersion() throws SQLException {
	return connection.version_string;
    }

    public String getDriverName() throws SQLException {
	return "Imaginary JDBC Driver for mSQL";
    }

    public String getDriverVersion() throws SQLException {
	return "1.0b2";
    }

    public int getDriverMajorVersion() {
	return 1;
    }

    public int getDriverMinorVersion() {
	return 0;
    }

    public boolean usesLocalFiles() throws SQLException {
	return true;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
	return true;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
	return true;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
	return false;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
	return false;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
	return false;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
	return true;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
	return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
	return false;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
	return false;
    }

    public String getIdentifierQuoteString() throws SQLException {
	return " ";
    }

    public String getSQLKeywords() throws SQLException {
	return "TEXT,RLIKE,CLIKE";
    }

    public String getNumericFunctions() throws SQLException {
	if( connection.version == 2 ) {
	    return "";
	}
	else {
	    return "";
	}
    }

    public String getStringFunctions() throws SQLException {
	return "";
    }

    public String getSystemFunctions() throws SQLException {
	return "";
    }

    public String getTimeDateFunctions() throws SQLException {
	return "";
    }

    public String getSearchStringEscape() throws SQLException {
	return "\\";
    }

    public String getExtraNameCharacters() throws SQLException {
	return "";
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
	return false;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
	return false;
    }

    public boolean supportsColumnAliasing() throws SQLException {
	return true;
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
	return true;
    }

    public boolean supportsConvert() throws SQLException {
	return false;
    }

    public boolean supportsConvert(int fromType, int toType)
    throws SQLException {
	return false;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
	return false;
    }

    public boolean supportsDifferentTableCorrelationNames() 
    throws SQLException {
	return false;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
	return false;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
	return false;
    }

    public boolean supportsGroupBy() throws SQLException {
	return ((connection.version == 2) ? true : false);
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
	return false;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
	return false;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
	return true;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
	return false;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
	return true;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
	return true;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
	return false;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
	return false;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
	return false;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
	return false;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
	return false;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
	return false;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
	return false;
    }

    public boolean supportsOuterJoins() throws SQLException {
	return false;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
	return false;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
	return false;
    }

    public String getSchemaTerm() throws SQLException {
	throw new SQLException("mSQL does not support schemas.");
    }

    public String getProcedureTerm() throws SQLException {
	throw new SQLException("mSQL does not support procedures.");
    }

    public String getCatalogTerm() throws SQLException {
	throw new SQLException("mSQL does not support catalogs.");
    }

    public boolean isCatalogAtStart() throws SQLException {
	throw new SQLException("mSQL does not support catalogs.");
    }

    public String getCatalogSeparator() throws SQLException {
	throw new SQLException("mSQL does not support catalogs.");
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
	throw new SQLException("mSQL does not support schemas.");
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
	throw new SQLException("mSQL does not support schemas.");
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
	throw new SQLException("mSQL does not support schemas.");
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
	throw new SQLException("mSQL does not support schemas.");
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException{
	throw new SQLException("mSQL does not support schemas.");
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
	throw new SQLException("mSQL does not support catalogs.");
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
	throw new SQLException("mSQL does not support catalogs or procs.");
    }
    
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
	throw new SQLException("mSQL does not support catalogs.");
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
	throw new SQLException("mSQL does not support catalogs.");
    }

    public boolean supportsCatalogsInPrivilegeDefinitions()
    throws SQLException {
	throw new SQLException("mSQL does not support catalogs.");
    }

    public boolean supportsPositionedDelete() throws SQLException {
	return false;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
	return false;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
	return false;
    }

    public boolean supportsStoredProcedures() throws SQLException {
	return false;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
	return ((connection.version == 2) ? true : false);
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
	return false;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
	return ((connection.version == 2) ? true : false);
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
	return false;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
	return ((connection.version == 2) ? true : false);
    }

    public boolean supportsUnion() throws SQLException {
	return false;
    }

    public boolean supportsUnionAll() throws SQLException {
	return false;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
	return false;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
	return false;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
	return true;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
	return true;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
	return 0;
    }

    public int getMaxCharLiteralLength() throws SQLException {
	return 0;
    }

    public int getMaxColumnNameLength() throws SQLException {
	return 0;
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
	return 0;
    }

    public int getMaxColumnsInIndex() throws SQLException {
	return 1;
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
	return 0;
    }

    public int getMaxColumnsInSelect() throws SQLException {
	return 4096;
    }

    public int getMaxColumnsInTable() throws SQLException {
	return 0;
    }

    public int getMaxConnections() throws SQLException {
	return 0;
    }

    public int getMaxCursorNameLength() throws SQLException {
	return 0;
    }

    public int getMaxIndexLength() throws SQLException {
	return 0;
    }

    public int getMaxSchemaNameLength() throws SQLException {
	return 0;
    }

    public int getMaxProcedureNameLength() throws SQLException {
	return 0;
    }

    public int getMaxCatalogNameLength() throws SQLException {
	return 0;
    }

    public int getMaxRowSize() throws SQLException {
	return 0;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
	return true;
    }

    public int getMaxStatementLength() throws SQLException {
	return 0;
    }

    public int getMaxStatements() throws SQLException {
	return 24;
    }

    public int getMaxTableNameLength() throws SQLException {
	return 0;
    }

    public int getMaxTablesInSelect() throws SQLException {
	return 0;
    }

    public int getMaxUserNameLength() throws SQLException {
	return 8;
    }

    public int getDefaultTransactionIsolation() throws SQLException {
	return Connection.TRANSACTION_NONE;
    }

    public boolean supportsTransactions() throws SQLException {
	return false;
    }

    public boolean supportsTransactionIsolationLevel(int level)
    throws SQLException {
	return false;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions()
    throws SQLException {
	return true;
    }
    
    public boolean supportsDataManipulationTransactionsOnly()
    throws SQLException {
	return false;
    }
    
    public boolean dataDefinitionCausesTransactionCommit()
    throws SQLException {
	return true;
    }
    
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
	return false;
    }

    public ResultSet getProcedures(String catalog, String schemaPattern,
				   String procedureNamePattern)
    throws SQLException {
	throw new SQLException("mSQL does not support stored procedures.");
    }

    public ResultSet getProcedureColumns(String catalog,
					 String schemaPattern,
					 String procedureNamePattern, 
					 String columnNamePattern)
    throws SQLException {
	throw new SQLException("mSQL does not support stored procedures.");
    }

    public ResultSet getTables(String ct, String sch, String tn, String[] typs)
    throws SQLException {
	Connection conn = DriverManager.getConnection(getURL(), getUserName(),
						      "");
	ResultSet rs = ((MsqlConnection)conn).getTables(tn);

	conn.close();
	return rs;
    }

    public ResultSet getSchemas() throws SQLException {
	throw new SQLException("mSQL does not support schemas.");
    }

    public ResultSet getCatalogs() throws SQLException {
	throw new SQLException("mSQL does not support catalogs");
    }

    public ResultSet getTableTypes() throws SQLException {
	return null; //FLAG: TABLE TYPES
    }

    public ResultSet getColumns(String ct, String sch, String tn, String col)
    throws SQLException {
	return null; //FLAG: COLUMNS
    }
    
    public ResultSet getColumnPrivileges(String ct, String sch, String tn,
					 String cn) throws SQLException {
	return new MsqlEmptyResultSet();
    }

    public ResultSet getTablePrivileges(String ct, String sch, String tn)
    throws SQLException {
	return new MsqlEmptyResultSet();
    }

    public ResultSet getBestRowIdentifier(String ct, String sch, String t,
					  int scope, boolean nullable)
    throws SQLException {
	return new MsqlEmptyResultSet();
    }
	
    public ResultSet getVersionColumns(String ct, String sch, String t)
    throws SQLException {
	return new MsqlEmptyResultSet();
    }

    public ResultSet getPrimaryKeys(String ct, String sch, String t)
    throws SQLException {
	return new MsqlEmptyResultSet();
    }

    public ResultSet getImportedKeys(String ct, String sch, String t)
    throws SQLException {
	return new MsqlEmptyResultSet();
    }

    public ResultSet getExportedKeys(String ct, String sch, String t)
    throws SQLException {
	return new MsqlEmptyResultSet();
    }

    public ResultSet getCrossReference(String pcat, String pschem,
				       String ptable, String fcat,
				       String fschem, String ftable)
    throws SQLException {
	throw new SQLException("This makes no sense.");
    }  

    public ResultSet getTypeInfo() throws SQLException {
	//	return new MsqlTypeInfo(connection.version);
	return new MsqlEmptyResultSet();
    }
	
    public ResultSet getIndexInfo(String catalog, String schema, String table,
				  boolean unique, boolean approximate)
    throws SQLException {
	return new MsqlEmptyResultSet();
    }
 }

