/* $Id: MsqlColumn.java,v 2.0 1998/10/21 02:38:44 borg Exp $ */
/* Copyright (c) 1997 George Reese */
package com.imaginary.sql.msql;

import java.sql.Types;

/**
 * This class holds meta information about mSQL columns in a result set.<BR>
 * Last modified $Date: 1998/10/21 02:38:44 $
 * @version $Revision: 2.0 $
 * @author George Reese (borg@imaginary.com)
 */
public class MsqlColumn {
    private String  column_name = null;
    private int     length      = 0;
    private boolean primary_key = false;
    private boolean nullable    = false;
    private String  table_name  = null;
    private int     type        = Types.CHAR;
    
    MsqlColumn(String col, String table, int typ, int len, boolean n,
	       boolean pk) {
	super();
	column_name = col;
	table_name = table;
	length = len;
	nullable = n;
	primary_key = pk;
	type = typ;
	switch( typ ) {
	case 1:
	    type = Types.INTEGER;
	    break;
	    
	case 2:
	    type = Types.CHAR;
	    break;
	    
	case 3:
	    type = Types.REAL;
	    break;
	    
	case 5:
	    type = Types.NULL;
	    break;

	case 6:
	    type = Types.VARCHAR;
	    break;

	case 7:
	    type = Types.DATE;
	    break;

	case 8:
	    type = Types.INTEGER;
	    break;

	case 9:
	    type = Types.DOUBLE;
	    break;

	case 10:
	    type = Types.TIME;
	    break;
	}
    }

    boolean isNullable() {
	return nullable;
    }

    boolean isPrimaryKey() {
	return primary_key;
    }
    
    String getColumnName() {
	return column_name;
    }

    int getLength() {
	return length;
    }

    String getTableName() {
	return table_name;
    }

    int getType() {
       return type;
    }
}
