/* This example shows how to use mSQL-JDBC with a database
 * with data stored in UTF8 encoding.  UTF8 is an 8-bit encoding scheme
 * to support Unicode in single byte systems.
 */
import java.sql.*;
import java.util.*;

class Unicode {
  public static void main(String args[]) {
    if( args.length != 2 ) {
      System.err.println("Syntax: <java Update [number] [string]>");
      return;
    }
    try {
      Class.forName("com.imaginary.sql.msql.MsqlDriver").newInstance();
      String url = "jdbc:msql://athens.imaginary.com:1114/db_test";
      Properties p = new Properties();
      p.put("user", "borg");
      p.put("encoding", "UTF8");
      Connection con = DriverManager.getConnection(url, p);
      Statement s = con.createStatement();   
      s.executeUpdate("INSERT INTO utest (uid, uval) " +
		      "VALUES(" + args[0] + ", '" + args[1] + "')");
      System.out.println("Insert succeeded.");
      s.close();
      s = con.createStatement();
      ResultSet r = s.executeQuery("SELECT uid, uval FROM utest");
      while( r.next() ) {
	  System.out.println("uid: " + r.getInt(1) + ", uval: " +
			     r.getString(2));
      }
      con.close();
    }
    catch( Exception e ) {
      e.printStackTrace();
    }
  }
}
    
