/* $Id: MsqlStatement.java,v 2.3 1998/10/25 18:05:21 borg Exp $ */
/* Copyright (c) 1997 George Reese */
package com.imaginary.sql.msql;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

/**
 * The MsqlStatement class implements the JDBC Statement interface.
 * This class represents any SQL statement.<BR>
 * Last modified $Date: 1998/10/25 18:05:21 $
 * @version $Revision: 2.3 $
 * @author George Reese (borg@imaginary.com)
 */
public class MsqlStatement implements Statement {
    private MsqlConnection   connection          = null;
    private MsqlResultSet    current             = null;
    private String           encoding            = "8859_1";
    private MsqlInputStream  input               = null;
    private int              max_field_size      = 0;
    private int              max_rows            = 4096;
    private MsqlOutputStream output              = null;
    private ResultSet        result              = null;
    private int              row_or_column_count = -1;
    private int              timeout             = 0;
    private SQLWarning       warnings            = null;
    
    MsqlStatement(MsqlConnection c, MsqlInputStream in, MsqlOutputStream out,
		  String enc)
    throws SQLException {
	connection = c;
	input = in;
	output = out;
	encoding = enc;
    }

    private void closeAllResults() {
	if( result != null ) {
	    try {
		result.close();
	    }
	    catch( SQLException e ) {
		e.printStackTrace();
	    }
	    result = null;
	}
	if( current != null ) {
	    try {
		current.close();
	    }
	    catch( SQLException e ) {
		e.printStackTrace();
	    }
	    current = null;
	}
    }

    private boolean sendSQL(String sql) throws SQLException {
	String tmp;
	int i;

	try {
	    output.writeString("3 " + sql, encoding);
	    tmp = input.readString(encoding);
	}
	catch( IOException e ) {
	    try {
		connection.close();
		close();
	    }
	    catch( SQLException ee ) {
	    }
	    throw new MsqlException(e);
	}
	i = tmp.indexOf(':');
	if( i == -1 ) {
	    throw new SQLException("Incorrect mSQL response.");
	}
	row_or_column_count = Integer.parseInt(tmp.substring(0, i));
	if( row_or_column_count == -1 ) {
	    throw new SQLException(tmp.substring(2));
	}
	i = tmp.indexOf(':', 2);
	if( i == -1 ) {
	    return false;
	}
	else {
	    try {
		row_or_column_count = Integer.parseInt(tmp.substring(2, i));
	    }
	    catch( NumberFormatException e ) {
		row_or_column_count = 0;
		return false;
	    }
	    return true;
	}
    }
    
    public synchronized ResultSet executeQuery(String sql)
    throws SQLException {
	closeAllResults();
	if( sendSQL(sql) ) {
	    current = new MsqlResultSet(this, input, row_or_column_count,
					encoding);
	}
	else {
	    throw new SQLException("Non-query sent to executeQuery().");
	}
	return current;
    }

    public int executeUpdate(String sql) throws SQLException {
	closeAllResults();
	if( !sendSQL(sql) ) {
	    return row_or_column_count;
	}
	else {
	    throw new SQLException("Query sent to executeUpdate().");
	}
    }
    
    public boolean execute(String sql) throws SQLException {
	ResultSet r = null;

	closeAllResults();
	if( !sendSQL(sql) ) {
	    return false;
	}
	else {
	    current = new MsqlResultSet(this, input, row_or_column_count,
					encoding);
	    result = current;
	    return true;
	}
    }

    MsqlConnection getConnection() {
	return connection;
    }
    
    public void close() throws SQLException {
	if( current != null ) {
	    try {
		current.close();
	    }
	    catch( SQLException e ) {
		current = null;
		throw e;
	    }
	    current = null;
	}
    }
  
    public ResultSet getResultSet() throws SQLException {
	ResultSet r;
	
	r = result; 
	result = null;
	return r;
    }

    public int getUpdateCount() throws SQLException {
	int x = row_or_column_count;

	if( result != null ) {
	    x = -1;
	}
	row_or_column_count = -1;
	return x;
    }

    public boolean getMoreResults() throws SQLException {
	return (result != null);
    }

    public int getMoreCounts() throws SQLException {
	return -1;
    }

    public int getMaxFieldSize() throws SQLException {
	return max_field_size;
    }

    public void setMaxFieldSize(int max) throws SQLException {
	max_field_size = max;
    }

    public int getMaxRows() throws SQLException {
	return max_rows;
    }

    public void setMaxRows(int max) throws SQLException {
	max_rows = max;
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
	throw new SQLException("mSQL does not support escape processing.");
    }

    public int getQueryTimeout() throws SQLException {
	return timeout;
    }

    public void setQueryTimeout(int x) throws SQLException {
	timeout = x;
    }

    public void cancel() {
	
    }
  
    public final SQLWarning getWarnings() throws SQLException {
	return warnings;
    }

    public void clearWarnings() throws SQLException {
	warnings = null;
    }

    public void setCursorName(String unused) throws SQLException {
	throw new SQLException("mSQL does not support cursors.");
    }
}
