/* $Id: MsqlResultSetMetaData.java,v 2.0 1998/10/21 02:38:53 borg Exp $ */
/* Copyright (c) 1997 George Reese */
package com.imaginary.sql.msql;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Vector;

/**
 * The MsqlResultSetMetaData class is the mSQL implementation of the
 * JDBC ResultSetMetaData interface.  It should never be referenced directly.
 * You should instead use the JDBC API.<BR>
 * Last modified $Date: 1998/10/21 02:38:53 $
 * @version $Revision: 2.0 $
 * @author George Reese (borg@imaginary.com)
 */
public class MsqlResultSetMetaData implements ResultSetMetaData, Runnable {
    private Vector        columns        = new Vector();
    private boolean       complete       = false;
    private MsqlResultSet field_results  = null;
    private SQLException  load_exception = null;
    private String        schema         = null;
    
    MsqlResultSetMetaData(MsqlResultSet f) {
	super();
	field_results = f;
	(new Thread(this)).start();
    }

    public void run() {
	try {
	    while( field_results.next() ) {
		String tname, cname;
		boolean nullable, pk;
		int type, length;
		
		schema =
		    field_results.getStatement().getConnection().getUser();
		tname = field_results.getString(1);
		cname = field_results.getString(2);
		type = field_results.getInt(3);
		length = field_results.getInt(4);
		try {
		    String tmp = field_results.getString(5);
		    
		    if( tmp.equals("Y") ) {
			nullable = false;
		    }
		    else {
			nullable = true;
		    }
		}
		catch( SQLException e ) {
		    nullable = true;
		}
		try {
		    String tmp = field_results.getString(6);
		    
		    if( tmp.equals("Y") ) {
			pk = true;
		    }
		    else {
			pk = false;
		    }
		}
		catch( SQLException e ) {
		    pk = false;
		}
		columns.addElement(new MsqlColumn(cname, tname, type,
						  length, nullable, pk));
	    }
	    synchronized( columns ) {
		complete = true;
		columns.notify();
	    }
	}
	catch( SQLException e ) {
	    synchronized( columns ) {
		load_exception = e;
		complete = true;
		columns.notify();
	    }
	}
    }

    private void waitOnLoad() throws SQLException {
	synchronized( columns ) {
	    while( !complete ) {
		try {
		    columns.wait();
		}
		catch( InterruptedException e ) {
		    if( !complete ) {
			throw new MsqlException(e);
		    }
		}
		if( load_exception != null ) {
		    throw load_exception;
		}
	    }
	}
    }
    
    MsqlColumn getColumn(int column) throws SQLException {
	waitOnLoad();
	if( column < 1 || column > columns.size() ) {
	    throw new SQLException("Invalid column check.");
	}
	return (MsqlColumn)columns.elementAt(column-1);
    }
    
    public int getColumnCount() throws SQLException {
	waitOnLoad();
	return columns.size();
    }

    public boolean isAutoIncrement(int column) throws SQLException { 
	return false;
    }

    public boolean isCaseSensitive(int column) throws SQLException {
	return true;
    }

    public boolean isSearchable(int column) throws SQLException {
	return true;
    }

    public boolean isCurrency(int column) throws SQLException {
	return false;
    }

    public int isNullable(int column) throws SQLException {
	MsqlColumn c = getColumn(column);
	
	if( c.isNullable() ) {
	    return ResultSetMetaData.columnNullable;
	}
	else {
	    return ResultSetMetaData.columnNoNulls;
	}
    }

    public boolean isSigned(int column) throws SQLException {
	return true;
    }

    public int getColumnDisplaySize(int column) throws SQLException {
	MsqlColumn c = getColumn(column);

	return c.getLength();
    }

    public String getColumnLabel(int column) throws SQLException {
	MsqlColumn c = getColumn(column);
	
	return (c.getTableName() + "." + c.getColumnName());
    }

    public String getColumnName(int column) throws SQLException {
	MsqlColumn c = getColumn(column);

	return c.getColumnName();
    }

    public String getSchemaName(int column) throws SQLException {
	return schema;
    }

    public int getPrecision(int column) throws SQLException {
	throw new SQLException("mSQL has no clue what the precision is.");
    }

    public int getScale(int column) throws SQLException {
	throw new SQLException("mSQL has no clue what the scale is.");
    }

    public String getTableName(int column) throws SQLException {
	MsqlColumn c = getColumn(column);

	return c.getTableName();
    }

    public String getCatalogName(int column) throws SQLException {
	throw new SQLException("mSQL does not support catalogs.");
    }

    public int getColumnType(int column) throws SQLException {
	MsqlColumn c = getColumn(column);

	return c.getType();
    }
    
    public String getColumnTypeName(int column) throws SQLException {
	MsqlColumn c = getColumn(column);
	
	switch( c.getType() ) {
	case Types.INTEGER:
	    return "INT";

	case Types.CHAR:
	    return "CHAR";

	case Types.DATE:
	    return "DATE";

	case Types.DOUBLE:
	    return "MONEY";
	    
	case Types.REAL:
	    return "REAL";

	case Types.TIME:
	    return "TIME";
	    
	case Types.VARCHAR:
	    return "TEXT";
	    
	default:
	    return "NULL";
	}
    }

    public boolean isReadOnly(int column) throws SQLException {
	return false;
    }
    
    public boolean isWritable(int column) throws SQLException {
	return true;
    }
    
    public boolean isDefinitelyWritable(int column) throws SQLException {
	return true;
    }
}

