/* $Id: MsqlOutputStream.java,v 2.0 1998/10/21 02:38:51 borg Exp $ */
/* Copyright (c) 1997 George Reese */
package com.imaginary.sql.msql;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.OutputStream;
import java.io.IOException;

/**
 * Represents a stream of data going to the mSQL database.<BR>
 * Last modified $Date: 1998/10/21 02:38:51 $
 * @version $Revision: 2.0 $
 * @author George Reese (borg@imaginary.com)
 */
public class MsqlOutputStream {
    private DataOutputStream output;

    /**
     * Constructs a new MsqlOutputStream using the specified OutputStream.
     * @param out the OutputStream to be used
     * @exception java.io.IOException an error occurred creating a
     * DataOutputStream
     */
    public MsqlOutputStream(OutputStream out) throws IOException {
	super();
	output = new DataOutputStream(new BufferedOutputStream(out));
    }

    /**
     * Closes the output stream.
     * @exception java.io.IOException an error occurred on close
     */
    public void close() throws IOException {
	output.close();
    }

    /**
     * Flushes the output queue.
     * @exception java.io.IOException an error occurred flushing the stream
     */
    public void flush() throws IOException {
	output.flush();
    }

    /**
     * Writes some data out to the mSQL database.
     * @param bytes an array of bytes to be written to the database
     * @exception java.io.IOException an error occurred on write
     */
    public void write(byte[] bytes) throws IOException {
	int size = bytes.length;
	
	for(int i=0; i<4; i++) {
	    output.write(size);
	    size >>>= 8;
	}
	output.write(bytes, 0, bytes.length);
	output.flush();
    }

    /**
     * Writes a string out to the database using the specified
     * encoding.
     * @param str the string to be written
     * @param encoding the encoding for the database
     * @exception java.io.IOException an error occurred on write
     */
    public void writeString(String str, String encoding)
    throws IOException {
	write(str.getBytes(encoding));
    }
}
