/* $Id: MsqlEmptyResultSet.java,v 2.0 1998/10/21 02:38:47 borg Exp $ */
/* Copyright (c) 1997 George Reese */
package com.imaginary.sql.msql;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.sql.Types;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Hashtable;
import java.util.Vector;

/**
 * The MsqlEmptyResultSet class implements the JDBC ResultSet interface for
 * fake result sets with no data.
 * Last modified $Date: 1998/10/21 02:38:47 $
 * @version $Revision: 2.0 $
 * @author George Reese (borg@imaginary.com)
 */
public class MsqlEmptyResultSet implements ResultSet {
    // Constructs the result set
    MsqlEmptyResultSet() throws SQLException {
	super();
    }

    /**
     * @return true if the last value read was null
     * @exception java.sql.SQLException never thrown
     */
    public synchronized boolean wasNull() throws SQLException {
	return false;
    }

    /**
     * For performance reasons, you should get values by column
     * number when at all possible.
     * @param cname the name of the desired column
     * @return never
     * @exception java.sql.SQLException thrown when the column cannot be read
     */
    public synchronized InputStream getAsciiStream(String cname)
    throws SQLException {
	throw new SQLException("Result set contains no data.");
    }

    /**
     * @param column the column number for the desired column
     * @return never
     * @exception java.sql.SQLException thrown when the columb cannot be read
     */
    public synchronized InputStream getAsciiStream(int column)
    throws SQLException {
	throw new SQLException("Result set contains no data.");
    }

    public synchronized BigDecimal getBigDecimal(String cname, int scale)
    throws SQLException {
	throw new SQLException("Result set contains no data.");
    }
    
    public synchronized BigDecimal getBigDecimal(int column, int scale)
    throws SQLException {
	throw new SQLException("Result set contains no data.");
    }

    public synchronized InputStream getBinaryStream(String cname)
    throws SQLException {
	throw new SQLException("Result set contains no data.");
    }
    
    public synchronized InputStream getBinaryStream(int column)
    throws SQLException {
	throw new SQLException("Result set contains no data.");
    }
  
    public synchronized boolean getBoolean(String cname) throws SQLException {
	throw new SQLException("Result set contains no data.");
    }
    
    public synchronized boolean getBoolean(int column) throws SQLException {
	throw new SQLException("Result set contains no data.");
    }

    public synchronized byte getByte(String cname) throws SQLException {
	throw new SQLException("Result set contains no data.");
    }
    
    public synchronized byte getByte(int column) throws SQLException {
	throw new SQLException("Result set contains no data.");
    }

    public synchronized byte[] getBytes(String cname) throws SQLException {
	throw new SQLException("Result set contains no data.");
    }
    
    public synchronized byte[] getBytes(int column) throws SQLException {
	throw new SQLException("Result set contains no data.");
    }

    private synchronized void getColumn(int column) throws SQLException {
	throw new SQLException("Result set contains no data.");
    }

    public String getCursorName() throws SQLException {
	throw new SQLException("mSQL does not support cursors.");
    }

    public synchronized Date getDate(String cname) throws SQLException {
	throw new SQLException("Result set contains no data.");
    }
    
    public synchronized Date getDate(int column) throws SQLException {
	throw new SQLException("Result set contains no data.");
    }
    
    public synchronized double getDouble(String cname) throws SQLException {
	throw new SQLException("Result set contains no data.");
    }
    
    public synchronized double getDouble(int column) throws SQLException {
	throw new SQLException("Result set contains no data.");
    }  

    public synchronized float getFloat(String cname) throws SQLException {
	throw new SQLException("Result set contains no data.");
    }
    
    public synchronized float getFloat(int column) throws SQLException {
	throw new SQLException("Result set contains no data.");
    }  

    public synchronized int getInt(String cname) throws SQLException {
	throw new SQLException("Result set contains no data.");
    }
    
    public synchronized int getInt(int column) throws SQLException {
	throw new SQLException("Result set contains no data.");
    }

    public synchronized long getLong(String cname) throws SQLException {
	throw new SQLException("Result set contains no data.");
    }
    
    public synchronized long getLong(int column) throws SQLException {
	throw new SQLException("Result set contains no data.");
    }  

    public ResultSetMetaData getMetaData() throws SQLException {
	throw new SQLException("Result set contains no data.");
    }

    public synchronized Object getObject(String cname) throws SQLException {
	throw new SQLException("Result set contains no data.");
    }
  
    public synchronized Object getObject(int column) throws SQLException {
	throw new SQLException("Result set contains no data.");
    }

    public synchronized short getShort(String cname) throws SQLException {
	throw new SQLException("Result set contains no data.");
    }
    
    public synchronized short getShort(int column) throws SQLException {
	throw new SQLException("Result set contains no data.");
    }
    
    public synchronized String getString(String cname) throws SQLException {
	throw new SQLException("Result set contains no data.");
    }
    
    public synchronized String getString(int column) throws SQLException {
	throw new SQLException("Result set contains no data.");
    }

    public synchronized Time getTime(String cname) throws SQLException {
	throw new SQLException("Result set contains no data.");
    }
    
    public synchronized Time getTime(int column) throws SQLException {
	throw new SQLException("Result set contains no data.");
    }

    public synchronized Timestamp getTimestamp(String cname)
    throws SQLException {
	throw new SQLException("Result set contains no data.");
    }
    
    public synchronized Timestamp getTimestamp(int column)
    throws SQLException {
	throw new SQLException("Result set contains no data.");
    }

    public synchronized InputStream getUnicodeStream(String cname)
    throws SQLException {
	throw new SQLException("Result set contains no data.");
    }
    
    public synchronized InputStream getUnicodeStream(int column)
    throws SQLException {
	throw new SQLException("Result set contains no data.");
    }

    public synchronized SQLWarning getWarnings() throws SQLException {
	return null;
    }

    public synchronized void clearWarnings() throws SQLException {
    }

    /**
     * Closes the result set.
     * @exception java.sql.SQLException thrown for errors on closing
     */
    public void close() throws SQLException {
    }

    /**
     * @param name the name of the desired column
     * @return the column number for the specified column name
     * @exception java.sql.SQLException thrown on a read error
     */
    public synchronized int findColumn(String name) throws SQLException {
	throw new SQLException("Result set contains no data.");
    }

    /**
     * Moves to the next row of data for processing.  If there are no
     * more rows to be processed, then it will return false.
     * @return true if there are results to be processed, false otherwise
     * @exception java.sql.SQLException thrown if a read error occurs
     */
    public synchronized boolean next() throws SQLException {
	return false;
    }
}
