/*
 * Decompiled with CFR 0.152.
 */
package com.imaginary.sql.msql;

import com.imaginary.sql.msql.MsqlAsciiInputStream;
import com.imaginary.sql.msql.MsqlException;
import com.imaginary.sql.msql.MsqlInputStream;
import com.imaginary.sql.msql.MsqlResultSet;
import com.imaginary.sql.msql.MsqlResultSetMetaData;
import com.imaginary.sql.msql.MsqlStatement;
import com.imaginary.sql.msql.MsqlUnicodeInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Hashtable;
import java.util.Vector;

public class MsqlTableList
implements ResultSet {
    private final int column_count;
    private Hashtable column_map;
    private boolean complete = false;
    private int current_row = -1;
    private byte[][] current_row_data;
    private MsqlResultSet field_info;
    protected byte[] last_column;
    private MsqlInputStream input;
    private ResultSetMetaData meta_data;
    private boolean meta_set = false;
    private MsqlException read_exception;
    private Vector rows = new Vector();
    private MsqlStatement statement = null;
    private SQLWarning warnings;

    MsqlTableList(MsqlInputStream msqlInputStream, String string) throws SQLException {
        this.input = msqlInputStream;
        this.column_count = 5;
        this.meta_set = true;
        this.getRows();
    }

    public synchronized boolean wasNull() throws SQLException {
        return this.last_column == null;
    }

    public synchronized InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public synchronized InputStream getAsciiStream(int n) throws SQLException {
        this.getColumn(n);
        return new MsqlAsciiInputStream(this.last_column);
    }

    public synchronized BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public synchronized BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return new BigDecimal(new BigInteger("0"), n2);
        }
        return new BigDecimal(new BigInteger(string), n2);
    }

    public synchronized InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public synchronized InputStream getBinaryStream(int n) throws SQLException {
        this.getColumn(n);
        return new ByteArrayInputStream(this.last_column);
    }

    public synchronized boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public synchronized boolean getBoolean(int n) throws SQLException {
        this.getColumn(n);
        if (this.wasNull()) {
            return false;
        }
        if (this.last_column.length == 0) {
            return false;
        }
        return this.last_column[0] != 48 && this.last_column[0] != 0;
    }

    public synchronized byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public synchronized byte getByte(int n) throws SQLException {
        this.getColumn(n);
        if (this.wasNull()) {
            return 0;
        }
        return this.last_column[0];
    }

    public synchronized byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public synchronized byte[] getBytes(int n) throws SQLException {
        this.getColumn(n);
        return this.last_column;
    }

    protected synchronized void getColumn(int n) throws SQLException {
        try {
            this.last_column = this.current_row_data[n - 1];
            return;
        }
        catch (Exception exception) {
            if (this.current_row_data == null) {
                throw new MsqlException("-1:Result set positioned before first row.");
            }
            throw new MsqlException(exception);
        }
    }

    public String getCursorName() throws SQLException {
        throw new SQLException("mSQL does not support cursors.");
    }

    public synchronized Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public synchronized Date getDate(int n) throws SQLException {
        long l = this.getTimeAsLong(n);
        if (this.wasNull()) {
            return null;
        }
        return new Date(l);
    }

    public synchronized double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public synchronized double getDouble(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return 0.0;
        }
        try {
            return Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new MsqlException(numberFormatException);
        }
    }

    public synchronized float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public synchronized float getFloat(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return 0.0f;
        }
        try {
            return Float.valueOf(string).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            throw new MsqlException(numberFormatException);
        }
    }

    public synchronized int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public synchronized int getInt(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return 0;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new MsqlException(numberFormatException);
        }
    }

    public synchronized long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public synchronized long getLong(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return 0L;
        }
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new MsqlException(numberFormatException);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResultSetMetaData getMetaData() throws SQLException {
        block14: {
            var3_1 = this;
            synchronized (var3_1) {
                if (this.meta_data != null) {
                    return this.meta_data;
                }
            }
            var2_3 = this.rows;
            synchronized (var2_3) {
                while (true) lbl-1000:
                // 3 sources

                {
                    if (this.field_info != null) {
                        var1_6 = new MsqlResultSetMetaData(this.field_info);
                        break block14;
                    }
                    try {
                        this.rows.wait();
                    }
                    catch (InterruptedException var4_5) {
                        if (this.field_info == null) ** break;
                        continue;
                        throw new MsqlException(var4_5);
                    }
                    break;
                }
                ** GOTO lbl-1000
            }
        }
        var2_3 = this;
        synchronized (var2_3) {
            this.meta_data = var1_6;
            return this.meta_data;
        }
    }

    public synchronized Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public synchronized Object getObject(int n) throws SQLException {
        ResultSetMetaData resultSetMetaData = this.getMetaData();
        int n2 = resultSetMetaData.getColumnType(n);
        switch (n2) {
            case -7: {
                return new Boolean(this.getBoolean(n));
            }
            case -6: {
                return new Character((char)this.getInt(n));
            }
            case 5: {
                return new Integer(this.getShort(n));
            }
            case 4: {
                return new Integer(this.getInt(n));
            }
            case -5: {
                return new Long(this.getLong(n));
            }
            case 6: {
                return new Float(this.getFloat(n));
            }
            case 7: {
                return new Float(this.getFloat(n));
            }
            case 8: {
                return new Double(this.getDouble(n));
            }
            case 2: {
                return this.getBigDecimal(n, 0);
            }
            case 3: {
                return this.getBigDecimal(n, 0);
            }
            case 1: {
                return this.getString(n);
            }
            case 12: {
                return this.getString(n);
            }
            case -1: {
                return this.getString(n);
            }
            case 91: {
                return this.getDate(n);
            }
            case 92: {
                return this.getTime(n);
            }
            case 93: {
                return this.getTimestamp(n);
            }
            case -2: {
                return this.getBytes(n);
            }
            case -3: {
                return this.getBytes(n);
            }
            case -4: {
                return this.getBytes(n);
            }
        }
        return this.getString(n);
    }

    /*
     * Unable to fully structure code
     */
    private byte[][] getRow(int var1_1) throws SQLException {
        if (var1_1 < 0) {
            throw new SQLException("Attempt to access a non-existent row.");
        }
        var2_2 = this.rows;
        synchronized (var2_2) {
            if (this.read_exception == null) ** GOTO lbl15
            throw this.read_exception;
lbl-1000:
            // 1 sources

            {
                if (this.complete) {
                    throw new SQLException("Attempt to access a non-existent row.");
                }
                try {
                    this.rows.wait();
                    continue;
                }
                catch (InterruptedException var4_3) {
                    throw new MsqlException(var4_3);
                }
lbl15:
                // 2 sources

                ** while (this.rows.size() <= var1_1)
            }
lbl16:
            // 1 sources

        }
        return (byte[][])this.rows.elementAt(var1_1);
    }

    public synchronized short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public synchronized short getShort(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return 0;
        }
        try {
            return Short.parseShort(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new MsqlException(numberFormatException);
        }
    }

    MsqlStatement getStatement() {
        return this.statement;
    }

    public synchronized String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public synchronized String getString(int n) throws SQLException {
        this.getColumn(n);
        if (this.wasNull()) {
            return null;
        }
        try {
            return new String(this.last_column, "8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new MsqlException(unsupportedEncodingException);
        }
    }

    public synchronized Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public synchronized Time getTime(int n) throws SQLException {
        long l = this.getTimeAsLong(n);
        if (this.wasNull()) {
            return null;
        }
        return new Time(l);
    }

    private long getTimeAsLong(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return 0L;
        }
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM dd hh:mm:ss z yyyy");
                java.util.Date date = simpleDateFormat.parse(string, new ParsePosition(0));
                return date.getTime();
            }
            catch (Exception exception) {
                throw new SQLException("Invalid date format.");
            }
        }
    }

    public synchronized Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public synchronized Timestamp getTimestamp(int n) throws SQLException {
        long l = this.getTimeAsLong(n);
        if (this.wasNull()) {
            return null;
        }
        return new Timestamp(l);
    }

    public synchronized InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public synchronized InputStream getUnicodeStream(int n) throws SQLException {
        this.getColumn(n);
        return new MsqlUnicodeInputStream(this.last_column);
    }

    public synchronized SQLWarning getWarnings() throws SQLException {
        return this.warnings;
    }

    public synchronized void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws SQLException {
        Vector vector = this.rows;
        synchronized (vector) {
            while (true) {
                if (this.complete) {
                    if (!this.meta_set && this.field_info != null) {
                        this.field_info.close();
                    }
                    this.input = null;
                    return;
                }
                try {
                    this.rows.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public synchronized int findColumn(String string) throws SQLException {
        if (string.equals("TABLE_CAT")) {
            return 1;
        }
        if (string.equals("TABLE_SCHEM")) {
            return 2;
        }
        if (string.equals("TABLE_NAME")) {
            return 3;
        }
        if (string.equals("TABLE_TYPE")) {
            return 4;
        }
        if (string.equals("REMARKS")) {
            return 5;
        }
        throw new SQLException("Invalid column name: " + string);
    }

    public synchronized boolean next() throws SQLException {
        ++this.current_row;
        try {
            this.current_row_data = this.getRow(this.current_row);
        }
        catch (SQLException sQLException) {
            return false;
        }
        return true;
    }

    private void readRow(byte[] byArray) throws SQLException {
        String string;
        byte[][] byArray2 = new byte[5][];
        try {
            string = new String(byArray, "8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new MsqlException(unsupportedEncodingException);
        }
        int n = 0;
        while (n < this.column_count) {
            byte[] byArray3;
            if (n < 2) {
                byArray2[n] = null;
            } else if (n == 2) {
                byte[] byArray4;
                int n2;
                int n3 = string.indexOf(58);
                try {
                    n2 = Integer.parseInt(string.substring(0, n3));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SQLException("Invalid row data format from mSQL.");
                }
                if (n2 == -2) {
                    byArray4 = null;
                    n2 = 0;
                } else {
                    String string2 = string.substring(n3 + 1, n3 + n2 + 1);
                    try {
                        byArray4 = string2.getBytes("8859_1");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new MsqlException(unsupportedEncodingException);
                    }
                }
                byArray2[n] = byArray4;
                string = string.substring(n3 + n2 + 1);
            } else if (n == 3) {
                byArray3 = new byte[]{84, 65, 66, 76, 69};
                byArray2[n] = byArray3;
            } else {
                byArray3 = new byte[]{99, 111, 109, 109, 101, 110, 116};
                byArray2[n] = byArray3;
            }
            ++n;
        }
        Vector vector = this.rows;
        synchronized (vector) {
            this.rows.addElement(byArray2);
            this.rows.notify();
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void getRows() {
        Object object;
        while (true) {
            String string;
            Object object2 = this.input;
            synchronized (object2) {
                try {
                    object = this.input.read();
                }
                catch (IOException iOException) {
                    Vector vector = this.rows;
                    synchronized (vector) {
                        this.read_exception = new MsqlException(iOException);
                        this.complete = true;
                        this.input = null;
                        return;
                    }
                }
            }
            try {
                string = new String((byte[])object, "8859_1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
                Vector vector = this.rows;
                synchronized (vector) {
                    this.read_exception = new MsqlException(unsupportedEncodingException);
                    this.complete = true;
                    this.rows.notify();
                    return;
                }
            }
            if (string.startsWith("-1:")) {
                object2 = this.rows;
                synchronized (object2) {
                    this.read_exception = new MsqlException(string);
                    this.complete = true;
                    this.rows.notify();
                    return;
                }
            }
            if (string.startsWith("-100")) break;
            try {
                this.readRow((byte[])object);
            }
            catch (SQLException sQLException) {
                Vector vector = this.rows;
                synchronized (vector) {
                    this.read_exception = new MsqlException(sQLException);
                    this.complete = true;
                    this.rows.notify();
                    return;
                }
            }
        }
        object = this.rows;
        synchronized (object) {
            if (!this.meta_set) {
                try {
                    this.field_info = new MsqlResultSet(this.statement, this.input, 6, true, "8859_1");
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                    this.field_info = null;
                }
            }
            this.complete = true;
            this.rows.notify();
            return;
        }
    }
}

