/*
 * Decompiled with CFR 0.152.
 */
package com.imaginary.sql.msql;

import com.imaginary.sql.msql.MsqlColumn;
import com.imaginary.sql.msql.MsqlException;
import com.imaginary.sql.msql.MsqlResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Vector;

public class MsqlResultSetMetaData
implements ResultSetMetaData,
Runnable {
    private Vector columns = new Vector();
    private boolean complete = false;
    private MsqlResultSet field_results;
    private SQLException load_exception;
    private String schema;

    MsqlResultSetMetaData(MsqlResultSet msqlResultSet) {
        this.field_results = msqlResultSet;
        new Thread(this).start();
    }

    public void run() {
        try {
            Object object;
            while (this.field_results.next()) {
                boolean bl;
                boolean bl2;
                String string;
                this.schema = this.field_results.getStatement().getConnection().getUser();
                object = this.field_results.getString(1);
                String string2 = this.field_results.getString(2);
                int n = this.field_results.getInt(3);
                int n2 = this.field_results.getInt(4);
                try {
                    string = this.field_results.getString(5);
                    bl2 = !string.equals("Y");
                }
                catch (SQLException sQLException) {
                    bl2 = true;
                }
                try {
                    string = this.field_results.getString(6);
                    bl = string.equals("Y");
                }
                catch (SQLException sQLException) {
                    bl = false;
                }
                this.columns.addElement(new MsqlColumn(string2, (String)object, n, n2, bl2, bl));
            }
            object = this.columns;
            synchronized (object) {
                this.complete = true;
                this.columns.notify();
                return;
            }
        }
        catch (SQLException sQLException) {
            Vector vector = this.columns;
            synchronized (vector) {
                this.load_exception = sQLException;
                this.complete = true;
                this.columns.notify();
                return;
            }
        }
    }

    private void waitOnLoad() throws SQLException {
        Vector vector = this.columns;
        synchronized (vector) {
            while (!this.complete) {
                block6: {
                    try {
                        this.columns.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        if (this.complete) break block6;
                        throw new MsqlException(interruptedException);
                    }
                }
                if (this.load_exception == null) continue;
                throw this.load_exception;
            }
            return;
        }
    }

    MsqlColumn getColumn(int n) throws SQLException {
        this.waitOnLoad();
        if (n < 1 || n > this.columns.size()) {
            throw new SQLException("Invalid column check.");
        }
        return (MsqlColumn)this.columns.elementAt(n - 1);
    }

    public int getColumnCount() throws SQLException {
        this.waitOnLoad();
        return this.columns.size();
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        return false;
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        return true;
    }

    public boolean isSearchable(int n) throws SQLException {
        return true;
    }

    public boolean isCurrency(int n) throws SQLException {
        return false;
    }

    public int isNullable(int n) throws SQLException {
        MsqlColumn msqlColumn = this.getColumn(n);
        if (msqlColumn.isNullable()) {
            return 1;
        }
        return 0;
    }

    public boolean isSigned(int n) throws SQLException {
        return true;
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        MsqlColumn msqlColumn = this.getColumn(n);
        return msqlColumn.getLength();
    }

    public String getColumnLabel(int n) throws SQLException {
        MsqlColumn msqlColumn = this.getColumn(n);
        return String.valueOf(msqlColumn.getTableName()) + "." + msqlColumn.getColumnName();
    }

    public String getColumnName(int n) throws SQLException {
        MsqlColumn msqlColumn = this.getColumn(n);
        return msqlColumn.getColumnName();
    }

    public String getSchemaName(int n) throws SQLException {
        return this.schema;
    }

    public int getPrecision(int n) throws SQLException {
        throw new SQLException("mSQL has no clue what the precision is.");
    }

    public int getScale(int n) throws SQLException {
        throw new SQLException("mSQL has no clue what the scale is.");
    }

    public String getTableName(int n) throws SQLException {
        MsqlColumn msqlColumn = this.getColumn(n);
        return msqlColumn.getTableName();
    }

    public String getCatalogName(int n) throws SQLException {
        throw new SQLException("mSQL does not support catalogs.");
    }

    public int getColumnType(int n) throws SQLException {
        MsqlColumn msqlColumn = this.getColumn(n);
        return msqlColumn.getType();
    }

    public String getColumnTypeName(int n) throws SQLException {
        MsqlColumn msqlColumn = this.getColumn(n);
        switch (msqlColumn.getType()) {
            case 4: {
                return "INT";
            }
            case 1: {
                return "CHAR";
            }
            case 91: {
                return "DATE";
            }
            case 8: {
                return "MONEY";
            }
            case 7: {
                return "REAL";
            }
            case 92: {
                return "TIME";
            }
            case 12: {
                return "TEXT";
            }
        }
        return "NULL";
    }

    public boolean isReadOnly(int n) throws SQLException {
        return false;
    }

    public boolean isWritable(int n) throws SQLException {
        return true;
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        return true;
    }
}

