/*
 * Decompiled with CFR 0.152.
 */
package com.imaginary.sql.msql;

import com.imaginary.sql.msql.MsqlAsciiInputStream;
import com.imaginary.sql.msql.MsqlException;
import com.imaginary.sql.msql.MsqlInputStream;
import com.imaginary.sql.msql.MsqlResultSetMetaData;
import com.imaginary.sql.msql.MsqlStatement;
import com.imaginary.sql.msql.MsqlUnicodeInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public class MsqlResultSet
implements ResultSet,
Runnable {
    private int column_count;
    private Hashtable column_map;
    private boolean complete = false;
    private int current_row = -1;
    private byte[][] current_row_data;
    private String encoding = "8859_1";
    private MsqlResultSet field_info;
    protected byte[] last_column;
    private MsqlInputStream input;
    private ResultSetMetaData meta_data;
    private boolean meta_set = false;
    private MsqlException read_exception;
    private Vector rows = new Vector();
    private MsqlStatement statement;
    private SQLWarning warnings;

    MsqlResultSet(MsqlStatement msqlStatement, MsqlInputStream msqlInputStream, int n, String string) throws SQLException {
        this(msqlStatement, msqlInputStream, n, false, string);
    }

    MsqlResultSet(MsqlStatement msqlStatement, MsqlInputStream msqlInputStream, int n, boolean bl, String string) throws SQLException {
        this.statement = msqlStatement;
        this.input = msqlInputStream;
        this.column_count = n;
        this.meta_set = bl;
        this.encoding = string;
        new Thread(this).start();
    }

    public synchronized boolean wasNull() throws SQLException {
        return this.last_column == null;
    }

    public synchronized InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public synchronized InputStream getAsciiStream(int n) throws SQLException {
        this.getColumn(n);
        return new MsqlAsciiInputStream(this.last_column);
    }

    public synchronized BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public synchronized BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return new BigDecimal(new BigInteger("0"), n2);
        }
        return new BigDecimal(new BigInteger(string), n2);
    }

    public synchronized InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public synchronized InputStream getBinaryStream(int n) throws SQLException {
        this.getColumn(n);
        return new ByteArrayInputStream(this.last_column);
    }

    public synchronized boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public synchronized boolean getBoolean(int n) throws SQLException {
        this.getColumn(n);
        if (this.wasNull()) {
            return false;
        }
        if (this.last_column.length == 0) {
            return false;
        }
        return this.last_column[0] != 48 && this.last_column[0] != 0;
    }

    public synchronized byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public synchronized byte getByte(int n) throws SQLException {
        this.getColumn(n);
        if (this.wasNull()) {
            return 0;
        }
        return this.last_column[0];
    }

    public synchronized byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public synchronized byte[] getBytes(int n) throws SQLException {
        this.getColumn(n);
        return this.last_column;
    }

    protected synchronized void getColumn(int n) throws SQLException {
        try {
            this.last_column = this.current_row_data[n - 1];
            return;
        }
        catch (Exception exception) {
            if (this.current_row_data == null) {
                throw new MsqlException("-1:Result set positioned before first row.");
            }
            throw new MsqlException(exception);
        }
    }

    public String getCursorName() throws SQLException {
        throw new SQLException("mSQL does not support cursors.");
    }

    public synchronized Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public synchronized Date getDate(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yyyy", Locale.US);
            java.util.Date date = simpleDateFormat.parse(string);
            return new Date(date.getTime());
        }
        catch (ParseException parseException) {
            try {
                return new Date(Long.parseLong(string));
            }
            catch (NumberFormatException numberFormatException) {
                throw new SQLException("Invalid date format.");
            }
        }
    }

    public synchronized double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public synchronized double getDouble(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return 0.0;
        }
        try {
            return Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new MsqlException(numberFormatException);
        }
    }

    public synchronized float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public synchronized float getFloat(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return 0.0f;
        }
        try {
            return Float.valueOf(string).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            throw new MsqlException(numberFormatException);
        }
    }

    public synchronized int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public synchronized int getInt(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return 0;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new MsqlException(numberFormatException);
        }
    }

    public synchronized long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public synchronized long getLong(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return 0L;
        }
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new MsqlException(numberFormatException);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResultSetMetaData getMetaData() throws SQLException {
        block14: {
            var3_1 = this;
            synchronized (var3_1) {
                if (this.meta_data != null) {
                    return this.meta_data;
                }
            }
            var2_3 = this.rows;
            synchronized (var2_3) {
                while (true) lbl-1000:
                // 3 sources

                {
                    if (this.field_info != null) {
                        var1_6 = new MsqlResultSetMetaData(this.field_info);
                        break block14;
                    }
                    try {
                        this.rows.wait();
                    }
                    catch (InterruptedException var4_5) {
                        if (this.field_info == null) ** break;
                        continue;
                        throw new MsqlException(var4_5);
                    }
                    break;
                }
                ** GOTO lbl-1000
            }
        }
        var2_3 = this;
        synchronized (var2_3) {
            this.meta_data = var1_6;
            return this.meta_data;
        }
    }

    public synchronized Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public synchronized Object getObject(int n) throws SQLException {
        ResultSetMetaData resultSetMetaData = this.getMetaData();
        int n2 = resultSetMetaData.getColumnType(n);
        switch (n2) {
            case -7: {
                return new Boolean(this.getBoolean(n));
            }
            case -6: {
                return new Character((char)this.getInt(n));
            }
            case 5: {
                return new Integer(this.getShort(n));
            }
            case 4: {
                return new Integer(this.getInt(n));
            }
            case -5: {
                return new Long(this.getLong(n));
            }
            case 6: {
                return new Float(this.getFloat(n));
            }
            case 7: {
                return new Float(this.getFloat(n));
            }
            case 8: {
                return new Double(this.getDouble(n));
            }
            case 2: {
                return this.getBigDecimal(n, 0);
            }
            case 3: {
                return this.getBigDecimal(n, 0);
            }
            case 1: {
                return this.getString(n);
            }
            case 12: {
                return this.getString(n);
            }
            case -1: {
                return this.getString(n);
            }
            case 91: {
                return this.getDate(n);
            }
            case 92: {
                return this.getTime(n);
            }
            case 93: {
                return this.getTimestamp(n);
            }
            case -2: {
                return this.getBytes(n);
            }
            case -3: {
                return this.getBytes(n);
            }
            case -4: {
                return this.getBytes(n);
            }
        }
        return this.getString(n);
    }

    /*
     * Unable to fully structure code
     */
    private byte[][] getRow(int var1_1) throws SQLException {
        if (var1_1 < 0) {
            throw new SQLException("Attempt to access a non-existent row.");
        }
        var2_2 = this.rows;
        synchronized (var2_2) {
            if (this.read_exception == null) ** GOTO lbl15
            throw this.read_exception;
lbl-1000:
            // 1 sources

            {
                if (this.complete) {
                    throw new SQLException("Attempt to access a non-existent row.");
                }
                try {
                    this.rows.wait();
                    continue;
                }
                catch (InterruptedException var4_3) {
                    throw new MsqlException(var4_3);
                }
lbl15:
                // 2 sources

                ** while (this.rows.size() <= var1_1)
            }
lbl16:
            // 1 sources

        }
        return (byte[][])this.rows.elementAt(var1_1);
    }

    public synchronized short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public synchronized short getShort(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return 0;
        }
        try {
            return Short.parseShort(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new MsqlException(numberFormatException);
        }
    }

    MsqlStatement getStatement() {
        return this.statement;
    }

    public synchronized String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public synchronized String getString(int n) throws SQLException {
        this.getColumn(n);
        if (this.wasNull()) {
            return null;
        }
        try {
            return new String(this.last_column, this.encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new MsqlException(unsupportedEncodingException);
        }
    }

    public synchronized Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public synchronized Time getTime(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss", Locale.US);
            java.util.Date date = simpleDateFormat.parse(string);
            return new Time(date.getTime());
        }
        catch (ParseException parseException) {
            try {
                return new Time(Long.parseLong(string));
            }
            catch (NumberFormatException numberFormatException) {
                throw new SQLException("Invalid time format.");
            }
        }
    }

    public synchronized Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public synchronized Timestamp getTimestamp(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        return new Timestamp(Long.parseLong(string));
    }

    public synchronized InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public synchronized InputStream getUnicodeStream(int n) throws SQLException {
        this.getColumn(n);
        return new MsqlUnicodeInputStream(this.last_column);
    }

    public synchronized SQLWarning getWarnings() throws SQLException {
        return this.warnings;
    }

    public synchronized void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws SQLException {
        Vector vector = this.rows;
        synchronized (vector) {
            while (true) {
                if (this.complete) {
                    if (!this.meta_set && this.field_info != null) {
                        this.field_info.close();
                    }
                    this.input = null;
                    return;
                }
                try {
                    this.rows.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public synchronized int findColumn(String string) throws SQLException {
        int n;
        Object object;
        if (this.column_map == null) {
            object = this.getMetaData();
            n = object.getColumnCount();
            this.column_map = new Hashtable(n);
            int n2 = 1;
            while (n2 <= n) {
                this.column_map.put(object.getColumnLabel(n2), new Integer(n2));
                ++n2;
            }
        }
        if (!this.column_map.containsKey(string)) {
            object = this.column_map.keys();
            while (object.hasMoreElements()) {
                String string2;
                String string3 = (String)object.nextElement();
                n = string3.indexOf(".");
                if (n == -1 || n >= string3.length() - 1 || !(string2 = string3.substring(n + 1)).equals(string)) continue;
                return (Integer)this.column_map.get(string3);
            }
            throw new SQLException("Invalid column name: " + string);
        }
        return (Integer)this.column_map.get(string);
    }

    public synchronized boolean next() throws SQLException {
        ++this.current_row;
        try {
            this.current_row_data = this.getRow(this.current_row);
        }
        catch (SQLException sQLException) {
            return false;
        }
        return true;
    }

    private int nextBreak(byte[] byArray, int n) {
        int n2 = n;
        while (n2 < byArray.length) {
            if (byArray[n2] == 58) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private byte[] copyBytes(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        int n3 = 0;
        while (n3 < n2) {
            byArray2[n3] = byArray[n + n3];
            ++n3;
        }
        return byArray2;
    }

    private void readRow(byte[] byArray) throws SQLException {
        Vector vector;
        byte[][] byArray2 = new byte[this.column_count][];
        int n = 0;
        int n2 = 0;
        while (n2 < this.column_count) {
            int n3;
            int n4 = this.nextBreak(byArray, n);
            if (n4 == n) {
                n3 = 0;
                byArray2[n2] = new byte[0];
                ++n;
            } else {
                try {
                    String string = new String(byArray, n, n4 - n, "8859_1");
                    n3 = Integer.parseInt(string);
                    if (n3 == -2) {
                        vector = null;
                        n3 = 0;
                    } else {
                        byArray2[n2] = this.copyBytes(byArray, n4 + 1, n3);
                    }
                    n = n4 + n3 + 1;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SQLException("Invalid mSQL row data format.");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new MsqlException(unsupportedEncodingException);
                }
            }
            ++n2;
        }
        vector = this.rows;
        synchronized (vector) {
            this.rows.addElement(byArray2);
            this.rows.notify();
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        Object object;
        while (true) {
            String string;
            Object object2 = this.input;
            synchronized (object2) {
                try {
                    object = this.input.read();
                }
                catch (IOException iOException) {
                    Vector vector = this.rows;
                    synchronized (vector) {
                        this.read_exception = new MsqlException(iOException);
                        this.complete = true;
                        this.input = null;
                        return;
                    }
                }
            }
            try {
                string = new String((byte[])object, this.encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
                Vector vector = this.rows;
                synchronized (vector) {
                    this.read_exception = new MsqlException(unsupportedEncodingException);
                    this.complete = true;
                    this.rows.notify();
                    return;
                }
            }
            if (string.startsWith("-1:")) {
                object2 = this.rows;
                synchronized (object2) {
                    this.read_exception = new MsqlException(string);
                    this.complete = true;
                    this.rows.notify();
                    return;
                }
            }
            if (string.startsWith("-100")) break;
            try {
                this.readRow((byte[])object);
            }
            catch (SQLException sQLException) {
                Vector vector = this.rows;
                synchronized (vector) {
                    this.read_exception = new MsqlException(sQLException);
                    this.read_exception.printStackTrace();
                    this.complete = true;
                    this.rows.notify();
                    return;
                }
            }
        }
        object = this.rows;
        synchronized (object) {
            if (!this.meta_set) {
                try {
                    this.field_info = new MsqlResultSet(this.statement, this.input, 6, true, this.encoding);
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                    this.field_info = null;
                }
            }
            this.complete = true;
            this.rows.notify();
            return;
        }
    }
}

