/*
 * Decompiled with CFR 0.152.
 */
package com.imaginary.sql.msql;

import com.imaginary.sql.msql.MsqlConnection;
import com.imaginary.sql.msql.MsqlException;
import com.imaginary.sql.msql.MsqlInputStream;
import com.imaginary.sql.msql.MsqlOutputStream;
import com.imaginary.sql.msql.MsqlStatement;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Vector;

public class MsqlPreparedStatement
extends MsqlStatement
implements PreparedStatement,
Runnable {
    private String[] constants;
    private int parsing;
    private String statement;
    private String[] values;

    MsqlPreparedStatement(MsqlConnection msqlConnection, String string, MsqlInputStream msqlInputStream, MsqlOutputStream msqlOutputStream, String string2) throws SQLException {
        super(msqlConnection, msqlInputStream, msqlOutputStream, string2);
        this.statement = string;
        new Thread(this).start();
    }

    public synchronized void clearParameters() throws SQLException {
        while (this.parsing != 2) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        int n = 0;
        while (n < this.values.length) {
            this.values[n] = null;
            ++n;
        }
    }

    public synchronized boolean execute() throws SQLException {
        while (this.parsing != 2) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.execute(this.getSQL());
    }

    public synchronized ResultSet executeQuery() throws SQLException {
        while (this.parsing != 2) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.executeQuery(this.getSQL());
    }

    public synchronized int executeUpdate() throws SQLException {
        while (this.parsing != 2) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.executeUpdate(this.getSQL());
    }

    private String fixString(String string) {
        if (string.indexOf("'") != -1) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                switch (c) {
                    case '%': 
                    case '\'': 
                    case '_': {
                        stringBuffer.append('\\');
                        break;
                    }
                }
                stringBuffer.append(c);
                ++n;
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    private String getSQL() throws SQLException {
        String string = this.constants[0];
        int n = 0;
        while (n < this.values.length) {
            if (this.values[n] == null) {
                throw new MsqlException("No value set for parameter " + (n + 1) + ".");
            }
            string = String.valueOf(string) + this.values[n];
            if (n + 1 < this.constants.length) {
                string = String.valueOf(string) + this.constants[n + 1];
            }
            ++n;
        }
        return string;
    }

    private byte[] getStreamData(InputStream inputStream, int n) throws SQLException {
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < byArray.length) {
            byte by;
            try {
                by = (byte)inputStream.read();
                if (by == -1) {
                    return byArray;
                }
            }
            catch (IOException iOException) {
                throw new MsqlException(iOException);
            }
            byArray[n2] = by;
            ++n2;
        }
        return byArray;
    }

    public void run() {
        Vector<String> vector = new Vector<String>();
        String string = this.statement;
        int n = 0;
        MsqlPreparedStatement msqlPreparedStatement = this;
        synchronized (msqlPreparedStatement) {
            if (this.parsing != 0) {
                Object var6_5 = null;
                return;
            }
            this.parsing = 1;
        }
        while (true) {
            int n2;
            if ((n2 = string.indexOf("?")) < 0) break;
            ++n;
            if (n2 == 0) {
                vector.addElement("");
            } else {
                vector.addElement(string.substring(0, n2));
            }
            if (n2 < string.length() - 1) {
                string = string.substring(n2 + 1);
                continue;
            }
            string = "";
        }
        vector.addElement(string);
        this.values = new String[n];
        this.constants = new String[vector.size()];
        vector.copyInto(this.constants);
        msqlPreparedStatement = this;
        synchronized (msqlPreparedStatement) {
            this.parsing = 2;
            this.notifyAll();
            return;
        }
    }

    public synchronized void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.validateIndex(n);
        byte[] byArray = this.getStreamData(inputStream, n2);
        try {
            this.values[n - 1] = new String(byArray, "8859_1");
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new MsqlException("No ASCII!!!");
        }
    }

    public synchronized void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.validateIndex(n);
        this.values[n - 1] = bigDecimal.toString();
    }

    public synchronized void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new MsqlException("mSQL has no binary data types.");
    }

    public synchronized void setBoolean(int n, boolean bl) throws SQLException {
        this.validateIndex(n);
        if (bl) {
            this.values[n - 1] = "1";
            return;
        }
        this.values[n - 1] = "0";
    }

    public synchronized void setByte(int n, byte by) throws SQLException {
        this.validateIndex(n);
        this.values[n - 1] = String.valueOf(by);
    }

    public synchronized void setBytes(int n, byte[] byArray) throws SQLException {
        this.validateIndex(n);
        try {
            this.values[n - 1] = new String(byArray, "UTF8");
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new MsqlException("UTF8 not supported.");
        }
    }

    public synchronized void setDate(int n, Date date) throws SQLException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yyyy", Locale.US);
        this.validateIndex(n);
        this.values[n - 1] = simpleDateFormat.format(date);
    }

    public synchronized void setDouble(int n, double d) throws SQLException {
        this.validateIndex(n);
        this.values[n - 1] = String.valueOf(d);
    }

    public synchronized void setFloat(int n, float f) throws SQLException {
        this.validateIndex(n);
        this.values[n - 1] = String.valueOf(f);
    }

    public synchronized void setInt(int n, int n2) throws SQLException {
        this.validateIndex(n);
        this.values[n - 1] = String.valueOf(n2);
    }

    public synchronized void setLong(int n, long l) throws SQLException {
        this.validateIndex(n);
        this.values[n - 1] = String.valueOf(l);
    }

    public synchronized void setNull(int n, int n2) throws SQLException {
        this.validateIndex(n);
        this.values[n - 1] = "NULL";
    }

    public synchronized void setObject(int n, Object object) throws SQLException {
        this.validateIndex(n);
        this.values[n - 1] = object.toString();
    }

    public synchronized void setObject(int n, Object object, int n2) throws SQLException {
        switch (n2) {
            case -1: 
            case 1: 
            case 12: {
                if (object instanceof Date) {
                    this.setDate(n, (Date)object);
                    return;
                }
                this.setString(n, object.toString());
                return;
            }
        }
        this.setObject(n, object);
    }

    public synchronized void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.setObject(n, object, n2);
    }

    public synchronized void setShort(int n, short s) throws SQLException {
        this.validateIndex(n);
        this.values[n - 1] = String.valueOf(s);
    }

    public synchronized void setString(int n, String string) throws SQLException {
        this.validateIndex(n);
        this.values[n - 1] = "'" + this.fixString(string) + "'";
    }

    public synchronized void setTime(int n, Time time) throws SQLException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss", Locale.US);
        this.validateIndex(n);
        this.values[n - 1] = simpleDateFormat.format(time);
    }

    public synchronized void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.setLong(n, ((java.util.Date)timestamp).getTime());
    }

    public synchronized void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.validateIndex(n);
        byte[] byArray = this.getStreamData(inputStream, n2);
        try {
            this.values[n - 1] = new String(byArray, "UTF8");
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new MsqlException("UTF8 not supported.");
        }
    }

    private synchronized void validateIndex(int n) throws SQLException {
        while (this.parsing != 2) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (n < 1) {
            throw new MsqlException("Cannot address an index less than 1.");
        }
        if (n > this.values.length) {
            throw new MsqlException("Attempted to assign a value to parameter " + n + " when there are " + "only " + this.values.length + " parameters.");
        }
    }
}

