/*
 * Decompiled with CFR 0.152.
 */
package com.imaginary.sql.msql;

import com.imaginary.sql.msql.MsqlConnection;
import com.imaginary.sql.msql.MsqlException;
import com.imaginary.sql.msql.MsqlInputStream;
import com.imaginary.sql.msql.MsqlOutputStream;
import com.imaginary.sql.msql.MsqlResultSet;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class MsqlStatement
implements Statement {
    private MsqlConnection connection;
    private MsqlResultSet current;
    private String encoding = "8859_1";
    private MsqlInputStream input;
    private int max_field_size;
    private int max_rows = 4096;
    private MsqlOutputStream output;
    private ResultSet result;
    private int row_or_column_count = -1;
    private int timeout;
    private SQLWarning warnings;

    MsqlStatement(MsqlConnection msqlConnection, MsqlInputStream msqlInputStream, MsqlOutputStream msqlOutputStream, String string) throws SQLException {
        this.connection = msqlConnection;
        this.input = msqlInputStream;
        this.output = msqlOutputStream;
        this.encoding = string;
    }

    private void closeAllResults() {
        if (this.result != null) {
            try {
                this.result.close();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            this.result = null;
        }
        if (this.current != null) {
            try {
                this.current.close();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            this.current = null;
        }
    }

    private boolean sendSQL(String string) throws SQLException {
        String string2;
        try {
            this.output.writeString("3 " + string, this.encoding);
            string2 = this.input.readString(this.encoding);
        }
        catch (IOException iOException) {
            try {
                this.connection.close();
                this.close();
            }
            catch (SQLException sQLException) {}
            throw new MsqlException(iOException);
        }
        int n = string2.indexOf(58);
        if (n == -1) {
            throw new SQLException("Incorrect mSQL response.");
        }
        this.row_or_column_count = Integer.parseInt(string2.substring(0, n));
        if (this.row_or_column_count == -1) {
            throw new SQLException(string2.substring(2));
        }
        n = string2.indexOf(58, 2);
        if (n == -1) {
            return false;
        }
        try {
            this.row_or_column_count = Integer.parseInt(string2.substring(2, n));
        }
        catch (NumberFormatException numberFormatException) {
            this.row_or_column_count = 0;
            return false;
        }
        return true;
    }

    public synchronized ResultSet executeQuery(String string) throws SQLException {
        this.closeAllResults();
        if (!this.sendSQL(string)) {
            throw new SQLException("Non-query sent to executeQuery().");
        }
        this.current = new MsqlResultSet(this, this.input, this.row_or_column_count, this.encoding);
        return this.current;
    }

    public int executeUpdate(String string) throws SQLException {
        this.closeAllResults();
        if (!this.sendSQL(string)) {
            return this.row_or_column_count;
        }
        throw new SQLException("Query sent to executeUpdate().");
    }

    public boolean execute(String string) throws SQLException {
        this.closeAllResults();
        if (!this.sendSQL(string)) {
            return false;
        }
        this.current = new MsqlResultSet(this, this.input, this.row_or_column_count, this.encoding);
        this.result = this.current;
        return true;
    }

    MsqlConnection getConnection() {
        return this.connection;
    }

    public void close() throws SQLException {
        if (this.current != null) {
            try {
                this.current.close();
            }
            catch (SQLException sQLException) {
                this.current = null;
                throw sQLException;
            }
            this.current = null;
        }
    }

    public ResultSet getResultSet() throws SQLException {
        ResultSet resultSet = this.result;
        this.result = null;
        return resultSet;
    }

    public int getUpdateCount() throws SQLException {
        int n = this.row_or_column_count;
        if (this.result != null) {
            n = -1;
        }
        this.row_or_column_count = -1;
        return n;
    }

    public boolean getMoreResults() throws SQLException {
        return this.result != null;
    }

    public int getMoreCounts() throws SQLException {
        return -1;
    }

    public int getMaxFieldSize() throws SQLException {
        return this.max_field_size;
    }

    public void setMaxFieldSize(int n) throws SQLException {
        this.max_field_size = n;
    }

    public int getMaxRows() throws SQLException {
        return this.max_rows;
    }

    public void setMaxRows(int n) throws SQLException {
        this.max_rows = n;
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        throw new SQLException("mSQL does not support escape processing.");
    }

    public int getQueryTimeout() throws SQLException {
        return this.timeout;
    }

    public void setQueryTimeout(int n) throws SQLException {
        this.timeout = n;
    }

    public void cancel() {
    }

    public final SQLWarning getWarnings() throws SQLException {
        return this.warnings;
    }

    public void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    public void setCursorName(String string) throws SQLException {
        throw new SQLException("mSQL does not support cursors.");
    }
}

