/*
 * Decompiled with CFR 0.152.
 */
package com.imaginary.sql.msql;

import com.imaginary.sql.msql.MsqlDatabaseMetaData;
import com.imaginary.sql.msql.MsqlException;
import com.imaginary.sql.msql.MsqlInputStream;
import com.imaginary.sql.msql.MsqlOutputStream;
import com.imaginary.sql.msql.MsqlPreparedStatement;
import com.imaginary.sql.msql.MsqlStatement;
import com.imaginary.sql.msql.MsqlTableList;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Properties;

public class MsqlConnection
implements Connection {
    private String catalog;
    private boolean connecting = true;
    private Socket connection;
    private Statement current;
    private String encoding = "8859_1";
    private MsqlInputStream input;
    private int isolation;
    private MsqlOutputStream output;
    protected String url;
    protected String user;
    protected int version;
    protected String version_string;
    private SQLWarning warnings;

    MsqlConnection(String string, String string2, int n, String string3, Properties properties) throws SQLException {
        this.url = string;
        this.user = (String)((Hashtable)properties).get("user");
        if (this.user == null || this.user.equals("")) {
            this.user = "nobody";
        }
        this.connect(string2, n, this.user);
        this.selectDatabase(string3);
        this.connecting = false;
        this.encoding = (String)((Hashtable)properties).get("encoding");
        if (this.encoding == null) {
            this.encoding = "8859_1";
            return;
        }
        try {
            byte[] byArray = new byte[]{112};
            String string4 = new String(byArray, this.encoding);
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException(unsupportedEncodingException.getMessage());
        }
    }

    public synchronized boolean isClosed() throws SQLException {
        this.awaitConnection();
        return this.connection == null;
    }

    public boolean isReadOnly() throws SQLException {
        return false;
    }

    public boolean getAutoCommit() throws SQLException {
        return true;
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        if (bl) {
            return;
        }
        throw new SQLException("mSQL must always be auto-commit = true.");
    }

    public synchronized String getCatalog() throws SQLException {
        return this.catalog;
    }

    public synchronized void setCatalog(String string) throws SQLException {
        this.catalog = string;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return new MsqlDatabaseMetaData(this);
    }

    public void setReadOnly(boolean bl) throws SQLException {
        throw new SQLException("mSQL does not support read-only mode.");
    }

    ResultSet getTables(String string) throws SQLException {
        this.awaitConnection();
        MsqlConnection msqlConnection = this;
        synchronized (msqlConnection) {
            try {
                this.output.writeString("5\n", this.encoding);
            }
            catch (IOException iOException) {
                throw new MsqlException(iOException);
            }
            MsqlTableList msqlTableList = new MsqlTableList(this.input, string);
            Object var4_5 = null;
            return msqlTableList;
        }
    }

    public synchronized int getTransactionIsolation() throws SQLException {
        return this.isolation;
    }

    public synchronized void setTransactionIsolation(int n) throws SQLException {
        this.isolation = n;
    }

    public String getUser() throws SQLException {
        this.awaitConnection();
        return this.user;
    }

    public synchronized SQLWarning getWarnings() throws SQLException {
        return this.warnings;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void awaitConnection() throws MsqlException {
        var1_1 = this;
        synchronized (var1_1) {
            while (true) lbl-1000:
            // 3 sources

            {
                if (!this.connecting) {
                    return;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException var3_2) {
                    if (this.connecting) ** break;
                    continue;
                    throw new MsqlException(var3_2);
                }
                break;
            }
            ** GOTO lbl-1000
        }
    }

    private void cleanConnection() {
        MsqlConnection msqlConnection = this;
        synchronized (msqlConnection) {
            if (this.current != null) {
                try {
                    this.current.close();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
                this.current = null;
            }
            this.connecting = false;
            this.connection = null;
        }
        this.input = null;
        this.output = null;
        this.user = null;
    }

    public synchronized void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    public synchronized void close() throws SQLException {
        IOException iOException = null;
        this.awaitConnection();
        if (this.isClosed()) {
            throw new SQLException("This Connection is already closed.");
        }
        if (this.current != null) {
            this.current.close();
            this.current = null;
        }
        try {
            this.output.writeString("1", this.encoding);
            this.output.flush();
            this.output.close();
            this.output = null;
        }
        catch (IOException iOException2) {
            this.output = null;
            iOException = iOException2;
        }
        try {
            this.input.close();
            this.input = null;
        }
        catch (IOException iOException3) {
            this.input = null;
            iOException = iOException3;
        }
        try {
            this.connection.close();
        }
        catch (IOException iOException4) {
            this.connection = null;
            throw new MsqlException(iOException4);
        }
        if (iOException != null) {
            throw new MsqlException(iOException);
        }
    }

    public void commit() throws SQLException {
    }

    private void connect(String string, int n, String string2) throws SQLException {
        try {
            this.connection = new Socket(string, n);
            this.input = new MsqlInputStream(this.connection.getInputStream());
            this.output = new MsqlOutputStream(this.connection.getOutputStream());
            String string3 = this.input.readString(this.encoding);
            if (string3.startsWith("0:22:") || string3.startsWith("0:23:")) {
                this.version = 2;
                this.version_string = string3.substring(5);
            } else if (string3.startsWith("0:6:")) {
                this.version = 1;
                this.version_string = string3.substring(4);
            } else {
                throw new SQLException("Unsupported mSQL version.");
            }
            this.output.writeString(string2, this.encoding);
            string3 = this.input.readString(this.encoding);
            if (!string3.startsWith("-100:")) {
                throw new SQLException("Access to server denied.");
            }
        }
        catch (IOException iOException) {
            this.cleanConnection();
            throw new SQLException("Connection failed.");
        }
    }

    public Statement createStatement() throws SQLException {
        this.awaitConnection();
        MsqlConnection msqlConnection = this;
        synchronized (msqlConnection) {
            if (this.current != null) {
                try {
                    this.current.close();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
            Statement statement = this.current = new MsqlStatement(this, this.input, this.output, this.encoding);
            Object var3_4 = null;
            return statement;
        }
    }

    public String nativeSQL(String string) throws SQLException {
        return string;
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        throw new SQLException("mSQL does not support stored procedures.");
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        return new MsqlPreparedStatement(this, string, this.input, this.output, this.encoding);
    }

    public void rollback() throws SQLException {
        throw new SQLException("mSQL exception: mSQL does not support rollbacks.");
    }

    private void selectDatabase(String string) throws MsqlException {
        try {
            this.output.writeString("2 " + string, this.encoding);
            String string2 = this.input.readString(this.encoding);
            if (string2.startsWith("-1:")) {
                throw new MsqlException(string2);
            }
        }
        catch (IOException iOException) {
            this.cleanConnection();
            throw new MsqlException(iOException);
        }
    }
}

