/** TinyBallWorld
 * The first example illustrating the use of BWCanvas and Ball objects
 * launches four balls in a symmetric pattern
 * @author Rhys Price Jones (original design by Dan Hutchins)
 * @version 15xi08
 */
package lab11;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class TinyBallWorld extends JApplet
{
    protected JButton goButton;              // only one this time
    protected JPanel buttonPanel;            // but room for more if we want it
    protected BWCanvas canvas;               // where the balls will bounce
    protected Manager ballDispatcher;        // will synchronize draw requests
    protected javax.swing.Timer animationTimer;   // will control the animation
                                                  // by triggering redraw events
    
    public void init()
    {
	// animationTimer will trigger 50 redraws per second
	// Thus giving a frame rate of 50 frames/second
	animationTimer = new Timer(50, new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    canvas.repaint();
		}
	    });
	
	// To synchronize draw() messages to all the currently registered balls:
	ballDispatcher = new Manager();

	canvas = new BWCanvas(ballDispatcher);   
	// canvas needs to know who will issue the draw() messages to the balls
	// Notice, the canvas does *not* need to know anything 
	// about the individual balls!
	// That's the beauty of the Observer-Observed design pattern
	Container contentPane = getContentPane(); 
	// Get a reference to the frame's content pane
	// By default, contentPane will have BorderLayout
	contentPane.add("Center", canvas); // add the canvas to the content pane
	buttonPanel = new JPanel();  // create a JPanel object
	buttonPanel.setBackground(Color.gray);
	buttonPanel.setLayout(new GridLayout(0,1));
	contentPane.add("East",buttonPanel);  
	// add it to the right side of the content pane

	goButton = new JButton("Go!"); // create a JButton object
	buttonPanel.add(goButton);  // add it to the button panel
	
	goButton.addActionListener(new ActionListener(){
		// The actionPerformed is to launch four balls
		public void actionPerformed(ActionEvent e){
		    int xc = (canvas.getWidth()-15)/2;
		    int yc = (canvas.getHeight()-15)/2;
		    
		    Ball b1 = new Ball(canvas, xc, yc, 
				       3, -3, 30, Color.black);
		    ballDispatcher.register(b1);
		    Ball b2 = new Ball(canvas, xc, yc, 
				       -3, -3, 30, Color.blue);
		    ballDispatcher.register(b2);
		    Ball b3 = new Ball(canvas, xc, yc, 
				       -3, 3, 30, Color.red);
		    ballDispatcher.register(b3);
		    Ball b4 = new Ball(canvas, xc, yc, 
				       3, 3, 30, Color.yellow);
		    ballDispatcher.register(b4);
		}
	    });
	setSize(500,400);
	setVisible(true); // make the applet visible on the screen
    }
    
    public void start(){
	animationTimer.start();
    }
    
    public void stop(){
	// currently not used, but... you never know!
	animationTimer.stop();
    }
}