/**
 * Manager: stores any number of CanBeTold objects 
 * can register another CanBeTold object
 * can tell all its CanBeTold objects to respond()
 * can get rid of ALL its CanBeTold objects
 * Part of an implementation of the Observer-Observed design pattern
 * @author Rhys Price Jones
 * @version 15xi08
 */
package lab11;

import java.util.Vector;

/**
 * @author rhyspj
 *
 */
public class Manager {
	private Vector<CanBeTold> myThings = new Vector<CanBeTold>();
	  public void register(CanBeTold thing){
	      myThings.add(thing);
	  }

	  public void clear(){
	      myThings = new Vector<CanBeTold>();
	  }

	  public void tellAll(){
	      for (CanBeTold thing : myThings) {
		  thing.respond();
	      }
	  }


}
