%function [imageStack, manifoldCoordinates] = manVisMakeSampleData();
%
%  make one (boring!) image manifold.

function [imageStack, manifoldCoordinates] = manVisMakeSampleData();

manifoldCoordinates = rand(2,100);  % randomly create 100 manifold coordinates

imageStack = zeros(120,120,100);    % initialize image stack

for ix = 1:100                      % now create imagess parameterized by manfold coordinates
    im = zeros(120,120);
    coords = manifoldCoordinates(:,ix);
    coords = 1+floor(coords*120);
    im(coords(1),coords(2)) = 1;
    distIm = bwdist(im);
    im = distIm<sqrt(coords(2));
    imageStack(:,:,ix) = im;
end