function [] = manVisGUICallback();

myData = get(gcf,'UserData');
currPt = get(myData.pointAxis,'CurrentPoint');
currPt = currPt(1,1:2);  % curr point is more complicated than you'd think

% Check if current point in bound, at current zoom of axis
xLim = get(myData.pointAxis,'Xlim');
yLim = get(myData.pointAxis,'Ylim');
if ~(xLim(1)<currPt(1) & currPt(1)<xLim(2) &...
     yLim(1)<currPt(2) & currPt(2)<yLim(2))
 return
end

indexPt = floor(currPt.*500)+1;  % because our image index map is 500x500

%find index of closest point

idx = myData.indexImage(indexPt(1),indexPt(2));

% get new image

if length(size(myData.images)) == 3
    newIm = repmat(myData.images(:,:,idx),[1 1 3]);
else
    newIm = myData.images(:,:,:,idx);
end

% slow way:
subplot(1,2,2);
image(newIm);
% fast way
%set(myData.imageHandle,'CData',newIm);

title(idx);