% Written by Robert Pless and Richard Souvenir, 2005-2011.
%
% The following code demonstrates the use of a tool for visualizing image
% manifolds.

% First, make an image manifold.  
% Probably, if you are looking to use this tool, you have a set of images
% and have some way of infering image coordinates from those images.

[imageStack, manifoldCoordinates] = manVisMakeSampleData();

% The inputs to manVisGUI are the imageStack and the
% manifoldCoordinates.  There should be two coordinates for each image, and
% the same number of images as there are coordinate-pairs.

manVisGUI(imageStack,manifoldCoordinates);

% You can also make a web-page that offers the same visualization
% functionality.  This creates many files (one per example manifold image),
% so I encourage you to create a *new* directory, for example 'manifoldWebVis'
% then pass in that directory as the third argument.  This path can either
% be relative to your current directory, or an absolute path name.

dirPath = 'manifoldWebVis';

manVisWebGUI(imageStack, manifoldCoordinates, dirPath)
