WITH Ada.Text_IO; USE Ada.Text_IO;
WITH Currency; USE Currency;
WITH Dates; USE Dates;
WITH Persons; USE Persons;
WITH Personnel; USE Personnel;
WITH Payroll; USE Payroll;
PROCEDURE Use_Payroll IS
------------------------------------------------------------------
--| demonstrates the use of tagged types
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: September 1995                                     
------------------------------------------------------------------
  
  -- demonstrates the use of tagged types
  
  George: Person;
  Mary  : Employee;
  Martha: Professional;
  Virginia: Sales;
  Herman: Clerical;
  
BEGIN -- Use_Payroll

  -- first construct all the people
  
  George := Persons.Constructors.MakePerson(
             Name      => "George",
             Gender    => Male,
             BirthDate => MakeDate(1971,11,2));

  Mary := Personnel.Constructors.MakeEmployee(
             Name      => "Mary",  
             Gender    => Female,
             BirthDate => MakeDate(1950,10,21),
             ID        => 1234,
             StartDate => MakeDate(1989,7,1));
 
  Martha := Payroll.Constructors.MakeProfessional(
             Name        => "Martha",
             Gender      => Female,
             BirthDate   => MakeDate(1947,7,8),
             ID          => 2222,
             StartDate   => MakeDate(1985,6,6),
             MonthSalary => MakeCurrency(50000.00));

  Virginia := Payroll.Constructors.MakeSales(
             Name       => "Virginia",
             Gender     => Female,
             BirthDate  => MakeDate(1955,2,1),
             ID         => 3456,
             StartDate  => MakeDate(1990,1,1),
             WeekSalary => MakeCurrency(2500.00),
             CommRate   => 0.25); 
 
  Herman := Payroll.Constructors.MakeClerical(
             Name       => "Herman",
             Gender     => Male,
             BirthDate  => MakeDate(1975,5,13),
             ID         => 1557,
             StartDate  => MakeDate(1991,7,1),
             HourlyWage => MakeCurrency(7.50));
  
  -- Now display them all. Note that each Put is a different
  -- primitive operation.
  
  Put(Item => George);
  Ada.Text_IO.Put_Line(Item => "------------------------");
  Put(Item => Mary);  
  Ada.Text_IO.Put_Line(Item => "------------------------");
  Put(Item => Martha);
  Ada.Text_IO.Put_Line(Item => "------------------------");
  Put(Item => Virginia);
  Ada.Text_IO.Put_Line(Item => "------------------------");
  Put(Item => Herman);  
  Ada.Text_IO.Put_Line(Item => "------------------------");
 
END Use_Payroll; 
