WITH Ada.Text_IO;
WITH Ada.Float_Text_IO;
WITH Vectors; 
USE TYPE Vectors.Vector;
PROCEDURE Test_Vectors IS
------------------------------------------------------------------------
--| Example of use of Vector operations
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: October 1995                                     
------------------------------------------------------------------------

  V1: Vectors.Vector(1..4) := (1.0, 0.0, -2.0, 3.0);
  V2: Vectors.Vector(1..4) := (0.0, -5.0, 3.0, 1.0);
  V3: Vectors.Vector(1..3) := (1.0, 2.0, 3.0);
  V4: Vectors.Vector(1..4);

  PROCEDURE DisplayVector(V: Vectors.Vector) IS
  BEGIN
    FOR Component IN V'First..V'Last LOOP
      Ada.Float_Text_IO.Put(Item => V(Component), Fore=>5, Aft=>2, Exp=>0);
    END LOOP;
  END DisplayVector;

BEGIN -- Test_Vectors

  Ada.Text_IO.Put(Item => "V1       = ");
  DisplayVector(V => V1);
  Ada.Text_IO.New_Line;

  Ada.Text_IO.Put(Item => "V2       = ");
  DisplayVector(V => V2);
  Ada.Text_IO.New_Line;

  Ada.Text_IO.Put(Item => "V3       = ");
  DisplayVector(V => V3);
  Ada.Text_IO.New_Line;

  V4 := 3.0 + V1;

  Ada.Text_IO.Put(Item => "3.0 + V1 = ");
  DisplayVector(V => V4);
  Ada.Text_IO.New_Line;

  V4 := V1 + V2;

  Ada.Text_IO.Put(Item => "V1 + V2  = ");
  DisplayVector(V => V4);
  Ada.Text_IO.New_Line;

  Ada.Text_IO.Put(Item => "V1 * V2  = ");
  Ada.Float_Text_IO.Put(Item => V1 * V2, Fore=>1, Aft=>2, Exp=>0);
  Ada.Text_IO.New_Line;

  V4 := V1 + V3;   -- should raise exception!

END Test_Vectors;
