WITH Ada.Text_IO;
WITH Ada.Integer_Text_IO;
WITH Rationals;   
USE TYPE Rationals.Rational; -- Ada 95: USEs infix operators only
WITH Rationals.IO; 
PROCEDURE Test_Rationals_3 IS
------------------------------------------------------------------
--|
--| Tests the package Rationals,
--| this time with Ada 95 USE TYPE clause and an exception handler
--|
--| Author: Michael B. Feldman, The George Washington University
--| Last Modified: July 1995
--|
------------------------------------------------------------------

-- Note: the Rational infix operators (+, <=, etc.) can be used
-- without qualification, but not the Rational type name itself,
-- or other subprograms like Numer, or the exported exception 
-- ZeroDenominator, which must still be qualified.
  
  A: Rationals.Rational;
  B: Rationals.Rational;
  C: Rationals.Rational;
  D: Rationals.Rational;
  E: Rationals.Rational;

BEGIN -- Test_Rationals_3

  A := 1/3;
  B := 2/(-4);
  Ada.Text_IO.Put(Item => "A = ");
  Rationals.IO.Put(Item => A);
  Ada.Text_IO.New_Line;
  Ada.Text_IO.Put(Item => "B = ");
  Rationals.IO.Put(Item => B);
  Ada.Text_IO.New_Line;

  -- Read in rational numbers C and D.   
  Ada.Text_IO.Put(Item => "Enter rational number C > ");
  Rationals.IO.Get(Item => C);
  Ada.Text_IO.Put(Item => "Enter rational number D > ");
  Rationals.IO.Get(Item => D);
  Ada.Text_IO.New_Line;

  E := A + B;                   -- form the sum   
  Ada.Text_IO.Put(Item => "E = A + B is ");
  Rationals.IO.Put(Item => E);  
  Ada.Text_IO.New_Line;

  Ada.Text_IO.Put(Item => "A + E * B is ");
  Rationals.IO.Put(Item => A + E * B);
  Ada.Text_IO.New_Line;
  
  Ada.Text_IO.Put(Item => "B's numerator is ");
  Ada.Integer_Text_IO.Put(Item => Rationals.Numer(B), Width => 1);
  Ada.Text_IO.New_Line;
  
EXCEPTION
  WHEN Rationals.ZeroDenominator =>
    Ada.Text_IO.Put(Item => 
      "Zero not allowed in denominator; terminating program.");
    Ada.Text_IO.New_Line;
END Test_Rationals_3;
