WITH Types; USE Types;
PACKAGE Tellers IS
------------------------------------------------------------------------
--| Teller package for bank siumulation
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: January 1996                                   
------------------------------------------------------------------------
  
  TASK TYPE Teller (TellerID: TellerRange) IS
    -- Entries to do simple transactions and return status
    ENTRY NewAcct (ID   : OUT CustID;
                   Stat: OUT Status);
    ENTRY Deposit (ID   : CustID;
                   Val  : IN Money;
                   Stat: OUT Status);
    ENTRY Withdraw (ID   : CustID;
                    Val  : IN Money;
                   Stat: OUT Status);
    ENTRY Balance (ID   : CustID;
                   Stat: OUT Status);
  END Teller;

  -- declare tellers and give them "names"
  A: ALIASED Teller(TellerID => 'A');
  B: ALIASED Teller(TellerID => 'B');
  C: ALIASED Teller(TellerID => 'C');

  TYPE TellerPointer IS ACCESS ALL Teller;

  -- a bank full of tellers
  TellerGroup : ARRAY (TellerRange) OF TellerPointer :=
    (A'Access, B'Access, C'Access);

END Tellers;
