WITH Employees;
PACKAGE Tables IS
------------------------------------------------------------------
--| ADT for simple employee table type
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: October 1995                                     
------------------------------------------------------------------

  SUBTYPE KeyType IS Employees.IDType; 
  SUBTYPE ElementType IS Employees.Employee;

  TYPE TableType IS LIMITED PRIVATE;

  PROCEDURE InitializeTable (T : IN OUT TableType);
  -- Pre : None
  -- Post: T is an initialized Table.
     
  PROCEDURE Insert (T       : IN OUT TableType; 
                    E       : ElementType;
                    Success : OUT Boolean);
  --  Pre : T is initialized and Target is defined
  --  Post: Inserts element E into table T 
  --    Success is True if insertion is performed, and False
  --    if T already has an element with the same key as E.
     
  PROCEDURE Retrieve (T       : TableType;
                      Target  : KeyType;
                      E       : OUT ElementType;
                      Success : OUT Boolean);
  --  Pre : T is initialized and Target is defined
  --  Post: Copies into E the element of T whose key is Target. 
  --    Success is True if the copy is performed, and False
  --    if T has no element whose key is Target.
     
  PROCEDURE Delete (T       : IN OUT TableType; 
                    Target  : KeyType;
                    Success : OUT Boolean);
  --  Pre : T is initialized and Target is defined
  --  Post: Deletes from T the element with key Target
  --    Success is True if deletion is performed, and False 
  --    if T has no element whose key is Target.

  PROCEDURE Traverse (T : TableType);
  --  Pre : T is initialized.
  --  Post: The elements of T are displayed in order by key.

PRIVATE

  MaxElements: CONSTANT Positive := 25;

  SUBTYPE TableIndex IS Natural RANGE 1..MaxElements;
  SUBTYPE TableRange IS Natural RANGE 0..MaxElements;  
  TYPE Elements IS ARRAY(TableIndex) OF ElementType;
  
  TYPE TableType IS RECORD
    ActualElements: Elements;
    CurrentSize:    TableRange := 0;
  END RECORD;

END Tables;
